﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;

namespace SCAN
{
    class OutboundItemDisplay
    {
        public string No { get; set; }
        public string Product_date { get; set; }
        public string Customer_id { get; set; }
        public string Location_id { get; set; }
        public string Pkg_qty_plan { get; set; }
        public string Qty_plan { get; set; }
        public string Pkg_qty_act { get; set; }
        public string Qty_act { get; set; }

        public OutboundItemDisplay()
        {
            No = "";
            Product_date = "";
            Customer_id = "";
            Location_id = "";
            Pkg_qty_plan = "";
            Pkg_qty_act = "";
            Qty_plan = "";
            Qty_act = "";
        }

        public static List<OutboundItemDisplay> LoadCollectionData(List<lib.db.HT_OB> items)
        {
            List<OutboundItemDisplay> displayItems = new List<OutboundItemDisplay>();
            int i = 0;
            foreach (lib.db.HT_OB item in items)
            {
                displayItems.Add(new OutboundItemDisplay()
                {
                    No = (++i).ToString(),
                    Product_date = item.__COLUMNS["product_date"],
                    Customer_id = item.__COLUMNS["customer_id"],
                    Location_id = item.__COLUMNS["location_id"],
                    Pkg_qty_plan = item.__COLUMNS["pkg_qty_plan"],
                    Qty_plan = item.__COLUMNS["pc_qty_plan"],
                    Pkg_qty_act = item.__COLUMNS["pkg_qty_act"],
                    Qty_act = item.__COLUMNS["pc_qty_act"]
                });
            }

            return displayItems;
        }

        public static List<OutboundItemDisplay> LoadCollectionData(List<lib.db.HT_OB_RC> items)
        {
            List<OutboundItemDisplay> displayItems = new List<OutboundItemDisplay>();
            int i = 0;
            foreach (lib.db.HT_OB_RC item in items)
            {
                displayItems.Add(new OutboundItemDisplay()
                {
                    No = (++i).ToString(),
                    Product_date = item.__COLUMNS["product_date"],
                    Location_id = item.__COLUMNS["location_id"],
                    Pkg_qty_plan = item.__COLUMNS["pkg_qty_plan"],
                    Qty_plan = item.__COLUMNS["pc_qty_plan"],
                    Pkg_qty_act = item.__COLUMNS["pkg_qty_act"],
                    Qty_act = item.__COLUMNS["pc_qty_act"]
                });
            }

            return displayItems;
        }

        public static List<OutboundItemDisplay> LoadCollectionData(List<lib.db.HT_OB_RP> items)
        {
            List<OutboundItemDisplay> displayItems = new List<OutboundItemDisplay>();
            int i = 0;
            foreach (lib.db.HT_OB_RP item in items)
            {
                displayItems.Add(new OutboundItemDisplay()
                {
                    No = (++i).ToString(),
                    Product_date = item.__COLUMNS["product_date"],
                    Location_id = item.__COLUMNS["location_id"],
                    Pkg_qty_plan = item.__COLUMNS["pkg_qty_plan"],
                    Qty_plan = item.__COLUMNS["pc_qty_plan"],
                    Pkg_qty_act = item.__COLUMNS["pkg_qty_act"],
                    Qty_act = item.__COLUMNS["pc_qty_act"]
                });
            }

            return displayItems;
        }
    }
}
