﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Globalization;
using System.Windows;
using System.Text.RegularExpressions;

namespace SCAN
{
    public partial class Form_StockTakingDetail : Form
    {
        private lib.LogWriter logger = lib.LogWriter.getInstance();

        // Master table
        private Dictionary<string, int> __PackageTypes = lib.db.PackageType.getBoxSizeList();
        private Dictionary<string, lib.db.Item> __ItemList = lib.db.Item.getItemList();
        private Dictionary<string, lib.db.Location> __LocationList = lib.db.Location.getLocationList();

        private lib.BtScanLib btScanLib;
        private int packing_size = 0;

        public Form_StockTakingDetail(List<StockManagementItemDisplay> items, int index)
        {
            InitializeComponent();

            lbUser.Text = Form_Login._Form_LoginInstance.userName;

            // set all display element
            StockManagementItemDisplay item = items.ElementAt(index);
            lblProductCode.Text = item.Item_id;
            lblProductName.Text = item.Item_name;
            lblLocation.Text = item.Location_id;
            lblProductDate.Text = DateTime.ParseExact(item.Product_date, "yyyyMMdd", null).ToString("dd/MM/yyyy");
            lblPsQty.Text = item.Qty;
            txtPkgQty.Text = item.Pkg_qty;
            txtPsQty.Text = item.Qty;

            packing_size = __PackageTypes[item.Item_id];
        }

        private void Form_Load(object sender, EventArgs e)
        {
            // set screen resolution
            if (System.Windows.Forms.Screen.PrimaryScreen.Bounds.Width == 240)
            {
                resolution.ScreenSize.VGAtoQVGA(this);
            }

            // disable maximize and minimize button
            this.MaximizeBox = !this.MaximizeBox;
            this.MinimizeBox = !this.MinimizeBox;
        }

        private void btnBack_Click(object sender, EventArgs e)
        {
            Form_StockTaking._Form_Instance.Show();
            this.Close();
        }

        private void txtPkgQty_KeyUp(object sender, KeyEventArgs e)
        {
            TextBox tb = (TextBox)sender;
            string pattern = @"^[\d\.]+$";
            Match m = Regex.Match(tb.Text, pattern, RegexOptions.IgnoreCase);
            if (!m.Success) return;

            try
            {
                txtPsQty.Text = String.Format("{0:0.##}", (int)Math.Ceiling(double.Parse(tb.Text) * packing_size));
            }
            catch (Exception) { }
        }

        private void txtPsQty_KeyUp(object sender, KeyEventArgs e)
        {
            TextBox tb = (TextBox)sender;
            string pattern = @"^[\d\.]+$";
            Match m = Regex.Match(tb.Text, pattern, RegexOptions.IgnoreCase);
            if (!m.Success) return;

            try
            {
                txtPkgQty.Text = String.Format("{0:0.##}", double.Parse(tb.Text) / packing_size);
            }
            catch (Exception) { }
        }

        private void btnConfirm_Click(object sender, EventArgs e)
        {
            lib.db.HT_ST table = new SCAN.lib.db.HT_ST();
            Dictionary<string, string> cols = new Dictionary<string, string>(table.__COLUMNS);
            cols["item_id"] = lblProductCode.Text;
            cols["item_dvsn_id"] = __ItemList[lblProductCode.Text].__COLUMNS["division"];
            cols["location_id"] = lblLocation.Text;
            cols["location_dvsn_id"] = __LocationList[lblLocation.Text].__COLUMNS["division"];
            cols["pkg_qty_act"] = txtPkgQty.Text;
            cols["pkg_type_act"] = "box";
            cols["pc_qty_act"] = txtPsQty.Text;
            cols["product_date"] = DateTime.ParseExact(lblProductDate.Text, "dd/MM/yyyy", null).ToString("yyyyMMdd");
            cols["status"] = "Complete";
            cols["create_date"] = DateTime.Now.ToString("yyyyMMdd");
            cols["create_time"] = DateTime.Now.ToString("HHmmdd");
            cols["create_by"] = Form_Login._Form_LoginInstance.userName;
            cols.Remove("id");
            cols.Remove("update_date");
            cols.Remove("update_time");
            cols.Remove("update_by");

            table.add(cols);

            Form frm = new Form_Msg("Data save completed.", Color.Black);
            frm.ShowDialog();

            Form_StockTaking._Form_Instance.Show();
            this.Close();
        }

    }
}