﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SCAN
{
    public partial class Form_InboundSimpleConfirm : Form
    {

        private static lib.LogWriter logger = lib.LogWriter.getInstance();

        private List<lib.db.HT_IB> checkInDB;
        private List<lib.db.HT_IB> inboundItems;
        private int currentItem; // zero base item index
        private int packing_size; // zero base item index
        bool isModified = false;

        // Master table
        private Dictionary<string, int> __PackageTypes = lib.db.PackageType.getBoxSizeList();
        private Dictionary<string, lib.db.Item> __ItemList = lib.db.Item.getItemList();

        public Form_InboundSimpleConfirm(string message, Color color, List<lib.db.HT_IB> inboundItems, int selectedIndex)
        {
            InitializeComponent();

            //lblMessage.Text = message;
            lblMessage.ForeColor = color;
            this.inboundItems = inboundItems;
            this.currentItem = selectedIndex;
            this.packing_size = __PackageTypes[inboundItems.ElementAt(selectedIndex).__COLUMNS["item_id"]];

            lblItem.Text = inboundItems.ElementAt(selectedIndex).__COLUMNS["item_id"];
            qty_inbound.Text = inboundItems.ElementAt(selectedIndex).__COLUMNS["pkg_qty_act"];
            lbltype.Text = "Box";
            radioButton1.Text = "Box(" + packing_size.ToString() + " Pcs)";
        }

        private void btnOk_Click(object sender, EventArgs e)
        {

            string new_qty = qty_inbound.Text;

            if (new_qty == "0" || new_qty.Length == 0)
            {
                Form frm = new Form_Msg("Check input Qty !!!", Color.Red);
                frm.ShowDialog();
                frm.Dispose();
            }
            else
            {
                try
                {
                    float pkg_qty_act = 0;
                    float pc_qty_act = 0;
                    string type_ib = lbltype.Text;

                    if (type_ib == "Box")
                    {
                        pkg_qty_act = float.Parse(new_qty);
                        pc_qty_act = float.Parse(new_qty) * packing_size;
                    }

                    if (type_ib == "Pcs")
                    {
                        pkg_qty_act = float.Parse(new_qty) / packing_size;
                        pc_qty_act = int.Parse(new_qty);
                    }

                    lib.db.HT_IB ib = inboundItems.ElementAt(currentItem);
                    //Dictionary<string, string> cols = new Dictionary<string, string>(ib.__COLUMNS);
                    //checkInDB = new List<lib.db.HT_IB>();

                    /*
                     * List<string[]> rows = (new lib.db.HT_IB()).get(
                        (new lib.db.HT_IB()).__COLUMNS
                        , String.Format("product_date='{0}' AND item_id='{1}' AND customer_id='{2}' AND status='{3}' AND sync='{4}' AND create_date='{5}'"
                            , ib.__COLUMNS["product_date"]
                            , ib.__COLUMNS["item_id"]
                            , ib.__COLUMNS["customer_id"]
                            , ""
                            , "0"
                            , ib.__COLUMNS["create_date"]
                            )
                        , null, null, null);
                     * */

                    //if (rows.Count() == 0)
                   // {
                        ib.__COLUMNS["location_id"] = "A1";
                        ib.__COLUMNS["location_dvsn_id"] = "1";
                        ib.__COLUMNS["status"] = "Confirm";

                        //if (new_qty != ib.__COLUMNS["pkg_qty_act"])
                        //{
                        ib.__COLUMNS["pkg_qty_act"] = pkg_qty_act.ToString();
                        ib.__COLUMNS["pc_qty_act"] = pc_qty_act.ToString();
                        //}

                        ib.__COLUMNS.Remove("id");
                        ib.__COLUMNS.Remove("update_date");
                        ib.__COLUMNS.Remove("update_time");
                        ib.__COLUMNS.Remove("update_by");

                        int ret = ib.add(ib.__COLUMNS);

                        logger.Log("ret=" + ret);
                        if (ret == 1)
                        {
                            // update location last
                            (new lib.db.Item()).set(
                                new Dictionary<string, string> { { "location_last", "A1" } },
                                "id='" + ib.__COLUMNS["item_id"] + "'"
                                );
                            // update item back to buffer list
                            inboundItems[currentItem] = ib;
                            Form_InboundSimple.inboundItems = inboundItems;                      
                            //Form frm = new Form_Msg("Confirmed", Color.Black);
                            //frm.ShowDialog();
                            this.Close();
                            return;
                        }
                        else
                        {
                            Form frm = new Form_Msg("Error Inbound Confirm", Color.Red);
                            frm.ShowDialog();
                            frm.Dispose();
                            this.Close();
                            return;
                        }
                   // }


                    /*
                    if (rows.Count() == 1)
                    {
                        ib.__COLUMNS["pkg_qty_act"] = pkg_qty_act.ToString();
                        ib.__COLUMNS["pc_qty_act"] = pc_qty_act.ToString();

                        string sql = @"UPDATE HT_IB 
                    SET status='{0}'
                        , pkg_qty_act='{1}'
                        , pc_qty_act='{2}'
                        , update_date='{3}'
                        , update_time='{4}'
                        , update_by='{5}' 
                    WHERE item_id='{6}' AND customer_id='{7}' AND product_date='{8}' AND AND create_date='{9}' AND status='' AND sync=0 ";
                        List<string[]> rows_upd = (new lib.DbTable()).executeQuery(String.Format(sql
                            , "Confirm"
                            , ib.__COLUMNS["pkg_qty_act"]
                            , ib.__COLUMNS["pc_qty_act"]
                            , DateTime.Now.ToString("yyMMdd")
                            , DateTime.Now.ToString("HHmmss")
                            , Form_Login._Form_LoginInstance.userName
                            , ib.__COLUMNS["item_id"]
                            , ib.__COLUMNS["customer_id"]
                            , ib.__COLUMNS["product_date"]
                            , ib.__COLUMNS["create_date"]
                            ));

                        ib.__COLUMNS["status"] = "Confirm";
                        // update item back to buffer list
                        inboundItems[currentItem] = ib;
                        Form_InboundSimple.inboundItems = inboundItems;
                       
                        Form frm = new Form_Msg("Confirmed", Color.Black);
                        frm.ShowDialog();
                        this.Close();
                        return;

                        
                    }

                    if (rows.Count() > 1)
                    {
                        
                        Form frm = new Form_Msg("Error Inbound Confirm row item", Color.Red);
                        frm.ShowDialog();
                        this.Close();
                        return;
                    }
                    */

                    
                }catch (Exception ex)
                {
                    logger.Log(ex.Message);
                }


            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            this.Close();
            return;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            try
            {
                //lib.db.HT_IB ib = inboundItems.ElementAt(currentItem);
               // Dictionary<string, string> cols = new Dictionary<string, string>(ib.__COLUMNS);
               // checkInDB = new List<lib.db.HT_IB>();

                /*
                List<string[]> rows = (new lib.db.HT_IB()).get(
                    (new lib.db.HT_IB()).__COLUMNS
                    , String.Format("product_date='{0}' AND item_id='{1}' AND customer_id='{2}' AND status='{3}' AND sync='{4}' AND create_date='{5}'"
                        , ib.__COLUMNS["product_date"]
                        , ib.__COLUMNS["item_id"]
                        , ib.__COLUMNS["customer_id"]
                        , ""
                        , "0"
                        , ib.__COLUMNS["create_date"]
                        )
                    , null, null, null);

                if (rows.Count() >= 1)
                {
                    (new lib.db.HT_IB()).remove(String.Format("product_date='{0}' AND item_id='{1}' AND customer_id='{2}' AND status='{3}' AND sync='{4}' AND create_date='{5}'"
                        , ib.__COLUMNS["product_date"]
                        , ib.__COLUMNS["item_id"]
                        , ib.__COLUMNS["customer_id"]
                        , ""
                        , "0"
                        , ib.__COLUMNS["create_date"]
                        ));
                }
                */

                inboundItems.RemoveAt(currentItem);
                Form_InboundSimple.inboundItems = inboundItems;
                //Form frm = new Form_Msg("Deleted", Color.Blue);
                //frm.ShowDialog();
                this.Close();
                return;

            } catch (Exception ex)
            {
                logger.Log(ex.Message);
            }

        }

        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {
            label2.Text = "Box Qty";
            lbltype.Text = "Box";
            qty_inbound.Text = "";
        }

        private void radioButton2_CheckedChanged(object sender, EventArgs e)
        {
            label2.Text = "Pcs Qty";
            lbltype.Text = "Pcs";
            qty_inbound.Text = "";
        }

    }
}