var browserType;

if (document.layers) {
    browserType = "nn4"
}
if (document.all) {
    browserType = "ie"
}
if (window.navigator.userAgent.toLowerCase().match("gecko")) {
    browserType= "gecko"
}

if (!String.prototype.trim) {
    String.prototype.trim = function() {
        return this.replace(/^\s+|\s+$/g, '');
    };
}

if (!String.prototype.isEmpty) {
    String.prototype.isEmpty = function() {
        return this == '';
    };
}

if (!String.prototype.stripHtml) {
    String.prototype.stripHtml = function() {
        return this.replace(/(<([^>]+)>)/gi, '');
    };
}

if (!String.prototype.CSVtoArray)
    String.prototype.CSVtoArray = function() {

      var re_valid = /^\s*(?:'[^'\\]*(?:\\[\S\s][^'\\]*)*'|"[^"\\]*(?:\\[\S\s][^"\\]*)*"|[^,'"\s\\]*(?:\s+[^,'"\s\\]+)*)\s*(?:,\s*(?:'[^'\\]*(?:\\[\S\s][^'\\]*)*'|"[^"\\]*(?:\\[\S\s][^"\\]*)*"|[^,'"\s\\]*(?:\s+[^,'"\s\\]+)*)\s*)*$/;
      var re_value = /(?!\s*$)\s*(?:'([^'\\]*(?:\\[\S\s][^'\\]*)*)'|"([^"\\]*(?:\\[\S\s][^"\\]*)*)"|([^,'"\s\\]*(?:\s+[^,'"\s\\]+)*))\s*(?:,|$)/g;

      // Return NULL if input string is not well formed CSV string.
      if (!re_valid.test(this)) return null;

      var a = []; // Initialize array to receive values.
      this.replace(re_value, // "Walk" the string using replace with callback.
          function(m0, m1, m2, m3) {

              // Remove backslash from \' in single quoted values.
              if (m1 !== undefined) a.push(m1.replace(/\\'/g, "'"));

              // Remove backslash from \" in double quoted values.
              else if (m2 !== undefined) a.push(m2.replace(/\\"/g, '"'));
              else if (m3 !== undefined) a.push(m3);
              return ''; // Return empty string.
          });

      // Handle special case of empty last value.
      if (/,\s*$/.test(this)) a.push('');
      return a;
    };

if (!String.prototype.splitCsv) {
    String.prototype.splitCsv = function(d, encap) {
        var isEncapOpen = false;
        var isWordStarted = false;
        var list = new Array();
        var tmp = '';

        var type; // 0: normal, 1:eow, 2:soe
        var l = 0;

        for (var i = 0; i < this.length; i++) {
            var a = this.substring(i, i + 1);
            if (a === encap) {
                if (!isEncapOpen && !isWordStarted) {
                    type = 2; // start encap
                } else if (isEncapOpen) {
                    type = 1; // end of encapsulate
                } else {
                    type = 0;
                }
            } else if (a === d && !isEncapOpen) { // end of token
                type = 1;
            } else {
                type = 0;
            }

            switch (type) {
                case 0:
                    tmp += a;
                    isWordStarted = true;
                    break;
                case 1:
                    if (!tmp.trim().isEmpty())
                        list[l++] = tmp.trim().replace(/^"|"$/g, '');
                    tmp = '';
                    isWordStarted = false;
                    isEncapOpen = false;
                    break;
                case 2:
                    isEncapOpen = true;
                    break;
            }
        }

        if (!tmp.trim().isEmpty()) {
            list[l++] = tmp.trim().replace(/^"|"$/g, '');
        }


        return list;
    };
}

function removeUndefined(obj) {
  Object.keys(obj).forEach(function(key,index) {
    // key: the name of the object key
    // index: the ordinal position of the key within the object
    if (!obj[key]) obj[key]="";
  });
  return obj;
}

//// create Array.indexOf function supported for IE6
//if (!Array.prototype.indexOf)
//{
//  Array.prototype.indexOf = function(elt /*, from*/)
//  {
//    var len = this.length;
//
//    var from = Number(arguments[1]) || 0;
//    from = (from < 0)
//         ? Math.ceil(from)
//         : Math.floor(from);
//    if (from < 0)
//      from += len;
//
//    for (; from < len; from++)
//    {
//      if (from in this &&
//          this[from] === elt)
//        return from;
//    }
//    return -1;
//  };
//}
function findArrayIndex(array, obj){
    for(var i=0; i<array.length; i++){
        if(array[i]==obj){
            return i;
        }
    }
    return -1;
}

// Array prototype definition for indexOf
if (!Array.prototype.indexOf)
{
    Array.prototype.indexOf = function(elt /*, from*/)
    {
        var len = this.length;

        var from = Number(arguments[1]) || 0;
        from = (from < 0)
        ? Math.ceil(from)
        : Math.floor(from);
        if (from < 0)
            from += len;

        for (; from < len; from++)
        {
            if (from in this &&
                this[from] === elt)
                return from;
        }
        return -1;
    };
}

// Array prototype definition for lastIndexOf
if (!Array.prototype.lastIndexOf)
{
    Array.prototype.lastIndexOf = function(elt /*, from*/)
    {
        var len = this.length;

        var from = Number(arguments[1]);
        if (isNaN(from))
        {
            from = len - 1;
        }
        else
        {
            from = (from < 0)
            ? Math.ceil(from)
            : Math.floor(from);
            if (from < 0)
                from += len;
            else if (from >= len)
                from = len - 1;
        }

        for (; from > -1; from--)
        {
            if (from in this &&
                this[from] === elt)
                return from;
        }
        return -1;
    };
}

if (!Array.prototype.mergeWithPairedKey)
Array.prototype.mergeWithPairedKey = function(pairedKeyArray) {
  var result =  this.reduce(function(result, field, index) {
    result[pairedKeyArray[index]] = field;
    return result;
  }, {});

  return result;
}

/*
 * Call getQueryString()
 * Return: Object of query string of Location page
**/
function getQueryString() {
	var search = location.search.substring(1);
    if (search=="") return JSON.parse('{}');
	return JSON.parse('{"' + decodeURI(search).replace(/"/g, '\\"').replace(/&/g, '","').replace(/=/g,'":"') + '"}');
}

function queryString2Array(query) {
	var a = new Array();
    if (!query) return a;
    var parms = query.split('&');
    parms_len = parms.length;
    for (var i=0; i<parms_len; i++) {
		var pair = parms[i].split('=');
        a[decodeURIComponent(pair[0])] = decodeURIComponent(pair[1].replace(/\+/g, '%20') || '');
    }
    return a;
}

function array2QueryString(a) {
	var qstr = "";
    var i=0;
	for (var key in a)
		qstr += (i++==0?"":"&") + encodeURIComponent(key) + "=" + encodeURIComponent(a[key]);
	return qstr;
}

function json2QueryString(json) {
  return Object.keys(json).map(key => key + '=' + json[key]).join('&');
}

/* Support the Query String */
function qs() {
    var query = window.location.search.substring(1);
	return queryString2Array(query);
}

function urlfix(url){
    //		alert(url);
    var fixed = url.split("?");
    //		alert(fixed[0]);
    return fixed[0];
}

function hide(id) {
    if (browserType == "gecko" )
        document.poppedLayer =
        eval('document.getElementById(id)');
    else if (browserType == "ie")
        document.poppedLayer =
        eval('document.getElementById(id)');
    else
        document.poppedLayer =
        eval('document.layers[id]');
    if (!document.poppedLayer) {
        return;
    }
    document.poppedLayer.style.visibility = "hidden";
}

function show(id) {
    if (browserType == "gecko" )
        document.poppedLayer =
        eval('document.getElementById(id)');
    else if (browserType == "ie")
        document.poppedLayer =
        eval('document.getElementById(id)');
    else
        document.poppedLayer =
        eval('document.layers[id]');
    if (!document.poppedLayer) {
        return;
    }
    document.poppedLayer.style.visibility = "visible";
}

function hide2(id) {
    if (browserType == "gecko" ){
        document.poppedLayer =
        eval('document.getElementById(id)');
    }
    else if (browserType == "ie"){
        document.poppedLayer =
        eval('document.getElementById(id)');
    }
    else{
        document.poppedLayer =
        eval('document.layers[id]');
    }
    if (!document.poppedLayer) {
        return;
    }
    document.poppedLayer.style.display = 'none';
}
function show2(id) {
    if (browserType == "gecko" )
        document.poppedLayer =
        eval('document.getElementById(id)');
    else if (browserType == "ie")
        document.poppedLayer =
        eval('document.getElementById(id)');
    else
        document.poppedLayer =
        eval('document.layers[id]');
    if (!document.poppedLayer) {
        return;
    }
    document.poppedLayer.style.display = "inline";
}

function swap(id) {
    if (browserType == "gecko" )
        document.poppedLayer =
        eval('document.getElementById(id)');
    else if (browserType == "ie")
        document.poppedLayer =
        eval('document.getElementById(id)');
    else
        document.poppedLayer =
        eval('document.layers[id]');
    if (!document.poppedLayer) {
        return;
    }

    if (document.poppedLayer.style.display == "none") {
        document.poppedLayer.style.display = "inline";
    }
    else {
        document.poppedLayer.style.display = "none";
    }
}

function getElement(id) {
    if (browserType == "gecko" )
        obj = eval('document.getElementById(id)');
    else if (browserType == "ie")
        obj = eval('document.getElementById(id)');
    else
        obj = eval('document.layers[id]');
    return obj;
}

function getCookie(c_name)
{
    if (document.cookie.length>0)
    {
        c_start=document.cookie.indexOf(c_name + "=");
        if (c_start!=-1)
        {
            c_start=c_start + c_name.length+1;
            c_end=document.cookie.indexOf(";",c_start);
            if (c_end==-1) c_end=document.cookie.length;
            return unescape(document.cookie.substring(c_start,c_end));
        }
    }
    return "";
}

function setCookie(c_name,value,expiredays)
{
    var exdate=new Date();
    exdate.setDate(exdate.getDate()+expiredays);
    document.cookie=c_name+ "=" +escape(value)+
    ((expiredays==null) ? "" : ";expires="+exdate.toGMTString());
}

function chgColor(objid,col){
    var x=getElement(objid);
    if (x) {
        x.style.color=col;
    }
}

function chgImage(objid,src) {
    document[objid].src=src;
}


function createOptions(titles, values, name, disabled, selectedId)
{
    var tmp = "";
    tmp += "<select id='" + name + "' name='" + name + "'" + ((disabled)?" disabled":"") + ">";
    if (titles && values)
        for (var i=0;i<titles.length;i++) {
            tmp += "<option value=" + values[i] + ((selectedId==i)?" selected":"") + ">" + titles[i] + "</option>";
        }
    tmp += "</select>";

    return tmp;
}

function addOption(selectbox, value, text, selected )
{
    var optn = document.createElement("OPTION");
    optn.text = text;
    optn.value = value;
    selectbox.options.add(optn);
    if (selected)
        selectbox.options[selectbox.options.length-1].selected = selected;
}

/**
 * Add options with 2 dimensions array, [value][text]
 */
function addOption_list(selectbox, arry2d, defaultValue){
    for (i=0;i<arry2d.length;i++) {
        if (arry2d[i][0] && arry2d[i][1]) {
            addOption(selectbox, arry2d[i][0], arry2d[i][1], defaultValue == arry2d[i][0]);
        }
    }
}

function removeAllOptions(selectbox)
{
    var i;
    if (!selectbox)
        return;
    for(i=selectbox.options.length-1;i>=0;i--) {
        selectbox.remove(i);
    }
}

function removeSelectedOptions(selectbox)
{
    var i;
    for(i=selectbox.options.length-1;i>=0;i--) {
        if(selectbox.options[i].selected)
            selectbox.remove(i);
    }
}

/**
 * updateServiceOptions(raw, obj)
 * input parameters
 * raw - item string -> [v1]|[t1];[v2]|[t2];...
 */
function updateServiceOptions(raw, obj) {
    var optionsArry = new Array();
    var tmp = raw.split(';');
    // load services name
    for (i=0;i<tmp.length;i++) {
        optionsArry[i] = tmp[i].split('|');
    }

    removeAllOptions(obj);
    addOption_list(obj, optionsArry);
}

if (!String.prototype.stripHtml)
String.prototype.stripHtml = function() {
    return this.replace(/(<([^>]+)>)/gi, '');
}

if (!Number.prototype.pad)
Number.prototype.pad = function(size) {
    var s = String(this);
    while (s.length < (size || 2)) {s = "0" + s;}
    return s;
}

if (!Number.prototype.number_format)
Number.prototype.number_format = function(decimals=2,dec_point='.',thousands_sep=',') {
    var str = this.toFixed(decimals?decimals:0).toString().split('.');
    var parts = [];
    for ( var i=str[0].length; i>0; i-=3 ) {
        parts.unshift(str[0].substring(Math.max(0,i-3),i));
    }
    str[0] = parts.join(thousands_sep?thousands_sep:',');
    return str.join(dec_point?dec_point:'.');
}

function open_page(url, frame)
{
    window.scrollTo(0,0);
    top.frames[frame].location = url;
}

function wait_div_gen(id, msg)
{
    div_width = 400;
    div_height = 200;
    if (!msg) {
        msg = "\
			Please wait for a while...\
			 <hr style='height:0.5px;color:#999'>\
			"
    }
    document.write(" \
				   <div id=" + id + " style=\"\
				   z-index:1009;\
				   display:none;\
				   position:absolute;\
				   text-align:center;\
				   width:"+ div_width +";\
				   height:"+ div_height +"px;\
				   left:"+ (600 - div_width)/2 +"px;\
				   top:"+ (400 - div_height)/2 +"px;\
				   background-color:#444444;\
				   padding:10px;\
				   border-right:1px solid #000000;\
				   border-bottom:1px solid #000000;\
				   font-family:arial;\
				   font-size:24px;\
				   font-weight:normal;\
				   line-height:1.6em;\
				   color:#999999;\
				   filter:alpha(opacity=90);-moz-opacity:.90;opacity:.90;\"> \
						<div id=wait02 style=\"text-align:center;width:"+ (div_width-20) +"\"></div>"
        + msg + "</div>");

    def_width = 100;
    def_height = 100;
    zoom = 1;
    width = def_width*zoom;
    height = def_height*zoom;

    FlashReplace.replace("wait02", "/flash/wait02.swf", "wait02_obj", width, height,
        7,
        {
            wmode : "transparent",
            quality: "high",
            bgcolor: "#ffffff"
        }
        );
}

function hideAllSelect()
{
    svn=document.getElementsByTagName("SELECT");
    for (a=0;a<svn.length;a++){
        var vs = isIE();
        if (vs && vs<=6) {
            svn[a].style.visibility="hidden";
        }
    }
}

function hideAllSelect(div)
{
    svn=document.getElementsByTagName("SELECT");
    for (var a in svn){
        var vs = isIE();
        if (vs && vs<=6) {
            if (svn[a]) {
                //alert(svn[a].parentNode.id);
                //if (svn[a].parentNode.id == div)
                svn[a].style.visibility="hidden";
            }
        }
    }
}

function isIE()
{
    // Return Value: return IE version otherwise return 0
    if (/MSIE (\d+\.\d+);/.test(navigator.userAgent)) {
        return new Number(RegExp.$1);
    }
    return 0;
}

function isFirefox()
{
    // Return Value: return Firefox version otherwise return 0
    if (/Firefox[\/\s](\d+\.\d+)/.test(navigator.userAgent)) {
        return new Number(RegExp.$1);
    }
    return 0;
}

function isOpera()
{
    // Return Value: return Opera version otherwise return 0
    if (/Opera[\/\s](\d+\.\d+)/.test(navigator.userAgent)) {
        return new Number(RegExp.$1);
    }
    return 0;
}

function ascii_value (c)
{
    // restrict input to a single character
    c = c . charAt (0);

    // loop through all possible ASCII values
    var i;
    for (i = 0; i < 256; ++ i)
    {
        // convert i into a 2-digit hex string
        var h = i . toString (16);
        if (h . length == 1)
            h = "0" + h;

        // insert a % character into the string
        h = "%" + h;

        // determine the character represented by the escape code
        h = unescape (h);

        // if the characters match, we've found the ASCII value
        if (h == c)
            break;
    }
    return i;
}

function mFormatter(num) {
    return Math.abs(num) > 999999 ? Math.sign(num)*((Math.abs(num)/1000000).toFixed(1)) + 'm' : Math.sign(num)*Math.abs(num)
}

function kFormatter(num) {
    return Math.abs(num) > 999 ? Math.sign(num)*((Math.abs(num)/1000).toFixed(1)) + 'k' : Math.sign(num)*Math.abs(num)
}

function numberWithCommas(x) {
    var parts = x.toString().split(".");
    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    return parts.join(".");
}

function readableNumber(x)
{
    if (x>999999) x=mFormatter(x);
    else if (x>999) x=kFormatter(x);
	return x;
}

function parseURLstr(str)
{
    return unescape(str);
}

var imgs = new Array('./images/expand_white.gif', './images/collapse_white.gif');
var hints = new Array('expand', 'collapse');

function showBox(id)
{
    var ostate = (getCookie(id)=='')?1:parseInt(getCookie(id));
    var imgobj = getElement(id);

    imgobj.src = imgs[ostate];
    imgobj.alt = hints[ostate];
    if (hints[ostate] == 'expand') {
        hide2(id + 'Div');
    } else {
        show2(id + 'Div');
    }
}

function hideUnhideBox(id)
{
    var cstate = (getCookie(id)=='')?1:parseInt(getCookie(id));
    var imgobj = getElement(id);

    cstate = ((cstate+1)%2);
    imgobj.src = imgs[cstate];
    imgobj.alt = hints[cstate];
    if (hints[cstate] == 'expand') {
        hide2(id + 'Div');
    } else {
        show2(id + 'Div');
    }

    setCookie(id, cstate + '');
}

function collapseBox(id)
{
    var cstate = (getCookie(id)=='')?1:parseInt(getCookie(id));
    var imgobj = getElement(id);

    cstate = ((cstate+1)%2);
    imgobj.src = imgs[cstate];
    imgobj.alt = hints[cstate];
    if (hints[cstate] == 'expand') {
        hide2(id + 'Div');
    } else {
        show2(id + 'Div');
    }

    setCookie(id, cstate + '');
}

function ajaxPost(url, method, user, password) {
    var objHTTP;
    var async = false;
    var mt = 'GET';
    if (browserType == "gecko" ){
        mt = (method) ? method : mt;
        objHTTP = new XMLHttpRequest();
        if (user && password) {
            objHTTP.open(mt, url, async, user, password);
        } else {
            objHTTP.open(mt, url, async);
        }
    }else{
        mt = (method) ? method : 'POST';
        objHTTP = new ActiveXObject('Microsoft.XMLHTTP');
        if (user && password) {
            objHTTP.open(mt, url, async, user, password);
        } else {
            objHTTP.open(mt, url, async);
        }
        objHTTP.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    }

    objHTTP.send(null);
    return objHTTP.responseText;
}

var loadedobjects="";

function loadobjs(){
    if (!document.getElementById)
        return
    for (i=0; i<arguments.length; i++){
        var file=arguments[i]
        var fileref=""
        if (loadedobjects.indexOf(file)==-1){ //Check to see if this object has not already been added to page before proceeding
            if (file.indexOf(".js")!=-1){ //If object is a js file
                fileref=document.createElement('script')
                fileref.setAttribute("type","text/javascript");
                fileref.setAttribute("src", file);
            }
            else if (file.indexOf(".css")!=-1){ //If object is a css file
                fileref=document.createElement("link")
                fileref.setAttribute("rel", "stylesheet");
                fileref.setAttribute("type", "text/css");
                fileref.setAttribute("href", file);
            }
        }
        if (fileref!=""){
            document.getElementsByTagName("head").item(0).appendChild(fileref)
            loadedobjects+=file+" " //Remember this object as being already added to page
        }
    }
}

function findRadioValue(radioObj) {
    if(!radioObj)
        return "";
    var radioLength = radioObj.length;
    if(radioLength == undefined)
        if(radioObj.checked)
            return radioObj.value;
        else
            return "";
    for(var i = 0; i < radioLength; i++) {
        if(radioObj[i].checked) {
            return radioObj[i].value;
        }
    }
    return "";
}

function randomHex(len){
    var hex="";
    while (--len>=0) {
        hex+=Math.round(Math.random()*14).toString(16);
    }
    return hex;
}

String.prototype.copy2clipboard = function() {
	str = this;
	var d = document;
	const el = d.createElement('textarea');  // Create a <textarea> element
	el.value = str;                                 // Set its value to the string that you want copied
	el.setAttribute('readonly', '');                // Make it readonly to be tamper-proof
	el.style.position = 'absolute';
	el.style.left = '-9999px';                      // Move outside the screen to make it invisible
	d.body.appendChild(el);                  // Append the <textarea> element to the HTML document
	const selected =
		d.getSelection().rangeCount > 0        // Check if there is any content selected previously
		? d.getSelection().getRangeAt(0)     // Store selection if found
		: false;                                    // Mark as false to know no selection existed before
	el.select();                                    // Select the <textarea> content
	d.execCommand('copy');                   // Copy - only works as a result of a user action (e.g. click events)
	d.body.removeChild(el);                  // Remove the <textarea> element
	if (selected) {                                 // If a selection existed before copying
		d.getSelection().removeAllRanges();    // Unselect everything on the HTML document
		d.getSelection().addRange(selected);   // Restore the original selection
	}
};

if (!String.prototype.empty)
String.prototype.empty = function() {
	return (this.length === 0 || !this.trim());
};

if (!String.prototype.popup)
String.prototype.popup = function(sec, style={width:400, color:'#fff', backgroundColor:'#357eb7', fontWeight:'bold'}) {
	var w = window,
    d = document,
    e = d.documentElement,
    g = d.getElementsByTagName('body')[0],
    x = w.innerWidth || e.clientWidth || g.clientWidth,
    y = w.innerHeight|| e.clientHeight|| g.clientHeight;

	const el = d.createElement('div');
	el.innerHTML = this;


	el.style.position = 'fixed';
	el.style.top = '50%';
	el.style.left = '50%';
	el.style.width = style['width'] + 'px';
	el.style.paddingTop = '-50px';
	el.style.marginLeft = '-' + style['width']/2 + 'px';

	el.style.display = 'block';
	el.style.verticalAlign = 'middle';
	el.style.textAlign = 'center';
	el.style.zIndex = 1500;
	el.style.boxShadow = "5px 10px 5px #aaa";
	el.style.opacity = .95;
	el.style.transition = '.6s ease opacity,.6s ease transform';
	el.style.borderRadius = '15px';

	// Input style overriding
	for (var k in style) {
		eval('el.style.' + k + ' = "' + style[k] + '";');
	}

	d.body.appendChild(el);

	setTimeout(function(){ el.style.opacity=0;setTimeout(function(){el.style.display='none';d.body.removeChild(el);}, 700); }, sec*1000);
};

function center(el) {
    var w = window,
    d = document,
    e = d.documentElement,
    g = d.getElementsByTagName('body')[0],
    x = w.innerWidth || e.clientWidth || g.clientWidth,
    y = w.innerHeight|| e.clientHeight|| g.clientHeight;
    el.style.top = (y - el.offsetHeight) / 2;
    el.style.left = (x - el.offsetWidth) / 2;
}

function loadScript(url) {
	var script = document.createElement("SCRIPT");
	script.src = url;
	script.type = 'text/javascript';
	document.getElementsByTagName("head")[0].appendChild(script);
}


function setSelectWidth(selector) {
  var sel = $(selector);
  var tempSel = $("<select style='display:none'>")
      .append($("<option>").text(sel.find("option:selected").text()));
  tempSel.appendTo($("body"));
  sel.width(tempSel.width());
  tempSel.remove();
}

/*
  @input {
    type => 'value | text',
    attrs => {
              { '{option value1}' => { attr => '{attribute name1}', value => '{attribute value1}' } },
              { '{option value2}' => { attr => '{attribute name2}', value => '{attribute value2}' } },
              { '{option value3}' => { attr => '{attribute name3}', value => '{attribute value3}' } },
            }
*/
function setSelectAttr(selector, data) {
  for ( var key in data.attrs ) {
    $(selector).find('option').filter(function() {
      return data.type == 'value' ?
        $(this).val() == key
        : $(this).html() == key
    }).attr(data.attrs[key].attr, data.attrs[key].value);
  }
}


function runWithJQuery(jQueryCode){
    if(window.jQuery)  jQueryCode();
    else{
        var script = document.createElement('script');
        document.head.appendChild(script);
        script.type = 'text/javascript';
        script.src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js";
        script.onload = jQueryCode;
    }
}
runWithJQuery(function jQueryCode(){

/******** JQUERY Code here ********/


/* Trigger on.show and on.hide to element */
(function ($) {
	  $.each(['show', 'hide'], function (i, ev) {
	    var el = $.fn[ev];
	    $.fn[ev] = function () {
	      this.trigger(ev);
	      return el.apply(this, arguments);
	    };
	  });
	})(jQuery);


  $(document).ready(function() {

    $('input[type=text].callback').each(function() {
      var el = $('<span class="data-editor reset-sticky" for="' + $(this).attr('id') + '"></span>')
        .on('click', function() {
          $(this).parent().find('#' + $(this).attr('for')).val('');
        });
      el.insertAfter($(this));
    })
    
    $('input.uiicon').each(function() {
      $('<span class="ui-icon ' + $(this).attr('icon') + '" style="position: absolute;margin: 5px -25px;"></span>')
      .insertAfter($(this));
    });
    
    $('input[type=text].resetsticky').each(function() {
      var el = $('<span class="data-editor reset-sticky" for="' + $(this).attr('id') + '"></span>')
        .on('click', function() {
          $(this).parent().find('#' + $(this).attr('for')).val('');
        });
      el.insertAfter($(this));
    })
    
    $('input[type=text].show-placeholder').each(function() {
      var el = $('<span class="placeholder">' + $(this).attr('placeholder') + '</span>')
      el.insertBefore($(this));
      $(this).attr('placeholder', '')
    })
  });



});
