@extends("layout.menu")

@php 
 $strYear = date("d-m-y");

@endphp
<style>

html,body {
    text-align: center;
    background: #DCDCDC;
    color: #000;
    margin: 0;
    
  }
  table, td, th {
    border: solid 1px #ccc;
    border-collapse: collapse;
    border-spacing:0;
    color: #000;
    background: #DCDCDC;
    font-weight: bold;
    font-size:18px;
    padding:5px;
  }

.textAlignVer{
  display:block;
    filter: flipv fliph;
    position:relative;
    white-space:nowrap;
    font-size:12px;
    margin-top: 70px;

}
.textnumberright{
  style="text-align: right;"
}

@font-face {
  font-family: 'DIGITAL';
  src: url('https://cssdeck.com/uploads/resources/fonts/digii/DS-DIGII.TTF');
}



.digital-clock {
  margin: auto;
  top: 0;
  left: 0;
  bottom: 0;
  right: 0;
  color: #000;
  text-align: center;
  font: 50px/60px 'DIGITAL',;
}
.memumain{
  text-align: center;
  font-size:16px;
  padding-top:5px;

}
.digital-date {
  margin: auto;
  top: 0;
  left: 0;
  bottom: 0;
  right: 0;
  color: #000;
  text-align: center;
  font: 50px/60px 'DIGITAL',;
}
  </style>

@section("content")
<table class="table table-sm ">
  <tr>
    <th style="text-align: center; padding-top:30px;" rowspan="3" colspan="2"><p style="font-size:50px;">5W<p></th>
    <th colspan="9" style="text-align: center;"><h3>Production Control Board</h3></th>
  </tr>

  <tr>
    <td colspan="6" style="text-align: center;"><h4>Date : <span class="digital-date"> </span></h4></td>

    <td colspan="5" style="text-align: center;"><h4>Update Time : <span class="digital-time"> </span> </span></h4></td>

  </tr>
  <tr>
   
    <td style="text-align: center;"> DIE BOND</td>
    <td style="text-align: center;">OVEN DIEBON</td>
    <td style="text-align: center;">WIRE BOND</td>
    <td style="text-align: center;">BONDING INS</td>
    <td style="text-align: center;">MOLD</td>
    <td style="text-align: center;">OVEN MOLD</td>
    <td style="text-align: center;">DICER</td>
    <td style="text-align: center;">APPEARANCE</td>
    <td style="text-align: center;">CLASSIFY</td>
   
  </tr>
  <tr>
    <td colspan="2">Plan</td>
    <td style="text-align: right;"><span id="pdieNow"></span> / <span id="pdieFull"></span></td>
    <td style="text-align: right;"><span id="povenNow"></span> / <span id="povenFull"></span></td>
    <td style="text-align: right;"><span id="pwireNow"></span> / <span id="pwireFull"></span></td>
    <td style="text-align: right;"><span id="pbondinNow"></span> / <span id="pbondinFull"></span></td>
    <td style="text-align: right;"><span id="pmoldNow"></span> / <span id="pmoldFull"></span></td>
    <td style="text-align: right;"><span id="povenmoldNow"></span> / <span id="povenmoldFull"></span></td>
    <td style="text-align: right;"><span id="pdicerNow"></span> / <span id="pdicerFull"></span></td>
    <td style="text-align: right;"><span id="pappeaNow"></span> / <span id="pappeaFull"></span></td>
    <td style="text-align: right;"><span id="pcalssNow"></span> / <span id="pcalssFull"></span></td>
    
  </tr>
  <tr>
    <td  colspan="2">Input</td>
    <td style="text-align: right;"><span id="indieNow"></span></td>
    <td style="text-align: right;"><span id="inovenNow"></span></td>
    <td style="text-align: right;"><span id="inwirebondNow"></span></td>
    <td style="text-align: right;"><span id="inbondingNow"></span></td>
    <td style="text-align: right;"><span id="inmoldNow"></span></td>
    <td style="text-align: right;"><span id="inovenmoldNow"></span></td>
    <td style="text-align: right;"><span id="indicerNow"></span></td>
    <td style="text-align: right;"><span id="inappearaNow"></span></td>
    <td style="text-align: right;"><span id="incalssNow"></span></td>
  
   
  </tr>
  <tr id="Output">
    
  </tr>
  <tr id="Result">
    
  </tr>
  <tr>
    <td  colspan="2">NG</td>
    <td style="text-align: right;"><span >0</span></td>
    <td style="text-align: right;"><span >0</span></td>
    <td style="text-align: right;"><span >0</span></td>
    <td style="text-align: right;"><span id="ngbonding"></span></td>
    <td style="text-align: right;"><span id="ngmold"></span></td>
    <td style="text-align: right;"><span>0</span></td>
    <td style="text-align: right;"><span id="ngdicer"></span></td>
    <td style="text-align: right;"><span id="ngappear"></span></td>
    <td style="text-align: right;"><span id="ngclassify"></span></td>
  </tr>
  <tr id="Png">
    
  </tr>
  <tr>
    <td colspan="2" style="text-align: center;">TOP 3 NG</td>
    <td colspan="12" style="text-align: center;"></td>


  </tr>
  <tr>
    <td rowspan="3" style="text-align: center;">BONDING INS</td>
    <td style="width: 160;"><span id="ant3bonding1"></span></td>
    <td></td>
    <td></td>
    <td></td>
    <td style="text-align: right;"> <span id="sumant3bonding1"></span>%</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td><span id="ant3bonding2"></span></td>
    <td></td>
    <td></td>
    <td></td>
    <td style="text-align: right;"><span id="sumast3bonding2"></span>%</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td><span id="ant3bonding3"></span></td>
    <td></td>
    <td></td>
    <td></td>
    <td style="text-align: right;"> <span id="sumast3bonding3"></span>%</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    
  </tr>
  <tr>

  <td rowspan="3" style="text-align: center;">MOLD</td>
    <td><span id="ant3mold1"></span></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td style="text-align: right;"><span id="sumant3mold1"></span>%</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td><span id="ant3mold2"></span></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td style="text-align: right;"><span id="sumant3mold2"></span>%</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td><span id="ant3mold3"></span></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td style="text-align: right;"><span id="sumant3mold3"></span>%</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
   
  </tr>
  <tr>

    <td rowspan="3" style="text-align: center;">DICER</td>
    <td><span id="ant3dicer1"></span></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td style="text-align: right;"><span id="sumant3dicer1"></span>%</td>
    <td></td>
    <td></td>
  </tr>
  <tr>
    <td><span id="ant3dicer2"></span></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td style="text-align: right;"><span id="sumant3dicer2"></span>%</td>
    <td></td>
    <td></td>
   
  </tr>
  <tr>
    <td><span id="ant3dicer3"></span></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td style="text-align: right;"><span id="sumant3dicer3"></span>%</td>
    <td></td>
    <td></td>

  </tr>
  <tr>

    <td rowspan="3" style="text-align: center;">APPEARANCE</td>
    <td><span id="ant3appea1"></span></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td style="text-align: right;"><span id="sumant3appea1"></span>%</td>
    <td></td>
  </tr>
  <tr>
    <td><span id="ant3appea2"></span></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td style="text-align: right;"><span id="sumant3appea2"></span>%</td>
    <td></td>
    
  </tr>
  <tr>
    <td><span id="ant3appea3"></span></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td style="text-align: right;"><span id="sumant3appea3"></span>%</td>
    <td></td>

  </tr>
  <tr>
    <td rowspan="3" style="text-align: center;">CLASSIFYING</td>
    <td><span id="ant3classi1"></span></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td style="text-align: right;"> <span id="sumant3classi1"></span>%</td>
  </tr>
  <tr>
    <td><span id="ant3classi2"></span></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td style="text-align: right;"> <span id="sumant3classi2"></span>%</td>
    
  </tr>
  <tr>
    <td><span id="ant3classi3"></span></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td style="text-align: right;"> <span id="sumant3classi3"></span>%</td>

  </tr>
  <tr>
    <td colspan="2">LOT OUT</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
   
  </tr>
  <tr>
    <td colspan="2">% LOT OUT</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
   
  </tr>
  <tr style="height: 30;">
    <td colspan="2" rowspan="5">Remark</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr style="height: 30;">
     <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr style="height: 30;">
  <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr style="height: 30;">
  <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
  <tr style="height: 30;">
  <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
  </tr>
 

  
</table>


@endsection
@section("script")
<script type="text/javascript">
$(document).ready(function () {

  loadData();
  clockUpdate();
  setInterval(clockUpdate, 1000);

  setTimeout(
  function() 
  {
    loadData();
  }, 30000);
});

function timerefresh(t)
{
if(t==0){
  loadData();
    }
else{
    t--;
  }
window.setTimeout("timerefresh('"+t+"')",1000)
}

timerefresh(5);

function clockUpdate() {
  var date = new Date();
  $('.digital-clock').css({'color': '#FFFF'});
  function addZero(x) {
    if (x < 10) {
      return x = '0' + x;
    } else {
      return x;
    }
  }

  function twelveHour(x) {
    if (x > 24) {
      return x = x - 24;
    } else if (x == 0) {
      return x = 24;
    } else {
      return x;
    }
  }

  var h = addZero(twelveHour(date.getHours()));
  var m = addZero(date.getMinutes());
  var s = addZero(date.getSeconds());

  $('.digital-clock').text(h + ':' + m + ':' + s)
}



function loadData() {
    $.ajax({
 
        url:'{{url("loaddata")}}',
        type:'get',
        data:'',
        dataType:'json',
        success:function(ret){

        $("#Output").empty();
        $("#Result").empty();
        $("#Png").empty();
        
  
        pdieFull = ret['pdieFull'];
        pdieNow = ret['pdieNow'];
        povenFull = ret['povenFull'];
        povenNow = ret['povenNow'];
        pwireFull = ret['pwireFull'];
        pwireNow = ret['pwireNow'];
        pbondinFull = ret['pbondinFull'];
        pbondinNow = ret['pbondinNow'];
        pmoldFull = ret['pmoldFull'];
        pmoldNow = ret['pmoldNow'];
        povenmoldFull = ret['povenmoldFull'];
        povenmoldNow = ret['povenmoldNow'];
        pdicerFull = ret['pdicerFull'];
        pdicerNow = ret['pdicerNow'];
        pappeaFull = ret['pappeaFull'];
        pappeaNow = ret['pappeaNow'];
        pcalssFull = ret['pcalssFull'];
        pcalssNow = ret['pcalssNow'];
        indieNow = ret['indieNow'];
        inovenNow = ret['inovenNow'];
        inwirebondNow = ret['inwirebondNow'];
        inbondingNow = ret['inbondingNow'];
        inmoldNow = ret['inmoldNow'];
        inovenmoldNow = ret['inovenmoldNow'];
        indicerNow = ret['indicerNow'];
        inappearaNow = ret['inappearaNow'];
        incalssNow = ret['incalssNow'];
        outdieend = ret['outdieend'];
        outovenend = ret['outovenend'];
        outwirebondend = ret['outwirebondend'];
        outbondingend = ret['outbondingend'];
        outmoldend = ret['outmoldend'];
        outoven_moldend = ret['outoven_moldend'];
        outdicer_actend = ret['outdicer_actend'];
        outappearanceend = ret['outappearanceend'];
        outclassifyend = ret['outclassifyend'];
        ngbonding = ret['ngbonding'];
        ngmold = ret['ngmold'];
        ngdicer = ret['ngdicer'];
        ngappear = ret['ngappear'];
        ngclassify = ret['ngclassify'];
        t3bonding = ret['t3bonding'];
        t3mold = ret['t3mold'];
        t3dicer = ret['t3dicer'];
        t3appea = ret['t3appea'];
        t3classi = ret['t3classi'];
        dateshow = ret['dateshow'];
        timeshow = ret['timeshow'];

        $('.digital-date').text(dateshow);
        $('.digital-time').text(timeshow);

        var indieNow1 = 0;
        var inovenNow1 = 0;
        var inwirebondNow1 = 0;
        var inbondingNow1 = 0;
        var inmoldNow1 = 0;
        var inovenmoldNow1 = 0;
        var indicerNow1 = 0;
        var inappearaNow1 = 0;
        var incalssNow1 = 0;

        var outbondingend2 = 0;
        var outmoldend2 = 0;
        var outdicer_actend2 = 0;
        var outappearanceend2 = 0;
        var outclassifyend2 = 0;


        var DiSumResult = 0;
        var OdiSumResult = 0;
        var WieSumResult = 0;
        var BondSumResult = 0;
        var MoldSumResult = 0;
        var OvenmoSumResult = 0;
        var DicerSumResult = 0;
        var MoldSumResult = 0;
        var AppeaSumResult = 0;
        var ClassSumResult = 0;

        var NgSumbonding = 0;
        var NgSumngmold = 0;
        var NgSumngdicer = 0;
        var NgSumngappear = 0;
        var NgSumngclassify = 0;

   
        

        if(indieNow[0].indieNow !== 0){ indieNow1 = numeral(indieNow[0].indieNow).format('0,0')}else{ indieNow1 = 0.001};
        if(inovenNow[0].inovenNow !== 0){ inovenNow1 = numeral(inovenNow[0].inovenNow).format('0,0')}else{ inovenNow1 = 0.001};
        if(inwirebondNow[0].inwirebondNow !== 0){ inwirebondNow1 = numeral(inwirebondNow[0].inwirebondNow).format('0,0')}else{ inwirebondNow1 = 0.001};
        if(inbondingNow[0].inbondingNow !== 0){ inbondingNow1 = numeral(inbondingNow[0].inbondingNow).format('0,0')}else{ inbondingNow1 = 0.001};
        if(inmoldNow[0].inmoldNow !== 0){ inmoldNow1 = numeral(inmoldNow[0].inmoldNow).format('0,0')}else{ inmoldNow1 = 0.001};
        if(inovenmoldNow[0].inovenmoldNow !== 0){ inovenmoldNow1 = numeral(inovenmoldNow[0].inovenmoldNow).format('0,0')}else{ inovenmoldNow1 = 0.001};
        if(indicerNow[0].indicerNow !== 0){ indicerNow1 = numeral(indicerNow[0].indicerNow).format('0,0')}else{ indicerNow1 = 0.001};
        if(inappearaNow[0].inappearaNow !== 0){ inappearaNow1 = numeral(inappearaNow[0].inappearaNow).format('0,0')}else{ inappearaNow1 = 0.001};
        if(incalssNow[0].incalssNow !== 0){ incalssNow1 = numeral(incalssNow[0].incalssNow).format('0,0')}else{ incalssNow1 = 0.001};

        if(outbondingend[0].outbondingend !== 0){ outbondingend2 = numeral(outbondingend[0].outbondingend).format('0,0')}else{ outbondingend2 = 0.001};
        if(outmoldend[0].outmoldend !== 0){ outmoldend2 = numeral(outmoldend[0].outmoldend).format('0,0')}else{ outmoldend2 = 0.001};
        if(outdicer_actend[0].outdicer_actend !== 0){ outdicer_actend2 = numeral(outdicer_actend[0].outdicer_actend).format('0,0')}else{ outdicer_actend2 = 0.001};
        if(outappearanceend[0].outappearanceend !== 0){ outappearanceend2 = numeral(outappearanceend[0].outappearanceend).format('0,0')}else{ outappearanceend2 = 0.001};
        if(outclassifyend[0].outclassifyend !== 0){ outclassifyend2 = numeral(outclassifyend[0].outclassifyend).format('0,0')}else{ outclassifyend2 = 0.001};



        $("#pdieFull").text(numeral(pdieFull[0].pdieFull).format('0,0'));
        $("#pdieNow").text(numeral(pdieNow[0].pdieNow).format('0,0'));
        $("#povenNow").text(numeral(povenNow[0].povenNow).format('0,0'));
        $("#povenFull").text(numeral(povenFull[0].povenFull).format('0,0'));
        $("#pwireFull").text(numeral(pwireFull[0].pwireFull).format('0,0'));
        $("#pwireNow").text(numeral(pwireNow[0].pwireNow).format('0,0'));
        $("#pbondinFull").text(numeral(pbondinFull[0].pbondinFull).format('0,0'));
        $("#pbondinNow").text(numeral(pbondinNow[0].pbondinNow).format('0,0'));
        $("#pmoldFull").text(numeral(pmoldFull[0].pmoldFull).format('0,0'));
        $("#pmoldNow").text(numeral(pmoldNow[0].pmoldNow).format('0,0'));
        $("#povenmoldFull").text(numeral(povenmoldFull[0].povenmoldFull).format('0,0'));
        $("#povenmoldNow").text(numeral(povenmoldNow[0].povenmoldNow).format('0,0'));
        $("#pdicerNow").text(numeral(pdicerNow[0].pdicerNow).format('0,0'));
        $("#pdicerFull").text(numeral(pdicerFull[0].pdicerFull).format('0,0'));
        $("#pappeaFull").text(numeral(pappeaFull[0].pappeaFull).format('0,0'));
        $("#pappeaNow").text(numeral(pappeaNow[0].pappeaNow).format('0,0'));
        $("#pcalssFull").text(numeral(pcalssFull[0].pcalssFull).format('0,0'));
        $("#pcalssNow").text(numeral(pcalssNow[0].pcalssNow).format('0,0'));

        $("#indieNow").text(numeral(indieNow[0].indieNow).format('0,0'));
        $("#inovenNow").text(numeral(inovenNow[0].inovenNow).format('0,0'));
        $("#inwirebondNow").text(numeral(inwirebondNow[0].inwirebondNow).format('0,0'));
        $("#inbondingNow").text(numeral(inbondingNow[0].inbondingNow).format('0,0'));
        $("#inmoldNow").text(numeral(inmoldNow[0].inmoldNow).format('0,0'));
        $("#inovenmoldNow").text(numeral(inovenmoldNow[0].inovenmoldNow).format('0,0'));
        $("#indicerNow").text(numeral(indicerNow[0].indicerNow).format('0,0'));
        $("#inappearaNow").text(numeral(inappearaNow[0].inappearaNow).format('0,0'));
        $("#incalssNow").text(numeral(incalssNow[0].incalssNow).format('0,0'));


        $("#ngbonding").text(numeral(ngbonding[0].ngbonding).format('0,0'));
        $("#ngmold").text(numeral(ngmold[0].ngmold).format('0,0'));
        $("#ngdicer").text(numeral(ngdicer[0].ngdicer).format('0,0'));
        $("#ngappear").text(numeral(ngappear[0].ngappear).format('0,0'));
        $("#ngclassify").text(numeral(ngclassify[0].ngclassify).format('0,0'));


        DiSumResult = (numeral(outdieend[0].outdieend).value() / numeral(indieNow1).value()) * 100 ;
        OieSumResult = (numeral(outovenend[0].outovenend).value() / numeral(inovenNow1).value()) * 100 ;
        WieSumResult = (numeral(outwirebondend[0].outwirebondend).value() / numeral(inwirebondNow1).value()) * 100 ;
        BondSumResult = (numeral(outbondingend[0].outbondingend).value() / numeral(inbondingNow1).value()) * 100 ;
        MoldSumResult = (numeral(outmoldend[0].outmoldend).value() / numeral(inmoldNow1).value()) * 100 ;
        OvenmoSumResult = (numeral(outoven_moldend[0].outoven_moldend).value() / numeral(inovenmoldNow1).value()) * 100 ;
        DicerSumResult = (numeral(outdicer_actend[0].outdicer_actend).value() / numeral(indicerNow1).value()) * 100 ;
        AppeaSumResult = (numeral(outappearanceend[0].outappearanceend).value() / numeral(inappearaNow1).value()) * 100 ;
        ClassSumResult = (numeral(outclassifyend[0].outclassifyend).value() / numeral(incalssNow1).value()) * 100 ;
 

        if(DiSumResult >= 100 && DiSumResult != 0){var a ='background-color: green;color: #000;'}else if( DiSumResult <100 && DiSumResult> 0 ){ var a ='background-color: #ffc107 ;color: #000;' }else {var a = "" };
        if(OieSumResult >= 100 && OieSumResult != 0){var b ='background-color: green;color: #000;'}else if( OieSumResult <100 && OieSumResult> 0){var b ='background-color: #ffc107 ;color: #000;' }else {var b = ""};
        if(WieSumResult >= 100 && WieSumResult != 0){var c ='background-color: green;color: #000;'}else if( WieSumResult <100 && WieSumResult> 0 ){ var c ='background-color: #ffc107 ;color: #000;' }else {var c = "" };
        if(BondSumResult >= 100 && BondSumResult != 0){var d ='background-color: green;color: #000;'}else if( BondSumResult <100 && BondSumResult> 0 ){ var d ='background-color: #ffc107 ;color: #000;' }else {var d = "" };
        if(MoldSumResult >= 100 && MoldSumResult != 0){var e ='background-color: green;color: #000;'}else if( MoldSumResult <100 && MoldSumResult> 0){var e ='background-color: #ffc107 ;color: #000;' }else {var e = ""};
        if(DicerSumResult >= 100 && DicerSumResult != 0){var f ='background-color: green;color: #000;'}else if( DicerSumResult <100 && DicerSumResult> 0 ){ var f  ='background-color: #ffc107 ;color: #000;' }else {var f = "" };
        if(OvenmoSumResult >= 100 && OvenmoSumResult != 0){var g ='background-color: green;color: #000;'}else if( OvenmoSumResult <100 && OvenmoSumResult> 0){var g ='background-color: #ffc107 ;color: #000;' }else {var g = ""};
        if(AppeaSumResult >= 100 && AppeaSumResult != 0){var p ='background-color: green;color: #000;'}else if( AppeaSumResult <100 && AppeaSumResult> 0 ){ var p ='background-color: #ffc107 ;color: #000;' }else {var p = "" };
        if(ClassSumResult >= 100 && ClassSumResult != 0){var q ='background-color: green;color: #000;'}else if( ClassSumResult <100 && ClassSumResult> 0){var q ='background-color: #ffc107 ;color: #000;' }else {var q = ""};
    
        strOutput = '<td  colspan="2">Output</td>'
                +'<td style="text-align: right;'+ a +'" ><span >'+ numeral(outdieend[0].outdieend).format('0,0') +'</span></td>'
                +'<td style="text-align: right;'+ b +'"><span >'+ numeral(outovenend[0].outovenend).format('0,0') +'</span></td>'
                +'<td style="text-align: right;'+ c +'"><span >'+ numeral(outwirebondend[0].outwirebondend).format('0,0') +'</span></td>'
                +'<td style="text-align: right;'+ d +'"><span >'+ numeral(outbondingend[0].outbondingend).format('0,0') +'</span></td>'
                +'<td style="text-align: right;'+ e +'"><span >'+ numeral(outmoldend[0].outmoldend).format('0,0') +'</span></td>'
                +'<td style="text-align: right;'+ g +'"><span >'+ numeral(outoven_moldend[0].outoven_moldend).format('0,0') +'</span></td>'
                +'<td style="text-align: right;'+ f +'"><span >'+ numeral(outdicer_actend[0].outdicer_actend).format('0,0') +'</span></td>'
                +'<td style="text-align: right;'+ p +'"><span ">'+ numeral(outappearanceend[0].outappearanceend).format('0,0') +'</span></td>'
                +'<td style="text-align: right;'+ q +'"><span>'+ numeral(outclassifyend[0].outclassifyend).format('0,0') +'</span></td>';
        $("#Output").append(strOutput);

        strResult = '<td  colspan="2">%Ok</td>'
                +'<td style="text-align: right;'+ a +'" ><span >'+ numeral(DiSumResult).format('0,0.00') +'%</span></td>'
                +'<td style="text-align: right;'+ b +'"><span >'+ numeral(OieSumResult).format('0,0.00') +'%</span></td>'
                +'<td style="text-align: right;'+ c +'"><span >'+ numeral(WieSumResult).format('0,0.00') +'%</span></td>'
                +'<td style="text-align: right;'+ d +'"><span >'+ numeral(BondSumResult).format('0,0.00') +'%</span></td>'
                +'<td style="text-align: right;'+ e +'"><span >'+ numeral(MoldSumResult).format('0,0.00') +'%</span></td>'
                +'<td style="text-align: right;'+ g +'"><span >'+ numeral(OvenmoSumResult).format('0,0.00') +'%</span></td>'
                +'<td style="text-align: right;'+ f +'"><span >'+ numeral(DicerSumResult).format('0,0.00') +'%</span></td>'
                +'<td style="text-align: right;'+ p +'"><span ">'+ numeral(AppeaSumResult).format('0,0.00') +'%</span></td>'
                +'<td style="text-align: right;'+ q +'"><span>'+ numeral(ClassSumResult).format('0,0.00') +'%</span></td>';
        $("#Result").append(strResult);

         NgSumbonding = (numeral(ngbonding[0].ngbonding).value() / numeral(outbondingend2).value()) * 100 ;
         NgSumngmold = (numeral(ngmold[0].ngmold).value() / numeral(outmoldend2).value()) * 100 ;
         NgSumngdicer = (numeral(ngdicer[0].ngdicer).value() / numeral(outdicer_actend2).value()) * 100 ;
         NgSumngappear = (numeral(ngappear[0].ngappear).value() / numeral(outappearanceend2).value()) * 100 ;
         NgSumngclassify = (numeral(ngclassify[0].ngclassify).value() / numeral(outclassifyend2).value()) * 100 ;

        
      
        if(NgSumbonding >= 0.5){var a1 ='background-color: red ;color: #FFFF;'}else if( ClassSumResult <100 && ClassSumResult > 0){var a1 ='background-color: red ;color: #FFFF;' }else {var a1 = ""};
        if(NgSumngmold >= 0.5){var b1 ='background-color: red ;color: #FFFF;'}else if( NgSumngmold <100 && NgSumngmold > 0){var b1 ='background-color: red ;color: #FFFF;' }else {var b1 = ""};
        if(NgSumngdicer >= 0.5){var c1 ='background-color: red ;color: #FFFF;'}else if( NgSumngdicer <100 && NgSumngdicer > 0){var c1 ='background-color: red ;color: #FFFF;' }else {var c1 = ""};
        if(NgSumngappear >= 0.5){var d1 ='background-color: red ;color: #FFFF;'}else if( NgSumngappear <100 && NgSumngappear > 0){var d1 ='background-color: red ;color: #FFFF;' }else {var d1 = ""};
        if(NgSumngclassify >= 0.5){var e1 ='background-color: red ;color: #FFFF;'}else if( NgSumngclassify <100 && NgSumngclassify > 0){var e1 ='background-color: red ;color: #FFFF;' }else {var e1 = ""};
        // if(NgSumbonding <= 0.5){ var a1 ='background-color: green;color: #ffff;'}else{ var a1 ='background-color: red;color: #FFFF;'};



        strPng = '<td  colspan="2">%NG</td>'
                +'<td style="text-align: right;" ><span ></span></td>'
                +'<td style="text-align: right;"><span ></span></td>'
                +'<td style="text-align: right;"><span ></span></td>'
                +'<td style="text-align: right;'+ a1 +'"><span >'+ numeral(NgSumbonding).format('0,0.00') +'%</span></td>'
                +'<td style="text-align: right;'+ b1 +'"><span >'+ numeral(NgSumngmold).format('0,0.00') +'%</span></td>'
                +'<td style="text-align: right;"><span ></span></td>'
                +'<td style="text-align: right;'+ c1 +'"><span >'+ numeral(NgSumngdicer).format('0,0.00') +'%</span></td>'
                +'<td style="text-align: right;'+ d1 +'"><span ">'+ numeral(NgSumngappear).format('0,0.00') +'%</span></td>'
                +'<td style="text-align: right;'+ e1 +'"><span>'+ numeral(NgSumngclassify).format('0,0.00') +'%</span></td>';
        $("#Png").append(strPng);
       
        
        $("#DiSumResult").text(DiSumResult);
        if(!Array.isArray(t3bonding) || !t3bonding.length)
         {
          $("#ant3bonding1").text("");
            $("#sumant3bonding1").text("0");
            $("#ant3bonding2").text("");
            $("#sumast3bonding2").text("0");
            $("#ant3bonding3").text("");
            $("#sumast3bonding3").text("0");
          } else{
            $("#ant3bonding1").text(t3bonding[0].ng_name.substr(0,15));
            $("#sumant3bonding1").text(numeral((numeral(t3bonding[0].sumqty).value() / numeral(outbondingend2).value()) * 100).format('0,0.00'));
            $("#ant3bonding2").text(t3bonding[1].ng_name.substr(0,15));
            $("#sumast3bonding2").text(numeral((numeral(t3bonding[1].sumqty).value() / numeral(outbondingend2).value()) * 100).format('0,0.00'));
            $("#ant3bonding3").text(t3bonding[2].ng_name.substr(0,15));
            $("#sumast3bonding3").text(numeral((numeral(t3bonding[2].sumqty).value() / numeral(outbondingend2).value()) * 100).format('0,0.00'));
           
          }
      
        if(!Array.isArray(t3mold) || !t3mold.length){
          $("#ant3mold1").text("");
          $("#sumant3mold1").text("0");
          $("#ant3mold2").text("");
          $("#sumant3mold2").text("0");
          $("#ant3mold3").text("");
          $("#sumant3mold3").text("0");
          
        }else{
          $("#ant3mold1").text(t3mold[0].ng_name.substr(0,15));
          $("#sumant3mold1").text(numeral((numeral(t3mold[0].sumqty).value() / numeral(outmoldend2).value()) * 100).format('0,0.00'));
          $("#ant3mold2").text(t3mold[1].ng_name.substr(0,15));
          $("#sumant3mold2").text(numeral((numeral(t3mold[1].sumqty).value() / numeral(outmoldend2).value()) * 100).format('0,0.00'));
          $("#ant3mold3").text(t3mold[2].ng_name.substr(0,15));
          $("#sumant3mold3").text(numeral((numeral(t3mold[2].sumqty).value() / numeral(outmoldend2).value()) * 100).format('0,0.00'));
        }

        if(!Array.isArray(t3dicer) || !t3dicer.length){
          $("#ant3dicer1").text("");
          $("#sumant3dicer1").text("0");
          $("#ant3dicer2").text("");
          $("#sumant3dicer2").text("0");
          $("#ant3dicer3").text("");
          $("#sumant3dicer3").text("0");
        }else{
      
          $("#ant3dicer1").text(t3dicer[0].ng_name.substr(0,15));
          $("#sumant3dicer1").text(numeral((numeral(t3dicer[0].sumqty).value() / numeral(outdicer_actend2).value()) * 100).format('0,0.00'));
          $("#ant3dicer2").text(t3dicer[1].ng_name.substr(0,15));
          $("#sumant3dicer2").text(numeral((numeral(t3dicer[1].sumqty).value() / numeral(outdicer_actend2).value()) * 100).format('0,0.00'));
          $("#ant3dicer3").text(t3dicer[2].ng_name.substr(0,15));
          $("#sumant3dicer3").text(numeral((numeral(t3dicer[2].sumqty).value() / numeral(outdicer_actend2).value()) * 100).format('0,0.00'));
        }

        if(!Array.isArray(t3appea) || !t3appea.length){
          $("#ant3appea1").text("");
          $("#sumant3appea1").text("0");
          $("#ant3appea2").text("");
          $("#sumant3appea2").text("0");
          $("#ant3appea3").text("");
          $("#sumant3appea3").text("0");

        }else{
     
          $("#ant3appea1").text(t3appea[0].ng_name.substr(0,15));
          $("#sumant3appea1").text(numeral((numeral(t3appea[0].sumqty).value() / numeral(outappearanceend2).value()) * 100).format('0,0.00'));
          $("#ant3appea2").text(t3appea[1].ng_name.substr(0,15));
          $("#sumant3appea2").text(numeral((numeral(t3appea[1].sumqty).value() / numeral(outappearanceend2).value()) * 100).format('0,0.00'));
          $("#ant3appea3").text(t3appea[2].ng_name.substr(0,15));
          $("#sumant3appea3").text(numeral((numeral(t3appea[2].sumqty).value() / numeral(outappearanceend2).value()) * 100).format('0,0.00'));
        }
        
        if(!Array.isArray(t3classi) || !t3classi.length){
          $("#ant3classi1").text("");
          $("#sumant3classi1").text("0");
          $("#ant3classi2").text("");
          $("#sumant3classi2").text("0");
          $("#ant3classi3").text("");
          $("#sumant3classi3").text("0");
          
        }else{
          $("#ant3classi1").text(t3classi[0].output_name.substr(0,15));
          $("#sumant3classi1").text(numeral((numeral(t3classi[0].sumng).value() / numeral(outclassifyend2).value()) * 100).format('0,0.00'));
          $("#ant3classi2").text(t3classi[1].output_name.substr(0,15));
          $("#sumant3classi2").text(numeral((numeral(t3classi[1].sumng).value() / numeral(outclassifyend2).value()) * 100).format('0,0.00'));
          $("#ant3classi3").text(t3classi[2].output_name.substr(0,15));
          $("#sumant3classi3").text(numeral((numeral(t3classi[2].sumng).value() / numeral(outclassifyend2).value()) * 100).format('0,0.00'));
        }
    
        },
        error:function(err){

        // alert('Error : '+err.responseText);
        }
        });

    }
</script>
@endsection
