@extends("layout.menu")

@php 
 $strYear = date("d-m-y");
@endphp

<?php
  $next_page = $_SERVER['SERVER_NAME'].'/asi/display/screen3';
?>
<style>

html,body {
    text-align: center;
    /* background: #DCDCDC; */
    background: #FFF;
    color: #000;
    margin: 0;
    
  }
  table, td, th {
    /* border: solid 1px #ccc; */
    border-collapse: collapse;
    border-spacing:0;
    color: #000;
    /* background: #DCDCDC; */
    background: #FFF;
    font-weight: bold;
    font-size:18px;
    padding:5px;
    height:40px;
  }

.textAlignVer{
  display:block;
    filter: flipv fliph;
    position:relative;
    white-space:nowrap;
    font-size:12px;
    margin-top: 70px;

}
.textnumberright{
  style="text-align: right;"
}

@font-face {
  font-family: 'DIGITAL';
  src: url('https://cssdeck.com/uploads/resources/fonts/digii/DS-DIGII.TTF');
}



.digital-clock {
  margin: auto;
  top: 0;
  left: 0;
  bottom: 0;
  right: 0;
  color: #000;
  text-align: center;
  font: 50px/60px 'DIGITAL',;
}
.memumain{
  text-align: center;
  font-size:16px;
  padding-top:5px;

}
.digital-date {
  margin: auto;
  top: 0;
  left: 0;
  bottom: 0;
  right: 0;
  color: #000;
  text-align: center;
  font: 50px/60px 'DIGITAL',;
}


.border_bold{
    border: solid 0.2rem #000;

}

.border-top-thin {
    border-top: 0.1rem solid #000;
}

.border-right-thin {
    border-right: 0.1rem solid #000;
}

.border-bottom-thin {
    border-bottom: 0.1rem solid #000;
}

.border-left-thin {
    border-left: 0.1rem solid #000;
}

.v-middle{
  vertical-align: middle !important;
}

.f20 {
  font-size: 20px !important;
}

.f18 {
  font-size: 18px !important;
}

.f17 {
  font-size: 17px !important;
}

.f16 {
  font-size: 16px !important;
}

.f14 {
  font-size: 14px !important;
}

.f12 {
   font-size: 12px !important;
}

.w5{
  width:5rem;
}

.w12{
  width:12rem;
}

.w20{
  width:20rem;
}

.w-10{
  width:10%;
}

.w-15{
  width:15%;
}

.w-40{
  width:40%;
}

.w-70{
  width:70%;
}

.w-85{
  width:85%;
}

.w-90{
  width:90%;
}

.w-auto{
  width:100%;
}

.table-fixed td.text-over span {
    white-space: nowrap;
     overflow: hidden; 
    /* text-overflow: ellipsis; */
    display: inline-block;
    max-width: 150px;
}

.bg-white {
   background: white;
   color: #000;
}

.bg-red {
  background: red;
  color:#FFF;
}

</style>

@section("content")
<div class="w-auto no-gutters d-flex" style="color:#000;">
    <div class="w-85 flex-fill">
        <div style="padding:10px;">
            <table class=" table table-sm border_bold table-fixed">
                <tr>
                  <th style=" padding-top:30px;  width:15%;" rowspan="3" colspan="2" class="text-center border-bottom-thin border-right-thin"><p style="font-size:50px;">5W<p></th>
                  <th colspan="9"  class="text-center border-bottom-thin"><h3>Production Control Board</h3></th>
                </tr>

                <tr>
                  
                  <td colspan="4"  class="border-bottom-thin border-right-thin "><h4>Date : <span class="digital-date"> </span></h4></td>

                  <td colspan="5"  class="text-center border-bottom-thin"><h4>Update Time : <span class="digital-time"> </span> </span></h4></td>

                </tr>
                <tr>
                
                  <td  class="w12 text-center border-bottom-thin border-right-thin ">DIE BOND</td>
                  <td  class="w12 text-center border-bottom-thin border-right-thin ">OVEN DIEBOND</td>
                  <td  class="w12 text-center border-bottom-thin border-right-thin ">WIRE BOND</td>
                  <td  class="w12 text-center border-bottom-thin border-right-thin ">BONDING INS</td>
                  <td  class="w12 text-center border-bottom-thin border-right-thin ">MOLD</td>
                  <td  class="w12 text-center border-bottom-thin border-right-thin ">OVEN MOLD</td>
                  <td  class="w12 text-center border-bottom-thin border-right-thin ">DICER</td>
                  <td  class="w12 text-center border-bottom-thin border-right-thin ">APPEARANCE</td>
                  <td  class="w12 text-center border-bottom-thin  ">CLASSIFY</td>
                
                </tr>
                <tr>
                  <td colspan="2" class="border-bottom-thin border-right-thin ">Today Plan</td>
                  <td  class="f17 text-center border-bottom-thin border-right-thin "><span id="pdieFull"></span></td>
                  <td  class="f17 text-center border-bottom-thin border-right-thin "><span id="povenFull"></span></td>
                  <td  class="f17 text-center border-bottom-thin border-right-thin "><span id="pwireFull"></span></td>
                  <td  class="f17 text-center border-bottom-thin border-right-thin "><span id="pbondinFull"></span></td>
                  <td  class="f17 text-center border-bottom-thin border-right-thin "><span id="pmoldFull"></span></td>
                  <td  class="f17 text-center border-bottom-thin border-right-thin "><span id="povenmoldFull"></span></td>
                  <td  class="f17 text-center border-bottom-thin border-right-thin "><span id="pdicerFull"></span></td>
                  <td  class="f17 text-center border-bottom-thin border-right-thin "><span id="pappeaFull"></span></td>
                  <td  class="f17 text-center border-bottom-thin  "><span class="pcalssFull"></span></td>
                </tr>

                <tr>
                  <td colspan="2" class="border-bottom-thin border-right-thin ">Time line Plan</td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="pdieNow"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="povenNow"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="pwireNow"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="pbondinNow"></span></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="pmoldNow"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="povenmoldNow"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="pdicerNow"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="pappeaNow"></span></td>
                  <td class="f17 text-center border-bottom-thin "><span class="pcalssNow"></span></td> 
                </tr>

                <tr>
                  <td  colspan="2" class=" border-right-thin ">Input (Pcs)</td>
                  <td class="f17 text-center  border-right-thin v-middle"><span id="indieNow" class="f14"></span></td>
                  <td class="f17 text-center  border-right-thin v-middle"><span id="inovenNow" class="f14"></span></td>
                  <td class="f17 text-center  border-right-thin v-middle"><span id="inwirebondNow" class="f14"></span></td>
                  <td class="f17 text-center  border-right-thin v-middle"><span id="inbondingNow" class="f14"></span></td>
                  <td class="f17 text-center  border-right-thin v-middle"><span id="inmoldNow" class="f14"></span></td>
                  <td class="f17 text-center  border-right-thin v-middle"><span id="inovenmoldNow" class="f14"></span></td>
                  <td class="f17 text-center  border-right-thin v-middle"><span id="indicerNow" class="f14"></span></td>
                  <td class="f17 text-center  border-right-thin v-middle"><span id="inappearaNow" class="f20"></span></td>
                  <td class="f17 text-center v-middle "><span id="incalssNow" class="f20"></span></td>
                </tr>

                <tr>
                  <td  colspan="2" class="border-bottom-thin border-right-thin ">Input (Lot)</td>
                  <td class="f17 text-center border-bottom-thin border-right-thin v-middle"><span id="indieNowlot" class="f20" ></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin v-middle"><span id="inovenNowlot" class="f20"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin v-middle"><span id="inwirebondNowlot" class="f20"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin v-middle"><span id="inbondingNowlot" class="f20"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin v-middle"><span id="inmoldNowlot" class="f20"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin v-middle"><span id="inovenmoldNowlot" class="f20"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin v-middle"><span id="indicerNowlot" class="f20"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin v-middle"><span id="inappearaNowlot" class="f14"></span></td>
                  <td class="f17 text-center border-bottom-thin v-middle "><span id="incalssNowlot" class="f14"></span></td>
                </tr>

                <tr id="Output">
                </tr>

                <tr id="Outputlot">
                </tr>  

                <tr id="Resultok">
                </tr>  

                <tr id="Resultpercen">
                </tr>

                <tr>
                  <td  colspan="2" class="f17  border-right-thin ">NG</td>
                  <td class="f17 text-center  border-right-thin "><span id="ngdiebond">0</span></td>
                  <td class="f17 text-center  border-right-thin "><span id="ngovendiebond">0</span></td>
                  <td class="f17 text-center  border-right-thin "><span id="ngwirebond">0</span></td>
                  <td class="f17 text-center  border-right-thin "><span id="ngbonding"></span></td>
                  <td class="f17 text-center  border-right-thin "><span id="ngmold"></span></td>
                  <td class="f17 text-center  border-right-thin "><span id="ngovenmold">0</span></td>
                  <td class="f17 text-center  border-right-thin "><span id="ngdicer"></span></td>
                  <td class="f17 text-center  border-right-thin "><span id="ngappear"></span></td>
                  <td class="f17 text-center   "><span id="ngclassify"></span></td>
                </tr>
                <tr id="Png">
                  
                </tr>
                <!-- <tr>
                  <td colspan="2" style="text-align: center;">TOP 2 NG</td>
                  <td colspan="12" style="text-align: center;"></td>


                </tr> -->
                <tr>
                  <td rowspan="2"  class="f16  text-center v-middle border-bottom-thin border-right-thin" style="width:5%">BONDING<br/>INS</td>
                  <td class="f16 border-right-thin text-over" nowrap style="width:7%"><span id="ant3bonding1"></span></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "><span id="sumant3bonding1"></span>%</td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  "></td>
                </tr>
                <tr>
                  <td class="f16 border-right-thin text-over border-bottom-thin " nowrap><span id="ant3bonding2"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="sumast3bonding2"></span>%</td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin  "></td>
                </tr>
                <tr>

                <td rowspan="2" class="f16  text-center v-middle border-bottom-thin border-right-thin">MOLD</td>
                  <td class="f16 border-right-thin text-over" nowrap><span id="ant3mold1"></span></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "><span id="sumant3mold1"></span>%</td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center   "></td>
                </tr>
                <tr>
                  <td class="f16 border-right-thin text-over border-bottom-thin " nowrap><span id="ant3mold2"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="sumant3mold2"></span>%</td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin  "></td>
                </tr>

                <tr>
                  <td rowspan="2" class="f16  text-center v-middle border-bottom-thin border-right-thin">DICER</td>
                  <td class="f16 border-right-thin text-over" nowrap><span id="ant3dicer1"></span></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin " style="text-align: right;"><span id="sumant3dicer1"></span>%</td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center   "></td>
                </tr>
                <tr>
                  <td class="f16 border-right-thin text-over border-bottom-thin " nowrap><span id="ant3dicer2"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="sumant3dicer2"></span>%</td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin  "></td>
                
                </tr>

                <tr>
                  <td rowspan="2" class="f16  text-center v-middle border-bottom-thin border-right-thin">APPEARANCE</td>
                  <td class="f16 border-right-thin text-over" nowrap><span id="ant3appea1"></span></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "><span id="sumant3appea1"></span>%</td>
                  <td class="f17 text-center   "></td>
                </tr>
                <tr>
                  <td class="f16 border-right-thin text-over border-bottom-thin " nowrap><span id="ant3appea2"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="sumant3appea2"></span>%</td>
                  <td class="f17 text-center border-bottom-thin  "></td>              
                </tr>

                <tr>
                  <td rowspan="2" class="f16  text-center v-middle border-bottom-thin border-right-thin">CLASSIFYING</td>
                  <td class="f16 border-right-thin text-over" nowrap><span id="ant3classi1"></span></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center  border-right-thin "></td>
                  <td class="f17 text-center   "> <span id="sumant3classi1"></span>%</td>
                </tr>
                <tr>
                  <td class="f16 border-right-thin text-over border-bottom-thin" nowrap><span id="ant3classi2"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "></td>
                  <td class="f17 text-center border-bottom-thin  "><span id="sumant3classi2"></span>%</td>            
                </tr>
      
                <tr>
                  <td colspan="2" class="f17 border-right-thin border-bottom-thin">LOT OUT</td>  <!-- output - ok - ng = Lot out -->
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_a"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_b"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_c"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_d"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_e"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_f"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_g"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_p"></span></td>
                  <td class="f17 text-center border-bottom-thin  "><span id="lotout_q"></span></td>
                
                </tr>
                <tr>
                  <td colspan="2" class="f17 border-right-thin border-bottom-thin">% LOT OUT</td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_percen_a"></span>%</td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_percen_b"></span>%</td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_percen_c"></span>%</td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_percen_d"></span>%</td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_percen_e"></span>%</td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_percen_f"></span>%</td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_percen_g"></span>%</td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="lotout_percen_p"></span>%</td>
                  <td class="f17 text-center border-bottom-thin  "><span id="lotout_percen_q"></span>%</td>
                
                </tr>
                <tr >
                  <td colspan="2" rowspan="2" class="f17 border-right-thin border-bottom-thin">Remark</td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkdie_a1"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkoven_a1"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkwirebond_a1"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkbonding_a1"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkmold_a1"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkovenmold_a1"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkdicer_a1"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkappearance_a1"></span></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkclassif_a1"></span></td>
                </tr>

                <tr >
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkdie_a2"></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkoven_a2"></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkwirebond_a2"></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkbonding_a2"></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkmold_a2"></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkovenmold_a2"></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkdicer_a2"></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkappearance_a2"></td>
                  <td class="f17 text-center border-bottom-thin border-right-thin "><span id="remarkclassif_a2"></td>
                </tr>           
            </table>
        </div>  
    </div>
    <div class="w-15 flex-fill" >
        <div class="mt-4">
            <div  style=""><h5 class=" font-weight-bold">Production Control Board</h5></div>
            <div class="d-flex">
                <div class="f18 font-weight-bold w5 border-bottom-thin">5W</div> <div class="f18 font-weight-bold">LINE</div>
            </div>
            <div class="f18 font-weight-bold ">In Charge of : Ms.Dennapa</div>

            @include("display.tablerptsum")

        </div>   
    </div>  
</div>

@endsection
@section("script")
<script type="text/javascript">
$(document).ready(function () {

    loadData();
    clockUpdate();
    setInterval(clockUpdate, 1000);

    setTimeout(function() {
      loadData();
    }, 30000);

    setTimeout(function() {
        location.replace("screen3");
    }, 300000);

});

function timerefresh(t)
{
if(t==0){
  loadData();
    }
else{
    t--;
  }
window.setTimeout("timerefresh('"+t+"')",1000)
}

timerefresh(10);

function clockUpdate() {
  var date = new Date();
  $('.digital-clock').css({'color': '#FFFF'});
  function addZero(x) {
    if (x < 10) {
      return x = '0' + x;
    } else {
      return x;
    }
  }

  function twelveHour(x) {
    if (x > 24) {
      return x = x - 24;
    } else if (x == 0) {
      return x = 24;
    } else {
      return x;
    }
  }

  var h = addZero(twelveHour(date.getHours()));
  var m = addZero(date.getMinutes());
  var s = addZero(date.getSeconds());

  $('.digital-clock').text(h + ':' + m + ':' + s)
}



function loadData() {
    $.ajax({
 
        url:'{{url("loaddata")}}',
        type:'get',
        data:'',
        dataType:'json',
        success:function(ret){

              $("#Output").empty();
              $("#Outputlot").empty();
              $("#Resultok").empty();
              $("#Resultpercen").empty();
              $("#Png").empty();
              
        
              pdieFull = ret['pdieFull'];
              pdieNow = ret['pdieNow'];
              povenFull = ret['povenFull'];
              povenNow = ret['povenNow'];
              pwireFull = ret['pwireFull'];
              pwireNow = ret['pwireNow'];
              pbondinFull = ret['pbondinFull'];
              pbondinNow = ret['pbondinNow'];
              pmoldFull = ret['pmoldFull'];
              pmoldNow = ret['pmoldNow'];
              povenmoldFull = ret['povenmoldFull'];
              povenmoldNow = ret['povenmoldNow'];
              pdicerFull = ret['pdicerFull'];
              pdicerNow = ret['pdicerNow'];
              pappeaFull = ret['pappeaFull'];
              pappeaNow = ret['pappeaNow'];
              pcalssFull = ret['pcalssFull'];
              pcalssNow = ret['pcalssNow'];

              indieNow = ret['indieNow'];
              inovenNow = ret['inovenNow'];
              inwirebondNow = ret['inwirebondNow'];
              inbondingNow = ret['inbondingNow'];
              inmoldNow = ret['inmoldNow'];
              inovenmoldNow = ret['inovenmoldNow'];
              indicerNow = ret['indicerNow'];
              inappearaNow = ret['inappearaNow'];
              incalssNow = ret['incalssNow'];

              // input lot
              indieNowlot = ret['indieNowlot']; 
              inovenNowlot = ret['inovenNowlot'];
              inwirebondNowlot = ret['inwirebondNowlot'];
              inbondingNowlot = ret['inbondingNowlot'];
              inmoldNowlot = ret['inmoldNowlot'];
              inovenmoldNowlot = ret['inovenmoldNowlot'];
              indicerNowlot = ret['indicerNowlot'];
              inappearaNowlot = ret['inappearaNowlot'];
              incalssNowlot = ret['incalssNowlot'];
              // end input lot

              outdieend = ret['outdieend'];
              outovenend = ret['outovenend'];
              outwirebondend = ret['outwirebondend'];
              outbondingend = ret['outbondingend'];
              outmoldend = ret['outmoldend'];
              outoven_moldend = ret['outoven_moldend'];
              outdicer_actend = ret['outdicer_actend'];
              outappearanceend = ret['outappearanceend'];
              outclassifyend = ret['outclassifyend'];

              // output lot
              outdieendlot = ret['outdieendlot'];
              outovenendlot = ret['outovenendlot'];
              outwirebondendlot = ret['outwirebondendlot'];
              outbondingendlot = ret['outbondingendlot'];
              outmoldendlot = ret['outmoldendlot'];
              outoven_moldendlot = ret['outoven_moldendlot'];
              outdicer_actendlot = ret['outdicer_actendlot'];
              outappearanceendlot = ret['outappearanceendlot'];
              outclassifyendlot = ret['outclassifyendlot'];
              // end output lot

              ngdiebond = 0;
              ngovendiebond = 0;
              ngwirebond = 0;
              ngbonding = (ret['ngbonding'][0].ngbonding==null)?0:ret['ngbonding'][0].ngbonding;
              ngmold = (ret['ngmold'][0].ngmold==null)?0:ret['ngmold'][0].ngmold;
              //console.log(ret['ngmold'][0].ngmold);
              ngovenmold = 0;
              ngdicer = (ret['ngdicer'][0].ngdicer==null)?0:ret['ngdicer'][0].ngdicer;
              ngappear = (ret['ngappear'][0].ngappear==null)?0:ret['ngappear'][0].ngappear;
              ngclassify = (ret['ngclassify'][0].ngclassify==null)?0:ret['ngclassify'][0].ngclassify;

              t3bonding = ret['t3bonding'];
              t3mold = ret['t3mold'];
              t3dicer = ret['t3dicer'];
              t3appea = ret['t3appea'];
              t3classi = ret['t3classi'];
              dateshow = ret['dateshow'];
              timeshow = ret['timeshow'];

              datestring = ret['datestring'];

              $('.digital-date').text(dateshow);
              $('.digital-time').text(timeshow);
              $('.datestring').text(datestring);

              var indieNow1 = 0;
              var inovenNow1 = 0;
              var inwirebondNow1 = 0;
              var inbondingNow1 = 0;
              var inmoldNow1 = 0;
              var inovenmoldNow1 = 0;
              var indicerNow1 = 0;
              var inappearaNow1 = 0;
              var incalssNow1 = 0;

              var outbondingend2 = 0;
              var outmoldend2 = 0;
              var outdicer_actend2 = 0;
              var outappearanceend2 = 0;
              var outclassifyend2 = 0;


              var DiSumResult = 0;
              var OdiSumResult = 0;
              var WieSumResult = 0;
              var BondSumResult = 0;
              var MoldSumResult = 0;
              var OvenmoSumResult = 0;
              var DicerSumResult = 0;
              var MoldSumResult = 0;
              var AppeaSumResult = 0;
              var ClassSumResult = 0;

              var NgSumdiebond = 0;
              var NgSumovendiebond = 0;
              var NgSumwirebond = 0;
              var NgSumbonding = 0;
              var NgSumngmold = 0;
              var NgSumngovenmold = 0;
              var NgSumngdicer = 0;
              var NgSumngappear = 0;
              var NgSumngclassify = 0;

              var lotout_a = 0;
              var lotout_b = 0;
              var lotout_c = 0;
              var lotout_d = 0;
              var lotout_e = 0;
              var lotout_f = 0;
              var lotout_g = 0;
              var lotout_p = 0;
              var lotout_q = 0;

              var lotout_percen_a = 0;
              var lotout_percen_b = 0;
              var lotout_percen_c = 0;
              var lotout_percen_d = 0;
              var lotout_percen_e = 0;
              var lotout_percen_f = 0;
              var lotout_percen_g = 0;
              var lotout_percen_p = 0;
              var lotout_percen_q = 0;
              
              var diebond_ok = 0;
              var ovendiebond_ok = 0;
              var wirebond_ok = 0;
              var bondingins_ok = 0;
              var mold_ok = 0;
              var ovenmold_ok = 0;
              var dicer_ok = 0;
              var appear_ok = 0;
              var classify_ok = 0;

              if(indieNow[0].indieNow !== 0){ indieNow1 = numeral(indieNow[0].indieNow).format('0,0')}else{ indieNow1 = 0.001};
              if(inovenNow[0].inovenNow !== 0){ inovenNow1 = numeral(inovenNow[0].inovenNow).format('0,0')}else{ inovenNow1 = 0.001};
              if(inwirebondNow[0].inwirebondNow !== 0){ inwirebondNow1 = numeral(inwirebondNow[0].inwirebondNow).format('0,0')}else{ inwirebondNow1 = 0.001};
              if(inbondingNow[0].inbondingNow !== 0){ inbondingNow1 = numeral(inbondingNow[0].inbondingNow).format('0,0')}else{ inbondingNow1 = 0.001};
              if(inmoldNow[0].inmoldNow !== 0){ inmoldNow1 = numeral(inmoldNow[0].inmoldNow).format('0,0')}else{ inmoldNow1 = 0.001};
              if( typeof(inovenmoldNow[0]) != "undefined" && inovenmoldNow[0].inovenmoldNow !== 0){ inovenmoldNow1 = numeral(inovenmoldNow[0].inovenmoldNow).format('0,0')}else{ inovenmoldNow1 = 0.001};
              if(indicerNow[0].indicerNow !== 0){ indicerNow1 = numeral(indicerNow[0].indicerNow).format('0,0')}else{ indicerNow1 = 0.001};
              if(inappearaNow[0].inappearaNow !== 0){ inappearaNow1 = numeral(inappearaNow[0].inappearaNow).format('0,0')}else{ inappearaNow1 = 0.001};
              if(incalssNow[0].incalssNow !== 0){ incalssNow1 = numeral(incalssNow[0].incalssNow).format('0,0')}else{ incalssNow1 = 0.001};

              if(outbondingend[0].outbondingend !== 0){ outbondingend2 = numeral(outbondingend[0].outbondingend).format('0,0')}else{ outbondingend2 = 0.001};
              if(outmoldend[0].outmoldend !== 0){ outmoldend2 = numeral(outmoldend[0].outmoldend).format('0,0')}else{ outmoldend2 = 0.001};
              if(outdicer_actend[0].outdicer_actend !== 0){ outdicer_actend2 = numeral(outdicer_actend[0].outdicer_actend).format('0,0')}else{ outdicer_actend2 = 0.001};
              if(outappearanceend[0].outappearanceend !== 0){ outappearanceend2 = numeral(outappearanceend[0].outappearanceend).format('0,0')}else{ outappearanceend2 = 0.001};
              if(outclassifyend[0].outclassifyend !== 0){ outclassifyend2 = numeral(outclassifyend[0].outclassifyend).format('0,0')}else{ outclassifyend2 = 0.001};

              NgSumbonding = (numeral(ngbonding).value() / numeral(outbondingend2).value()) * 100 ;
              NgSumngmold = (numeral(ngmold).value() / numeral(outmoldend2).value()) * 100 ;
              NgSumngdicer = (numeral(ngdicer).value() / numeral(outdicer_actend2).value()) * 100 ;
              NgSumngappear = (numeral(ngappear).value() / numeral(outappearanceend2).value()) * 100 ;
              NgSumngclassify = (numeral(ngclassify).value() / numeral(outclassifyend2).value()) * 100 ;


              diebond_ok =  (numeral(outdieend[0].outdieend).value() - numeral(ngdiebond).value());
              ovendiebond_ok =  (numeral(outovenend[0].outovenend).value() - numeral(ngovendiebond).value());
              wirebond_ok =  (numeral(outwirebondend[0].outwirebondend).value() - numeral(ngwirebond).value());
              bondingins_ok =  (numeral(outbondingend[0].outbondingend).value() - numeral(ngbonding).value());
              mold_ok =  (numeral(outmoldend[0].outmoldend).value() - numeral(ngmold).value());
              ovenmold_ok =  (numeral(outoven_moldend[0].outoven_moldend).value() - numeral(ngovenmold).value());
              dicer_ok =  (numeral(outdicer_actend[0].outdicer_actend).value()  -numeral(ngdicer).value());
              appear_ok =  (numeral(outappearanceend[0].outappearanceend).value() - numeral(ngappear).value());
              classify_ok =  (numeral(outclassifyend[0].outclassifyend).value() - numeral(ngclassify).value() );

              lotout_a = (numeral(outdieend[0].outdieend).value() - numeral(diebond_ok).value()) - numeral(ngdiebond).value();
              lotout_b = (numeral(outovenend[0].outovenend).value() - numeral(ovendiebond_ok).value()) - numeral(ngovendiebond).value() ;
              lotout_c = (numeral(outwirebondend[0].outwirebondend).value() - numeral(wirebond_ok).value()) - numeral(ngwirebond).value() ;
              lotout_d = (numeral(outbondingend[0].outbondingend).value() - numeral(bondingins_ok).value()) - numeral(ngbonding).value() ;
              lotout_e = (numeral(outmoldend[0].outmoldend).value() - numeral(mold_ok).value()) - numeral(ngmold).value() ;
              lotout_f = (numeral(outoven_moldend[0].outoven_moldend).value() - numeral(ovenmold_ok).value()) - numeral(ngovenmold).value() ;
              lotout_g = (numeral(outdicer_actend[0].outdicer_actend).value() - numeral(dicer_ok).value()) - numeral(ngdicer).value();
              lotout_p = (numeral(outappearanceend[0].outappearanceend).value() - numeral(appear_ok).value()) - numeral(ngappear).value() ;
              lotout_q = (numeral(outclassifyend[0].outclassifyend).value() - numeral(classify_ok).value()) - numeral(ngclassify).value() ;

              lotout_percen_a = numeral(lotout_a).value() / numeral(indieNow[0].indieNow).value()
              lotout_percen_b = numeral(lotout_b).value() / numeral(inovenNow[0].inovenNow).value()
              lotout_percen_c = numeral(lotout_c).value() / numeral(inwirebondNow[0].inwirebondNow).value()
              lotout_percen_d = numeral(lotout_d).value() / numeral(inbondingNow[0].inbondingNow).value()
              lotout_percen_e = numeral(lotout_e).value() / numeral(inmoldNow[0].inmoldNow).value()
              lotout_percen_f = numeral(lotout_f).value() / numeral(inovenmoldNow[0].inovenmoldNow).value()
              lotout_percen_g = numeral(lotout_g).value() / numeral(indicerNow[0].indicerNow).value()
              lotout_percen_p = numeral(lotout_p).value() / numeral(inappearaNow[0].inappearaNow).value()
              lotout_percen_q = numeral(lotout_q).value() / numeral(incalssNow[0].incalssNow).value()

              var bg_lotout_percen_a = "bg-white";
              var bg_lotout_percen_b = "bg-white";
              var bg_lotout_percen_c = "bg-white";
              var bg_lotout_percen_d = "bg-white";
              var bg_lotout_percen_e = "bg-white";
              var bg_lotout_percen_f = "bg-white";
              var bg_lotout_percen_g = "bg-white";
              var bg_lotout_percen_p = "bg-white";
              var bg_lotout_percen_q = "bg-white";

              if( lotout_percen_a>0 ) { bg_lotout_percen_a = "bg-red"; }
              if( lotout_percen_b>0 ) { bg_lotout_percen_b = "bg-red"; }
              if( lotout_percen_c>0 ) { bg_lotout_percen_c = "bg-red"; }
              if( lotout_percen_d>0 ) { bg_lotout_percen_d = "bg-red"; }
              if( lotout_percen_e>0 ) { bg_lotout_percen_e = "bg-red"; }
              if( lotout_percen_f>0 ) { bg_lotout_percen_f = "bg-red"; }
              if( lotout_percen_g>0 ) { bg_lotout_percen_g = "bg-red"; }
              if( lotout_percen_p>0 ) { bg_lotout_percen_p = "bg-red"; }
              if( lotout_percen_q>0 ) { bg_lotout_percen_q = "bg-red"; }



              $("#pdieFull").text(numeral(pdieFull[0].pdieFull).format('0,0'));
              $("#pdieNow").text(numeral(pdieNow[0].pdieNow).format('0,0'));
              $("#povenNow").text(numeral(povenNow[0].povenNow).format('0,0'));
              $("#povenFull").text(numeral(povenFull[0].povenFull).format('0,0'));
              $("#pwireFull").text(numeral(pwireFull[0].pwireFull).format('0,0'));
              $("#pwireNow").text(numeral(pwireNow[0].pwireNow).format('0,0'));
              $("#pbondinFull").text(numeral(pbondinFull[0].pbondinFull).format('0,0'));
              $("#pbondinNow").text(numeral(pbondinNow[0].pbondinNow).format('0,0'));
              $("#pmoldFull").text(numeral(pmoldFull[0].pmoldFull).format('0,0'));
              $("#pmoldNow").text(numeral(pmoldNow[0].pmoldNow).format('0,0'));
              $("#povenmoldFull").text(numeral(povenmoldFull[0].povenmoldFull).format('0,0'));
              $("#povenmoldNow").text(numeral(povenmoldNow[0].povenmoldNow).format('0,0'));
              $("#pdicerNow").text(numeral(pdicerNow[0].pdicerNow).format('0,0'));
              $("#pdicerFull").text(numeral(pdicerFull[0].pdicerFull).format('0,0'));
              $("#pappeaFull").text(numeral(pappeaFull[0].pappeaFull).format('0,0'));
              $("#pappeaNow").text(numeral(pappeaNow[0].pappeaNow).format('0,0'));
              $(".pcalssFull").text(numeral(pcalssFull[0].pcalssFull).format('0,0'));
              $(".pcalssNow").text(numeral(pcalssNow[0].pcalssNow).format('0,0'));

              $(".ocalsspcs").text(numeral(outclassifyend[0].outclassifyend).format('0,0'));

              
              var difclass = numeral(outclassifyend[0].outclassifyend).value() - numeral(pcalssNow[0].pcalssNow).value() 
              if( difclass<0 ){
                $(".difclass").addClass("text-danger");
              }else{
                $(".difclass").removeClass("text-danger");
              }
              $(".difclass").text(numeral(difclass).format('0,0'));
              
              $("#indieNow").text(numeral(indieNow[0].indieNow).format('0,0'));
              $("#inovenNow").text(numeral(inovenNow[0].inovenNow).format('0,0'));
              $("#inwirebondNow").text(numeral(inwirebondNow[0].inwirebondNow).format('0,0'));
              $("#inbondingNow").text(numeral(inbondingNow[0].inbondingNow).format('0,0'));
              $("#inmoldNow").text(numeral(inmoldNow[0].inmoldNow).format('0,0'));
              $("#inovenmoldNow").text(numeral(inovenmoldNow[0].inovenmoldNow).format('0,0'));
              $("#indicerNow").text(numeral(indicerNow[0].indicerNow).format('0,0'));
              $("#inappearaNow").text(numeral(inappearaNow[0].inappearaNow).format('0,0'));
              $("#incalssNow").text(numeral(incalssNow[0].incalssNow).format('0,0'));

              // start input lot
              $("#indieNowlot").text(numeral(indieNowlot[0].indieNowlot).format('0,0'));
              $("#inovenNowlot").text(numeral(inovenNowlot[0].inovenNowlot).format('0,0'));
              $("#inwirebondNowlot").text(numeral(inwirebondNowlot[0].inwirebondNowlot).format('0,0'));
              $("#inbondingNowlot").text(numeral(inbondingNowlot[0].inbondingNowlot).format('0,0'));
              $("#inmoldNowlot").text(numeral(inmoldNowlot[0].inmoldNowlot).format('0,0'));
              $("#inovenmoldNowlot").text(numeral(inovenmoldNowlot[0].inovenmoldNowlot).format('0,0'));
              $("#indicerNowlot").text(numeral(indicerNowlot[0].indicerNowlot).format('0,0'));
              $("#inappearaNowlot").text(numeral(inappearaNowlot[0].inappearaNowlot).format('0,0'));
              $("#incalssNowlot").text(numeral(incalssNowlot[0].incalssNowlot).format('0,0'));
              // end input lot

              $("#ngdiebond").text(numeral(ngdiebond).format('0,0'));
              $("#ngovendiebond").text(numeral(ngovendiebond).format('0,0'));
              $("#ngwirebond").text(numeral(ngwirebond).format('0,0'));
              $("#ngbonding").text(numeral(ngbonding).format('0,0'));
              $("#ngmold").text(numeral(ngmold).format('0,0'));
              $("#ngovenmold").text(numeral(ngovenmold).format('0,0'));
              $("#ngdicer").text(numeral(ngdicer).format('0,0'));
              $("#ngappear").text(numeral(ngappear).format('0,0'));
              $("#ngclassify").text(numeral(ngclassify).format('0,0'));

              $("#lotout_a").text(numeral(lotout_a).format('0,0'));
              $("#lotout_b").text(numeral(lotout_b).format('0,0'));
              $("#lotout_c").text(numeral(lotout_c).format('0,0'));
              $("#lotout_d").text(numeral(lotout_d).format('0,0'));
              $("#lotout_e").text(numeral(lotout_e).format('0,0'));
              $("#lotout_f").text(numeral(lotout_f).format('0,0'));
              $("#lotout_g").text(numeral(lotout_g).format('0,0'));
              $("#lotout_p").text(numeral(lotout_p).format('0,0'));
              $("#lotout_q").text(numeral(lotout_q).format('0,0'));

              $("#lotout_percen_a").text(numeral(numeral(lotout_percen_a).value() * 100).format('0,0.00')).removeClass("bg-white bg-red").addClass(bg_lotout_percen_a);
              $("#lotout_percen_b").text(numeral(numeral(lotout_percen_b).value() * 100).format('0,0.00')).removeClass("bg-white bg-red").addClass(bg_lotout_percen_b);
              $("#lotout_percen_c").text(numeral(numeral(lotout_percen_c).value() * 100).format('0,0.00')).removeClass("bg-white bg-red").addClass(bg_lotout_percen_c);
              $("#lotout_percen_d").text(numeral(numeral(lotout_percen_d).value() * 100).format('0,0.00')).removeClass("bg-white bg-red").addClass(bg_lotout_percen_d);
              $("#lotout_percen_e").text(numeral(numeral(lotout_percen_e).value() * 100).format('0,0.00')).removeClass("bg-white bg-red").addClass(bg_lotout_percen_e);
              $("#lotout_percen_f").text(numeral(numeral(lotout_percen_f).value() * 100).format('0,0.00')).removeClass("bg-white bg-red").addClass(bg_lotout_percen_f);
              $("#lotout_percen_g").text(numeral(numeral(lotout_percen_g).value() * 100).format('0,0.00')).removeClass("bg-white bg-red").addClass(bg_lotout_percen_g);
              $("#lotout_percen_p").text(numeral(numeral(lotout_percen_p).value() * 100).format('0,0.00')).removeClass("bg-white bg-red").addClass(bg_lotout_percen_p);
              $("#lotout_percen_q").text(numeral(numeral(lotout_percen_q).value() * 100).format('0,0.00')).removeClass("bg-white bg-red").addClass(bg_lotout_percen_q);


              DiSumResult   = (numeral(outdieend[0].outdieend).value() / numeral(indieNow1).value()) * 100 ;
              OieSumResult  = (numeral(outovenend[0].outovenend).value() / numeral(inovenNow1).value()) * 100 ;
              WieSumResult  = (numeral(outwirebondend[0].outwirebondend).value() / numeral(inwirebondNow1).value()) * 100 ;
              BondSumResult = (numeral(outbondingend[0].outbondingend).value() / numeral(inbondingNow1).value()) * 100 ;
              MoldSumResult = (numeral(outmoldend[0].outmoldend).value() / numeral(inmoldNow1).value()) * 100 ;
              OvenmoSumResult= (numeral(outoven_moldend[0].outoven_moldend).value() / numeral(inovenmoldNow1).value()) * 100 ;
              DicerSumResult = (numeral(outdicer_actend[0].outdicer_actend).value() / numeral(indicerNow1).value()) * 100 ;
              AppeaSumResult = (numeral(outappearanceend[0].outappearanceend).value() / numeral(inappearaNow1).value()) * 100 ;
              ClassSumResult = (numeral(outclassifyend[0].outclassifyend).value() / numeral(incalssNow1).value()) * 100 ;
      

              if(DiSumResult >= 100 && DiSumResult != 0){var a ='background-color: lime;color: #000;'}else if( DiSumResult <100 && DiSumResult> 0 ){ var a ='background-color: red ;color: #FFF;' }else {var a = "" };
              if(OieSumResult >= 100 && OieSumResult != 0){var b ='background-color: lime;color: #000;'}else if( OieSumResult <100 && OieSumResult> 0){var b ='background-color: red ;color: #FFF;' }else {var b = ""};
              if(WieSumResult >= 100 && WieSumResult != 0){var c ='background-color: lime;color: #000;'}else if( WieSumResult <100 && WieSumResult> 0 ){ var c ='background-color: red ;color: #FFF;' }else {var c = "" };
              if(BondSumResult >= 100 && BondSumResult != 0){var d ='background-color: lime;color: #000;'}else if( BondSumResult <100 && BondSumResult> 0 ){ var d ='background-color: red ;color: #FFF;' }else {var d = "" };
              if(MoldSumResult >= 100 && MoldSumResult != 0){var e ='background-color: lime;color: #000;'}else if( MoldSumResult <100 && MoldSumResult> 0){var e ='background-color: red ;color: #FFF;' }else {var e = ""};
              if(DicerSumResult >= 100 && DicerSumResult != 0){var f ='background-color: lime;color: #000;'}else if( DicerSumResult <100 && DicerSumResult> 0 ){ var f  ='background-color: red ;color: #FFF;' }else {var f = "" };
              if(OvenmoSumResult >= 100 && OvenmoSumResult != 0){var g ='background-color: lime;color: #000;'}else if( OvenmoSumResult <100 && OvenmoSumResult> 0){var g ='background-color: red ;color: #FFF;' }else {var g = ""};
              if(AppeaSumResult >= 100 && AppeaSumResult != 0){var p ='background-color: lime;color: #000;'}else if( AppeaSumResult <100 && AppeaSumResult> 0 ){ var p ='background-color: red ;color: #FFF;' }else {var p = "" };
              if(ClassSumResult >= 95 && ClassSumResult != 0){var q ='background-color: lime;color: #000;'}else if( ClassSumResult <95 && ClassSumResult> 0){var q ='background-color: red ;color: #FFF;' }else {var q = ""};

              var color_out_a = "";
              var color_out_b = "";
              var color_out_c = "";
              var color_out_d = "";
              var color_out_e = "";
              var color_out_f = "";
              var color_out_g = "";
              var color_out_p = "";
              var color_out_q = "";

              var color_outlot_a = "";
              var color_outlot_b = "";
              var color_outlot_c = "";
              var color_outlot_d = "";
              var color_outlot_e = "";
              var color_outlot_f = "";
              var color_outlot_g = "";
              var color_outlot_p = "";
              var color_outlot_q = "";

              if( numeral(outdieend[0].outdieend).value() < numeral(indieNow[0].indieNow).value() ){ color_out_a = 'background-color:red; color: #FFF;' }
              if( numeral(outovenend[0].outovenend).value() < numeral(inovenNow[0].inovenNow).value() ){ color_out_b = 'background-color:red; color: #FFF;' }
              if( numeral(outwirebondend[0].outwirebondend).value() < numeral(inwirebondNow[0].inwirebondNow).value() ){ color_out_c = 'background-color:red; color: #FFF;' } 
              if( numeral(outbondingend[0].outbondingend).value() < numeral(inbondingNow[0].inbondingNow).value() ){ color_out_d = 'background-color:red; color: #FFF;' } 
              if( numeral(outmoldend[0].outmoldend).value() < numeral(inmoldNow[0].inmoldNow).value() ){ color_out_e = 'background-color:red; color: #FFF;' } 
              if( numeral(outoven_moldend[0].outoven_moldend).value() < numeral(inovenmoldNow[0].inovenmoldNow).value() ){ color_out_f = 'background-color:red; color: #FFF;' } 
              if( numeral(outdicer_actend[0].outdicer_actend).value() < numeral(indicerNow[0].indicerNow).value() ){ color_out_g = 'background-color:red; color: #FFF;' } 
              if( numeral(outappearanceend[0].outappearanceend).value() < numeral(inappearaNow[0].inappearaNow).value() ){ color_out_p = 'background-color:red; color: #FFF;' } 
              if( numeral(outclassifyend[0].outclassifyend).value() < numeral(incalssNow[0].incalssNow).value() ){ color_out_q = 'background-color:red; color: #FFF;' } 
          
              strOutput = '<td  colspan="2" class=" border-right-thin ">Output (Pcs)</td>'
                      +'<td class="f17 text-center  border-right-thin v-middle" style="'+ color_out_a +'"><span class="f14">'+ numeral(outdieend[0].outdieend).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center  border-right-thin v-middle" style="'+ color_out_b +'"><span class="f14">'+ numeral(outovenend[0].outovenend).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center  border-right-thin v-middle" style="'+ color_out_c +'"><span class="f14">'+ numeral(outwirebondend[0].outwirebondend).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center  border-right-thin v-middle" style="'+ color_out_d +'"><span class="f14">'+ numeral(outbondingend[0].outbondingend).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center  border-right-thin v-middle" style="'+ color_out_e +'"><span class="f14">'+ numeral(outmoldend[0].outmoldend).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center  border-right-thin v-middle" style="'+ color_out_f +'"><span class="f14">'+ numeral(outoven_moldend[0].outoven_moldend).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center  border-right-thin v-middle" style="'+ color_out_g +'"><span class="f14">'+ numeral(outdicer_actend[0].outdicer_actend).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center  border-right-thin v-middle" style="'+ color_out_p +'"><span class="f20">'+ numeral(outappearanceend[0].outappearanceend).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center  border-right-thin v-middle" style="'+ color_out_q +'"><span class="f20">'+ numeral(outclassifyend[0].outclassifyend).format('0,0') +'</span></td>';
              $("#Output").append(strOutput);


              if( numeral(outdieendlot[0].outdieendlot).value() < numeral(indieNowlot[0].indieNowlot).value() ){ color_outlot_a = 'background-color:red; color: #FFF;' }
              if( numeral(outovenendlot[0].outovenendlot).value() < numeral(inovenNowlot[0].inovenNowlot).value() ){ color_outlot_b = 'background-color:red; color: #FFF;' }
              if( numeral(outwirebondendlot[0].outwirebondendlot).value() < numeral(inwirebondNowlot[0].inwirebondNowlot).value() ){ color_outlot_c = 'background-color:red; color: #FFF;' } 
              if( numeral(outbondingendlot[0].outbondingendlot).value() < numeral(inbondingNowlot[0].inbondingNowlot).value() ){ color_outlot_d = 'background-color:red; color: #FFF;' } 
              if( numeral(outmoldendlot[0].outmoldendlot).value() < numeral(inmoldNowlot[0].inmoldNowlot).value() ){ color_outlot_e = 'background-color:red; color: #FFF;' } 
              if( numeral(outoven_moldendlot[0].outoven_moldendlot).value() < numeral(inovenmoldNowlot[0].inovenmoldNowlot).value() ){ color_outlot_f = 'background-color:red; color: #FFF;' } 
              if( numeral(outdicer_actendlot[0].outdicer_actendlot).value() < numeral(indicerNowlot[0].indicerNowlot).value() ){ color_outlot_g = 'background-color:red; color: #FFF;' } 
              if( numeral(outappearanceendlot[0].outappearanceendlot).value() < numeral(inappearaNowlot[0].inappearaNowlot).value() ){ color_outlot_p = 'background-color:red; color: #FFF;' } 
              if( numeral(outclassifyendlot[0].outclassifyendlot).value() < numeral(incalssNowlot[0].incalssNowlot).value() ){ color_outlot_q = 'background-color:red; color: #FFF;' } 
              
              strOutputlot = '<td  colspan="2" class="border-bottom-thin border-right-thin ">Output (Lot)</td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin v-middle" style="'+ color_outlot_a +'" ><span class="f20">'+ numeral(outdieendlot[0].outdieendlot).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin v-middle" style="'+ color_outlot_b +'" ><span class="f20">'+ numeral(outovenendlot[0].outovenendlot).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin v-middle" style="'+ color_outlot_c +'" ><span class="f20">'+ numeral(outwirebondendlot[0].outwirebondendlot).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin v-middle" style="'+ color_outlot_d +'" ><span class="f20">'+ numeral(outbondingendlot[0].outbondingendlot).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin v-middle" style="'+ color_outlot_e +'" ><span class="f20">'+ numeral(outmoldendlot[0].outmoldendlot).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin v-middle" style="'+ color_outlot_f +'" ><span class="f20">'+ numeral(outoven_moldendlot[0].outoven_moldendlot).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin v-middle" style="'+ color_outlot_g +'" ><span class="f20">'+ numeral(outdicer_actendlot[0].outdicer_actendlot).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin v-middle" style="'+ color_outlot_p +'" ><span class="f14">'+ numeral(outappearanceendlot[0].outappearanceendlot).format('0,0') +'</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin v-middle" style="'+ color_outlot_q +'" ><span class="f14">'+ numeral(outclassifyendlot[0].outclassifyendlot).format('0,0') +'</span></td>';
              $("#Outputlot").append(strOutputlot);        


              strResultok = '<td  colspan="2" class=" border-right-thin ">Ok</td>'
                      +'<td  class="f17 text-center border-right-thin " ><span >'+ numeral(diebond_ok).format('0,0') +'</span></td>'
                      +'<td  class="f17 text-center border-right-thin " ><span >'+ numeral(ovendiebond_ok).format('0,0') +'</span></td>'
                      +'<td  class="f17 text-center border-right-thin " ><span>'+  numeral(wirebond_ok).format('0,0') + '</span></td>'
                      +'<td  class="f17 text-center border-right-thin " ><span >'+ numeral(bondingins_ok).format('0,0') +'</span></td>'
                      +'<td  class="f17 text-center border-right-thin " ><span >'+ numeral(mold_ok).format('0,0') +'</span></td>'
                      +'<td  class="f17 text-center border-right-thin " ><span >'+ numeral(ovenmold_ok).format('0,0') +'</span></td>'
                      +'<td  class="f17 text-center border-right-thin " ><span >'+ numeral(dicer_ok).format('0,0') +'</span></td>'
                      +'<td  class="f17 text-center border-right-thin " ><span >'+ numeral(appear_ok).format('0,0') + '</span></td>'
                      +'<td  class="f17 text-center border-right-thin " ><span >'+ numeral(classify_ok).format('0,0') + '</span></td>';
              $("#Resultok").append(strResultok);

              Resultpercen = '<td  colspan="2"  class="border-bottom-thin border-right-thin " >%Ok</td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin " style="'+ a +'"><span >'+ numeral(DiSumResult).format('0,0.00')     +'%</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin " style="'+ b +'"><span >'+ numeral(OieSumResult).format('0,0.00')    +'%</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin " style="'+ c +'"><span >'+ numeral(WieSumResult).format('0,0.00')    +'%</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin " style="'+ d +'"><span >'+ numeral(BondSumResult).format('0,0.00')   +'%</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin " style="'+ e +'"><span >'+ numeral(MoldSumResult).format('0,0.00')   +'%</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin " style="'+ g +'"><span >'+ numeral(OvenmoSumResult).format('0,0.00') +'%</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin " style="'+ f +'"><span >'+ numeral(DicerSumResult).format('0,0.00')  +'%</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin " style="'+ p +'"><span >'+ numeral(AppeaSumResult).format('0,0.00')  +'%</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin " style="'+ q +'"><span >'+ numeral(ClassSumResult).format('0,0.00')  +'%</span></td>';
              $("#Resultpercen").append(Resultpercen);


            
              if(NgSumbonding >= 0.5){var a1 ='backgrouclass="border-bottom-thin border-right-thin "nd-color: red ;color: #FFFF;'}else if( ClassSumResult <100 && ClassSumResult > 0){var a1 ='background-color: red ;color: #FFFF;' }else {var a1 = ""};
              if(NgSumngmold >= 0.5){var b1 ='background-color: red ;color: #FFFF;'}else if( NgSumngmold <100 && NgSumngmold > 0){var b1 ='background-color: red ;color: #FFFF;' }else {var b1 = ""};
              if(NgSumngdicer >= 0.5){var c1 ='background-color: red ;color: #FFFF;'}else if( NgSumngdicer <100 && NgSumngdicer > 0){var c1 ='background-color: red ;color: #FFFF;' }else {var c1 = ""};
              if(NgSumngappear >= 0.5){var d1 ='background-color: red ;color: #FFFF;'}else if( NgSumngappear <100 && NgSumngappear > 0){var d1 ='background-color: red ;color: #FFFF;' }else {var d1 = ""};
              if(NgSumngclassify >= 0.5){var e1 ='background-color: red ;color: #FFFF;'}else if( NgSumngclassify <100 && NgSumngclassify > 0){var e1 ='background-color: red ;color: #FFFF;' }else {var e1 = ""};



              strPng = '<td  colspan="2" class="border-bottom-thin border-right-thin ">%NG</td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin "><span ></span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin "><span ></span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin "><span ></span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin " style="'+ a1 +'"><span >'+ numeral(NgSumbonding).format('0,0.00') +'%</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin " style="'+ b1 +'"><span >'+ numeral(NgSumngmold).format('0,0.00') +'%</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin " ><span ></span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin " style="'+ c1 +'"><span >'+ numeral(NgSumngdicer).format('0,0.00') +'%</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin " style="'+ d1 +'"><span ">'+ numeral(NgSumngappear).format('0,0.00') +'%</span></td>'
                      +'<td class="f17 text-center border-bottom-thin border-right-thin " style="'+ e1 +'"><span>'+ numeral(NgSumngclassify).format('0,0.00') +'%</span></td>';
              $("#Png").append(strPng);
            
              
              $("#DiSumResult").text(DiSumResult);

              
              // ng detail
                if( typeof(t3bonding[0]) != "undefined" ){
                      $("#ant3bonding1").text(t3bonding[0].ng_name);
                      $("#sumant3bonding1").text(numeral((numeral(t3bonding[0].sumqty).value() / numeral(outbondingend2).value()) * 100).format('0,0.00'));
                }else{
                      $("#ant3bonding1").text("");
                      $("#sumant3bonding1").text("0");
                }

                if( typeof(t3bonding[1]) != "undefined" ){
                      $("#ant3bonding2").text(t3bonding[1].ng_name);
                      $("#sumast3bonding2").text(numeral((numeral(t3bonding[1].sumqty).value() / numeral(outbondingend2).value()) * 100).format('0,0.00'));
                }else{
                      $("#ant3bonding2").text("");
                      $("#sumast3bonding2").text("0");                
                }    
          
  
                if( typeof(t3mold[0]) != "undefined" ){
                    $("#ant3mold1").text(t3mold[0].ng_name.substr(0,15));
                    $("#sumant3mold1").text(numeral((numeral(t3mold[0].sumqty).value() / numeral(outmoldend2).value()) * 100).format('0,0.00'));
                }else{
                    $("#ant3mold1").text("");
                    $("#sumant3mold1").text("0");
                }

                if( typeof(t3mold[1]) != "undefined" ){
                    $("#ant3mold2").text(t3mold[1].ng_name.substr(0,15));
                    $("#sumant3mold2").text(numeral((numeral(t3mold[1].sumqty).value() / numeral(outmoldend2).value()) * 100).format('0,0.00'));
                }else{
                    $("#ant3mold2").text("");
                    $("#sumant3mold2").text("0");
                }


                if( typeof(t3dicer[0]) != "undefined" ){
                    $("#ant3dicer1").text(t3dicer[0].ng_name.substr(0,15));
                    $("#sumant3dicer1").text(numeral((numeral(t3dicer[0].sumqty).value() / numeral(outdicer_actend2).value()) * 100).format('0,0.00'));
                }else{
                    $("#ant3dicer1").text("");
                    $("#sumant3dicer1").text("0");
                }

                if( typeof(t3dicer[1]) != "undefined" ){    
                    $("#ant3dicer2").text(t3dicer[1].ng_name.substr(0,15));
                    $("#sumant3dicer2").text(numeral((numeral(t3dicer[1].sumqty).value() / numeral(outdicer_actend2).value()) * 100).format('0,0.00'));
                }else{
                    $("#ant3dicer2").text("");
                    $("#sumant3dicer2").text("0");
                }
              

                if( typeof(t3appea[0]) != "undefined" ){
                    $("#ant3appea1").text(t3appea[0].ng_name.substr(0,15));
                    $("#sumant3appea1").text(numeral((numeral(t3appea[0].sumqty).value() / numeral(outappearanceend2).value()) * 100).format('0,0.00'));
                }else{
                    $("#ant3appea1").text("");
                    $("#sumant3appea1").text("0");
                }

                if( typeof(t3appea[1]) != "undefined" ){
                    $("#ant3appea2").text(t3appea[1].ng_name.substr(0,15));
                    $("#sumant3appea2").text(numeral((numeral(t3appea[1].sumqty).value() / numeral(outappearanceend2).value()) * 100).format('0,0.00'));
                }else{
                    $("#ant3appea2").text("");
                    $("#sumant3appea2").text("0");
                }
              
              
                if( typeof(t3classi[0]) != "undefined" ){
                    $("#ant3classi1").text(t3classi[0].output_name.substr(0,15));
                    $("#sumant3classi1").text(numeral((numeral(t3classi[0].sumng).value() / numeral(outclassifyend2).value()) * 100).format('0,0.00'));
                }else{
                    $("#ant3classi1").text("");
                    $("#sumant3classi1").text("0");
                }
                
                if( typeof(t3classi[1]) != "undefined" ){
                    $("#ant3classi2").text(t3classi[1].output_name.substr(0,15));
                    $("#sumant3classi2").text(numeral((numeral(t3classi[1].sumng).value() / numeral(outclassifyend2).value()) * 100).format('0,0.00'));
                }else{
                    $("#ant3classi2").text("");
                    $("#sumant3classi2").text("0");
                }

            // remark 
                if( typeof(remarkdie) != "undefined" ){
                      $("#remarkdie_a1").text(remarkdie[0].remark);
                }else{
                      $("#remarkdie_a1").text("");
                }

                if( typeof(remarkdie) != "undefined" ){
                      $("#remarkdie_a2").text(remarkdie[1].remark);
                }else{
                      $("#remarkdie_a2").text("");              
                }   

                if( typeof(remarkoven) != "undefined" ){
                      $("#remarkoven_a1").text(remarkoven[0].remark);
                }else{
                      $("#remarkoven_a1").text("");
                }

                if( typeof(remarkoven) != "undefined" ){
                      $("#remarkoven_a2").text(remarkoven[1].remark);
                }else{
                      $("#remarkoven_a2").text("");              
                }

                if( typeof(remarkwirebond) != "undefined" ){
                      $("#remarkwirebond_a1").text(remarkwirebond[0].remark);
                }else{
                      $("#remarkwirebond_a1").text("");
                }

                if( typeof(remarkwirebond) != "undefined" ){
                      $("#remarkwirebond_a2").text(remarkwirebond[1].remark);
                }else{
                      $("#remarkwirebond_a2").text("");              
                }

                if( typeof(remarkmold) != "undefined" ){
                      $("#remarkmold_a1").text(remarkmold[0].remark);
                }else{
                      $("#remarkmold_a1").text("");
                }

                if( typeof(remarkmold) != "undefined" ){
                      $("#remarkmold_a2").text(remarkmold[1].remark);
                }else{
                      $("#remarkmold_a2").text("");              
                }

                if( typeof(remarkovenmold) != "undefined" ){
                      $("#remarkovenmold_a1").text(remarkovenmold[0].remark);
                }else{
                      $("#remarkovenmold_a1").text("");
                }

                if( typeof(remarkovenmold) != "undefined" ){
                      $("#remarkovenmold_a2").text(remarkovenmold[1].remark);
                }else{
                      $("#remarkovenmold_a2").text("");              
                }

                if( typeof(remarkdicer) != "undefined" ){
                      $("#remarkdicer_a1").text(remarkdicer[0].remark);
                }else{
                      $("#remarkdicer_a1").text("");
                }

                if( typeof(remarkdicer) != "undefined" ){
                      $("#remarkdicer_a2").text(remarkdicer[1].remark);
                }else{
                      $("#remarkdicer_a2").text("");              
                }

                if( typeof(remarkclassif) != "undefined" ){
                      $("#remarkclassif_a1").text(remarkclassif[0].remark);
                }else{
                      $("#remarkclassif_a1").text("");
                }

                if( typeof(remarkclassif) != "undefined" ){
                      $("#remarkclassif_a2").text(remarkclassif[1].remark);
                }else{
                      $("#remarkclassif_a2").text("");              
                }
        },
        error:function(err){

        // alert('Error : '+err.responseText);
        }
        });

    }
</script>
@endsection
