package com.tomastc.smartwatchclient.lib;

import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public abstract class WebSocketListenerAbstract extends WebSocketListener {

    protected static final int NORMAL_CLOSURE_STATUS = 1000;

    @Override
    public abstract void onOpen(WebSocket webSocket, Response response);
    @Override
    public abstract void onMessage(WebSocket webSocket, String text);
    @Override
    public abstract void onMessage(WebSocket webSocket, ByteString bytes);
    @Override
    public abstract void onClosing(WebSocket webSocket, int code, String reason);
    @Override
    public abstract void onFailure(WebSocket webSocket, Throwable t, Response response);
}
