package com.tomastc.smartwatchclient.lib;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;

import com.tomastc.smartwatchclient.R;

public class GestureRelativeLayout extends RelativeLayout {
    float x1, x2, y1, y2, dx, dy;
    int direction;
    GestureLayoutAction gestureLayoutAction;

    public GestureRelativeLayout(Context context) {
        super(context);

        init();
    }

    public GestureRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);

        init();
    }

    public GestureRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        init();
    }

    public GestureRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);

        init();
    }

    public void setOnAfterTouch(GestureLayoutAction gestureLayoutAction) {
        this.gestureLayoutAction = gestureLayoutAction;
    }

    private void init() {
        this.setOnTouchListener(new View.OnTouchListener() {
            public boolean onTouch(View v, MotionEvent event) {

                Log.d(GestureRelativeLayout.this.getContext().getString(R.string.tag)
                        , "XXX: " + event.toString());
                switch(event.getAction()) {
                    case(MotionEvent.ACTION_DOWN):
                        x1 = event.getX();
                        y1 = event.getY();
                        break;

                    case(MotionEvent.ACTION_UP): {
                        x2 = event.getX();
                        y2 = event.getY();
                        dx = x2-x1;
                        dy = y2-y1;

                        // Use dx and dy to determine the direction of the move
                        direction = 0; // reset
                        if (dx > 0) {
                            direction |= Direction.RIGHT.getId();
                        } else {
                            direction |= Direction.LEFT.getId();
                        }

                        if (dy > 0) {
                            direction |= Direction.DOWN.getId();
                        } else {
                            direction |= Direction.UP.getId();
                        }

                        gestureLayoutAction.onAfterTouch(direction);

                    }
                }

                return true;
            }
        });
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {


        return super.onTouchEvent(event);
    }

    public enum Direction {
        LEFT(1),
        RIGHT(2),
        UP(4),
        DOWN(8);
        private final int id;

        Direction(final int id) {
            this.id = id;
        }

        public int getId() {
            return id;
        }

        public static GestureRelativeLayout.Direction fromId(final int id) {
            for (GestureRelativeLayout.Direction e : GestureRelativeLayout.Direction.values()) {
                if (e.id == id) {
                    return e;
                }
            }
            return null;
        }
    }
}
