package com.tomastc.smartwatchclient;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.BatteryManager;
import android.view.View;
import android.widget.TextView;

public class DeviceInfoDisplay extends BroadcastReceiver {

    Context context;
    Activity activity;
    private TextView txt_battery, txt_wifi, txt_bluetooth, txt_websocket_status;

    public DeviceInfoDisplay(Context context, Activity activity) {
        this.context = context;
        this.activity = activity;
        initCalendar(context, activity);
    }

    private void initCalendar(Context context, Activity activity) {
        Resources r = context.getResources();
        txt_battery = (TextView) activity.findViewById(R.id.txt_battery_pct);
        txt_wifi = (TextView) activity.findViewById(R.id.txt_wifi_status);
        txt_bluetooth = (TextView) activity.findViewById(R.id.txt_bluetooth_status);
        txt_websocket_status = (TextView) activity.findViewById(R.id.txt_websocket_status);
    }

    public void updateIcons() {
        String drawable_name, bluetooth_drawable_name;
        Drawable img;

        // Update wifi icon
        ConnectivityManager connManager = (ConnectivityManager) activity.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo mWifi = connManager.getNetworkInfo(ConnectivityManager.TYPE_WIFI);
        txt_wifi.setVisibility(mWifi.isConnected() ? View.VISIBLE : View.GONE);

        // Update bluetooth icon
        BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        txt_bluetooth.setVisibility(mBluetoothAdapter == null || !mBluetoothAdapter.isEnabled()
                ? View.GONE : View.VISIBLE);

        // Update web socket connection icon
        if (MainActivity.smartwatchClient == null
                || !MainActivity.smartwatchClient.isConnected()) {
            drawable_name = "ic_baseline_cloud_off_12";
            bluetooth_drawable_name = "ic_baseline_bluetooth_12";
        } else {
            drawable_name = "ic_baseline_cloud_12";
            bluetooth_drawable_name = mWifi.isConnected()
                    ? "ic_baseline_bluetooth_12" : "ic_baseline_bluetooth_connected_12";
        }
        img = context.getResources().getDrawable(
                context.getResources().getIdentifier(
                        drawable_name
                        , "drawable", context.getPackageName()
                )
        );
        img.setBounds(0, 0, 18, 18);
        txt_websocket_status.setCompoundDrawables(img, null, null, null);


        img = context.getResources().getDrawable(
                context.getResources().getIdentifier(
                        bluetooth_drawable_name
                        , "drawable", context.getPackageName()
                )
        );
        img.setBounds(0, 0, 18, 18);
        txt_bluetooth.setCompoundDrawables(img, null, null, null);
    }

    @Override
    public void onReceive(Context ctxt, Intent intent) {
        int level = intent.getIntExtra(BatteryManager.EXTRA_LEVEL, -1);
        int scale = intent.getIntExtra(BatteryManager.EXTRA_SCALE, -1);

        Intent batteryStatus = context.registerReceiver(null,
                new IntentFilter(intent.ACTION_BATTERY_CHANGED));
        int status = batteryStatus.getIntExtra(BatteryManager.EXTRA_STATUS, -1);
        boolean isCharging = status == BatteryManager.BATTERY_STATUS_CHARGING ||
                status == BatteryManager.BATTERY_STATUS_FULL;
        float batteryPct = level * 100 / (float)scale;
        txt_battery.setText(String.valueOf(batteryPct) + "%");

        // Set battery icon
        String drawable_name;
        if (isCharging) {
            drawable_name = "ic_baseline_battery_charging_full_12";
        } else {
            if (batteryPct > 98) {
                drawable_name = "ic_baseline_battery_full_12";
            } else {
                drawable_name = String.format("ic_baseline_battery_%d_bar_12",
                        (int) (batteryPct * 7 / 100));
            }
        }
        Drawable img = context.getResources().getDrawable(
                context.getResources().getIdentifier(
                        drawable_name
                        , "drawable", context.getPackageName()
                )
        );
        img.setBounds(0, 0, 18, 18);
        txt_battery.setCompoundDrawables(img, null, null, null);

        // Update wifi icon
        updateIcons();
    }
}
