package com.tomastc.smartwatchclient.lib;

public enum KeyMapping {
    P1(131),
    P2(132),
    P3(133),
    P4(134),
    ENT(66);
    private final int id;

    KeyMapping(final int id) {
        this.id = id;
    }

    public int getId() {
        return id;
    }

    public static KeyMapping fromId(final int id) {
        for (KeyMapping e : KeyMapping.values()) {
            if (e.id == id) {
                return e;
            }
        }
        return null;
    }
}
