package com.tomastc.smartwatchclient.lib;

public class CompletionInput {

    private String ws_cd;
    private String item_no;
    private String slip_cd;
    private String doc_no;
    private String ok_qty;
    private String ng_qty;
    private String doc_status;
    private String jon_tbl_flag;
    private String upd_pgm;
    private String upd_user_id;
    private String re_prt_flag;

    public CompletionInput(String ws_cd, String item_no, String slip_cd, String doc_no,
                           String ok_qty, String ng_qty, String doc_status, String jon_tbl_flag,
                           String upd_pgm, String upd_user_id, String re_prt_flag) {
        this.ws_cd = ws_cd;
        this.item_no = item_no;
        this.slip_cd = slip_cd;
        this.doc_no = doc_no;
        this.ok_qty = ok_qty;
        this.ng_qty = ng_qty;
        this.doc_status = doc_status;
        this.jon_tbl_flag = jon_tbl_flag;
        this.upd_pgm = upd_pgm;
        this.upd_user_id = upd_user_id;
        this.re_prt_flag = re_prt_flag;
    }

    public enum Status {
        OK(0),
        CANCEL(1);
        private final int id;

        Status(final int id) {
            this.id = id;
        }

        public int getId() {
            return id;
        }

        public static Status fromId(final int id) {
            for (Status e : Status.values()) {
                if (e.id == id) {
                    return e;
                }
            }
            return null;
        }
    }

    public enum JoinTableFlag {
        NEW(9),
        SCAN(0);
        private final int id;

        JoinTableFlag(final int id) {
            this.id = id;
        }

        public int getId() {
            return id;
        }

        public static JoinTableFlag fromId(final int id) {
            for (JoinTableFlag e : JoinTableFlag.values()) {
                if (e.id == id) {
                    return e;
                }
            }
            return null;
        }
    }

    public enum ReprintFlag {
        NO(0),
        YES(1);
        private final int id;

        ReprintFlag(final int id) {
            this.id = id;
        }

        public int getId() {
            return id;
        }

        public static ReprintFlag fromId(final int id) {
            for (ReprintFlag e : ReprintFlag.values()) {
                if (e.id == id) {
                    return e;
                }
            }
            return null;
        }
    }

    public String getWs_cd() {
        return ws_cd;
    }

    public void setWs_cd(String ws_cd) {
        this.ws_cd = ws_cd;
    }

    public String getItem_no() {
        return item_no;
    }

    public void setItem_no(String item_no) {
        this.item_no = item_no;
    }

    public String getSlip_cd() {
        return slip_cd;
    }

    public void setSlip_cd(String slip_cd) {
        this.slip_cd = slip_cd;
    }

    public String getDoc_no() {
        return doc_no;
    }

    public void setDoc_no(String doc_no) {
        this.doc_no = doc_no;
    }

    public String getOk_qty() {
        return ok_qty;
    }

    public void setOk_qty(String ok_qty) {
        this.ok_qty = ok_qty;
    }

    public String getNg_qty() {
        return ng_qty;
    }

    public void setNg_qty(String ng_qty) {
        this.ng_qty = ng_qty;
    }

    public String getDoc_status() {
        return doc_status;
    }

    public void setDoc_status(String doc_status) {
        this.doc_status = doc_status;
    }

    public String getJon_tbl_flag() {
        return jon_tbl_flag;
    }

    public void setJon_tbl_flag(String jon_tbl_flag) {
        this.jon_tbl_flag = jon_tbl_flag;
    }

    public String getUpd_pgm() {
        return upd_pgm;
    }

    public void setUpd_pgm(String upd_pgm) {
        this.upd_pgm = upd_pgm;
    }

    public String getUpd_user_id() {
        return upd_user_id;
    }

    public void setUpd_user_id(String upd_user_id) {
        this.upd_user_id = upd_user_id;
    }

    public String getRe_prt_flag() {
        return re_prt_flag;
    }

    public void setRe_prt_flag(String re_prt_flag) {
        this.re_prt_flag = re_prt_flag;
    }
}
