package com.tomastc.smartwatchclient;

import org.json.JSONException;
import org.json.JSONObject;

public class SmartwatchProtocol {
    public static String encapsulation(String cmd, JSONObject ext) {
        String tmp = "";
        try {
            JSONObject json = new JSONObject();
            json.put("cmd", cmd);
            if (ext != null) {
                json.put("ext", ext);
            }

            tmp = json.toString();
        } catch (JSONException e) {
            e.printStackTrace();
        }

        return tmp;
    }

    public enum COMMAND {

        HELLO,
        REGISTER_REQUEST,
        REGISTER_ACK,
        ACCEPT_REQUEST,
        ACCEPT_ACK,
        ACCEPTED_NOTIFY,
        ACCEPTED_NOTIFY_ACK,
        JOIN_REQUEST,
        JOIN_ACK,
        START_ACK,
        FINISH_ACK,
        JOIN_START_ACK,
        JOIN_FINISH_ACK,
        RESET_REQUEST,
        RESET_ACK,
        ACCEPT_YES,
        ACCEPT_NO,
        JOIN_YES,
        JOIN_NO,
        START_REQUEST,
        FINISH_REQUEST,
        JOIN_START_REQUEST,
        JOIN_FINISH_REQUEST,
        PING,
        PONG,
        TERM_REQUEST,
        TERM_ACK,
        HEART_RATE_TRACKING_REQUEST,
        STEP_COUNT_TRACKING_REQUEST,
        ST_OVER_REQUEST,
        ST_OVER_ACK
    }
}


