package com.tomastc.smartwatchclient;

import android.content.Context;
import android.util.Log;

import com.tomastc.smartwatchclient.lib.common.CallbackListener;
import com.tomastc.smartwatchclient.lib.common.MessageListener;

import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;

public class  SmartwatchClient {

    private static Context context;
    private String url;

    private static Request request;
    private static SmartwatchClientListener smartwatchClientListener;
    public static WebSocket ws;
    private static OkHttpClient client;

    public static int client_id;

    public static CallbackListener callbackListener;
    public static MessageListener messageListener;

    public static STATUS status;
    public enum STATUS {
        IDLE,
        ACCEPT_ACK,
        ACCEPTED,
        JOIN_ACK,
        JOINED,
        WORKING
    }

    // Singleton class
    private static SmartwatchClient smartwatchClient = null;

    // prevent default constructor call
    private SmartwatchClient() {}

    private SmartwatchClient(CallbackListener callbackListener, MessageListener messageListener, Context context, String url) {
        this.callbackListener = callbackListener;
        this.messageListener = messageListener;
        this.context = context;
        this.url = url;

        this.client = new OkHttpClient();
    }

    public static final SmartwatchClient getInstance() {
        return smartwatchClient;
    }

    public void setOnMessageListener(MessageListener messageListener) {
        Log.d(context.getString(R.string.tag), "setOnMessageListener to " + messageListener.getClass());
        this.messageListener = messageListener;
    }

    public static final SmartwatchClient getInstance(CallbackListener callbackListener, MessageListener messageListener, Context context, String url) {
        if (smartwatchClient == null) {
            smartwatchClient = new SmartwatchClient(callbackListener, messageListener, context, url);
        }

        // start listener server
        smartwatchClient.connect();

        return smartwatchClient;
    }

    public void connect() {
        if (ws == null) {
            Log.d(context.getString(R.string.tag), "Web socket connect to " + url);
            request = new Request.Builder()
                    .url(url)
                    .build();
            smartwatchClientListener = new SmartwatchClientListener(this.context);
            ws = client.newWebSocket(request, smartwatchClientListener);

            // update info icons
            callbackListener.onFinished("connected");
        }
    }

    public void disconnect() {

        if(ws == null){ return; }

        ws.close(1000, "{\"reason\": \"With love\"}");
        ws= null;

        //client.dispatcher().executorService().shutdown();
        //client.connectionPool().evictAll();

        smartwatchClientListener = null;
    }

    public boolean isConnected() {
        return ws!=null;
    }

    public void sendMessage(String str) throws Exception {
        if (!isConnected()) throw new Exception("The server might crash");

        Log.d(context.getString(R.string.tag), "Send message : " + str);

        ws.send(str);
    }

}
