package com.tomastc.smartwatchclient.lib.common;


import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;

public class MyAlertDialog {

    public MyAlertDialog(Context context, String title, String message, DialogInterface.OnClickListener ok_action) {

        AlertDialog dialog = new AlertDialog.Builder(context).create();
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setButton(AlertDialog.BUTTON_NEUTRAL, "OK", ok_action);
        dialog.show();
    }

    public MyAlertDialog(Context context, String title, String message,
                         DialogInterface.OnClickListener ok_action, DialogInterface.OnClickListener cancel_action) {

        AlertDialog.Builder dialog = new AlertDialog.Builder(context);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setPositiveButton("OK",ok_action);
        dialog.setNegativeButton(android.R.string.cancel, cancel_action);
        dialog.create().show();
    }
}
