package com.tomastc.smartwatchclient.lib.common;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.InputType;
import android.widget.EditText;

public abstract class InputBoxDialog {

    AlertDialog.Builder builder;
    abstract protected void onPositiveClick(DialogInterface dialog, int which, String msg);
    abstract protected void onNegativeClick(DialogInterface dialog, int which, String msg);

    /**
     * Input box dialog constructor
     * @param context
     * @param title
     * @param type InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_PASSWORD
     */
    public InputBoxDialog(Context context, String title, int type, String msg) {
        builder = new AlertDialog.Builder(context);
        builder.setTitle(title);

        // Set up the input
        final EditText input = new EditText(context);
        // Specify the type of input expected; this, for example, sets the input as a password, and will mask the text
        input.setInputType(type);
        input.setText(msg);
        builder.setView(input);

        // Set up the buttons
        builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                onPositiveClick(dialog, which, input.getText().toString());
            }
        });
        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
                onNegativeClick(dialog, which, input.getText().toString());
            }
        });

    }

    public void show() {
        builder.show();
    }


}


