package com.tomastc.smartwatchclient;

import static com.tomastc.smartwatchclient.SmartwatchClient.STATUS.ACCEPT_ACK;
import static com.tomastc.smartwatchclient.SmartwatchClient.STATUS.IDLE;
import static com.tomastc.smartwatchclient.SmartwatchProtocol.COMMAND.ACCEPT_NO;
import static com.tomastc.smartwatchclient.SmartwatchProtocol.COMMAND.ACCEPT_YES;
import static com.tomastc.smartwatchclient.SmartwatchProtocol.COMMAND.FINISH_REQUEST;
import static com.tomastc.smartwatchclient.SmartwatchProtocol.COMMAND.PONG;
import static com.tomastc.smartwatchclient.SmartwatchProtocol.COMMAND.RESET_ACK;
import static com.tomastc.smartwatchclient.SmartwatchProtocol.COMMAND.RESET_REQUEST;
import static com.tomastc.smartwatchclient.SmartwatchProtocol.COMMAND.START_ACK;
import static com.tomastc.smartwatchclient.SmartwatchProtocol.COMMAND.START_REQUEST;
import static com.tomastc.smartwatchclient.SmartwatchProtocol.COMMAND.ST_OVER_REQUEST;
import static com.tomastc.smartwatchclient.SmartwatchProtocol.COMMAND.TERM_ACK;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.speech.RecognitionListener;
import android.speech.RecognizerIntent;
import android.speech.SpeechRecognizer;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextClock;
import android.widget.TextView;
import android.widget.Toast;

import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.wear.widget.BoxInsetLayout;

import com.tomastc.smartwatchclient.lib.Settings;
import com.tomastc.smartwatchclient.lib.common.MessageListener;
import com.tomastc.smartwatchclient.lib.common.Utils;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;

import okhttp3.WebSocket;

public class AcceptRequestActivity extends Activity implements MessageListener, SensorEventListener {

    private Button  btn_finish, btn_finish_yes, btn_finish_no,btn_yes, btn_no; //btn_start,
    private TextView txt_main_title, txt_title, txt_sub_title, txt_device_id,txt_count_time;// txt_description,txt_time_job ;
    public DeviceInfoDisplay infoDisplay;

     private LinearLayout layout_confirm_finish, layout_accept_job;
     private BoxInsetLayout layout_bg;

    private String ext_params, run_timer;

    private SensorManager sensorManager;
    private Sensor stepSensor, heartRateSensor;
    private SensorEventListener sensorEventListener;

    private JSONObject jext_parm;
    private SpeechRecognizer speechRecognizer;
    private Intent speechRecognizerIntent ;


    // Number of seconds displayed
    // on the stopwatch.
    private int seconds = 0, wait_time = 0, working_time = 0, waiting_time = 0;

    // Is the stopwatch running?
    private boolean running;

    private boolean wasRunning;
    Vibrator vibrator;
    private  TextClock textClock;

    private void sendTransactionCommand(SmartwatchProtocol.COMMAND $command, HashMap others) {
        try {
            JSONObject json = new JSONObject(ext_params);
            json.put("user_id", Settings.getPresettingsObject().getString("user_id"));
            json.put("dev_id", Settings.getPresettingsObject().getString("dev_id"));
            json.put("dev_group", Settings.getPresettingsObject().getString("dev_group"));
            json.put("extra_parms", Settings.getPresettingsObject().getString("ext_parm"));
            json.put("mac_address", Settings.getPresettingsObject().getString("mac_addr"));
            if (others != null && others.size() > 0) {
                for ( String key : (Set<String>) others.keySet() ) {
                   json.put(key, others.get(key));
                }
            }

            SmartwatchClient.getInstance().sendMessage(
                    SmartwatchProtocol.encapsulation(
                            $command.toString(),
                            json
                    )
            );
        } catch (Exception e) {
            Log.e(getString(R.string.tag), "Error caught! " + e.getMessage());
            running = false;
            finish();
        }
    }


    private void sendTransactionCommand(SmartwatchProtocol.COMMAND $command) {
        sendTransactionCommand($command, null);
    }

    private void Vibrator_Effect() {
        if (Build.VERSION.SDK_INT >= 26) {
            ((Vibrator) getSystemService(VIBRATOR_SERVICE)).vibrate(VibrationEffect.createOneShot(5000, VibrationEffect.EFFECT_TICK));
            Log.e(getString(R.string.tag), "Error caught if! ");
        } else {
            ((Vibrator) getSystemService(VIBRATOR_SERVICE)).vibrate(5000);
            Log.e(getString(R.string.tag), "Error caught else! ");
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_accept_request);

        Utils.playMedia(getApplicationContext(), R.raw.ship_siren);
        Vibrator_Effect();

        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);

        // update MessageListener class
        SmartwatchClient.getInstance().setOnMessageListener(this);


        // update info bar
        this.infoDisplay = new DeviceInfoDisplay(getApplicationContext(), this);
        try {
            registerReceiver(this.infoDisplay, new IntentFilter(Intent.ACTION_BATTERY_CHANGED));
        } catch (Exception e) {
            Log.e(getString(R.string.tag), "Error caught! " + e.getMessage());
        }

        layout_bg = (BoxInsetLayout)findViewById(R.id.layout_bg);

        textClock = (TextClock) findViewById(R.id.txt_clock);
        textClock.setFormat24Hour("HH:mm:ss");

        txt_main_title = (TextView)findViewById(R.id.txt_main_title);
        txt_title = (TextView)findViewById(R.id.txt_title);
        txt_sub_title = (TextView)findViewById(R.id.txt_sub_title);
        txt_count_time = (TextView)findViewById(R.id.txt_count_time);
        txt_device_id = (TextView)findViewById(R.id.txt_device_id);
//        btn_start = (Button)findViewById(R.id.btn_start);
        btn_yes = (Button)findViewById(R.id.btn_yes);
        btn_no = (Button)findViewById(R.id.btn_no);
        btn_finish = (Button)findViewById(R.id.btn_finish);

        layout_confirm_finish = (LinearLayout)findViewById(R.id.layout_confirm_finish);
        layout_accept_job = (LinearLayout)findViewById(R.id.layout_accept_job);
        btn_finish_yes = (Button)findViewById(R.id.btn_finish_yes);
        btn_finish_no = (Button)findViewById(R.id.btn_finish_no);

        sensorManager = (SensorManager) getSystemService(SENSOR_SERVICE);
        try {
            String ext_parm = Settings.getPresettingsObject().getString("ext_parm");
            jext_parm = new JSONObject(ext_parm);
            if (jext_parm.has("step_count")) {
                if (jext_parm.getInt("step_count") == 1) {
                    stepSensor = sensorManager.getDefaultSensor(Sensor.TYPE_STEP_COUNTER);
                    sensorManager.registerListener(this, stepSensor, SensorManager.SENSOR_DELAY_NORMAL);
                }
                if (jext_parm.getInt("heart_rate") == 1) {
                    heartRateSensor = sensorManager.getDefaultSensor(Sensor.TYPE_HEART_RATE);
                    sensorManager.registerListener(this, heartRateSensor, SensorManager.SENSOR_DELAY_NORMAL);
                }
            }

            if (jext_parm.has("waiting_time")) {
                waiting_time = jext_parm.getInt("waiting_time");
            }
            Log.d(getString(R.string.tag), "waiting_time: " + waiting_time);

        } catch (Exception e) {
            Log.e(getString(R.string.tag), "Exception caught: " + e.getMessage());
        }



        ext_params = getIntent().getExtras().getString("ext");
        try {
            JSONObject j_ext = new JSONObject(ext_params);
            txt_title.setText(j_ext.getString("title"));
            txt_sub_title.setText(j_ext.getString("sub_title"));

            txt_device_id.setText(Settings.getPresettingsObject().getString("dev_id"));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (savedInstanceState != null) {

            // Get the previous state of the stopwatch
            // if the activity has been
            // destroyed and recreated.
            seconds
                    = savedInstanceState
                    .getInt("seconds");
            running
                    = savedInstanceState
                    .getBoolean("running");
            wasRunning
                    = savedInstanceState
                    .getBoolean("wasRunning");
        }


        //count wait time
        seconds = 0;
        running = true;
        Run_Timer();

      // btn_start.setVisibility(View.VISIBLE);
        txt_main_title.setText("Start");
        layout_accept_job.setVisibility(View.VISIBLE);
        Log.d(getString(R.string.tag), "status : "+SmartwatchClient.getInstance().status);

        // Event
//        btn_start.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                Log.d(getString(R.string.tag), "perform click => btn_start");
//                sendTransactionCommand(START_REQUEST);
//
//            }
//        });
        btn_yes.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Log.d(getString(R.string.tag), "perform click => btn_yes");
                SmartwatchClient.getInstance().status = SmartwatchClient.STATUS.ACCEPTED;
                sendTransactionCommand(ACCEPT_YES);

            }
        });

        btn_no.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Log.d(getString(R.string.tag), "perform click => btn_no");
                sendTransactionCommand(ACCEPT_NO);

                // set MainActivity to handle message
                SmartwatchClient.getInstance().setOnMessageListener(MainActivity.instance);
                running = false;
                finish();
            }
        });

        // Event
        btn_finish.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Log.d(getString(R.string.tag), "perform click => btn_finish");
                // Set behavior text and button
                txt_main_title.setText("Finished?");
                btn_finish.setVisibility(View.INVISIBLE);
                layout_confirm_finish.setVisibility(View.VISIBLE);

                //default color bg
                layout_bg.setBackgroundResource(R.color.black);
                txt_count_time.setTextColor(Color.RED);

            }
        });

        // Event
        btn_finish_yes.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Log.d(getString(R.string.tag), "perform click => btn_finish_yes");
                sendTransactionCommand(FINISH_REQUEST);

                // Stop the stop watch timer
                running = false;
                working_time = seconds;
                Log.d(getString(R.string.tag), "working_time = "+working_time);

                SmartwatchClient.getInstance().status = IDLE;

                SmartwatchClient.getInstance().setOnMessageListener(MainActivity.instance);
                finish();
            }
        });

        // Event
        btn_finish_no.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Log.d(getString(R.string.tag), "perform click => btn_finish_no");
                // Set behavior text and button
                txt_main_title.setText("Working");
                layout_confirm_finish.setVisibility(View.GONE);
                btn_finish.setVisibility(View.VISIBLE);

                // Enable voice command
//                startSpeechToText();
            }
        });

        /**
         * Version 1.6.0: Add supported for voice recognize command
         */
//        checkAudioPermission();
        // Enable voice command
//        startSpeechToText();
    }


    @Override
    protected void onDestroy() {

        Log.d(getString(R.string.tag),
                "onDestroy(): SmartwatchClient status: " + SmartwatchClient.getInstance().status);


        if (SmartwatchClient.getInstance().status == SmartwatchClient.STATUS.ACCEPT_ACK
                || SmartwatchClient.getInstance().status == SmartwatchClient.STATUS.ACCEPTED
                || SmartwatchClient.getInstance().status == SmartwatchClient.STATUS.WORKING) {
            // In case of silent mode, it wouldn't go back to MainActivity.
            SmartwatchClient.getInstance().status = IDLE;
            sendTransactionCommand(RESET_REQUEST);

            // Set Message handle to MainActivity
            SmartwatchClient.getInstance().setOnMessageListener(MainActivity.instance);
        }



        super.onDestroy();
        sensorManager.unregisterListener(this);

        if (this.infoDisplay != null) {
            try {
                this.unregisterReceiver(this.infoDisplay);
            } catch (Exception e) {
                Log.e(getString(R.string.tag), "Error caught! " + e.getMessage());
            }
        }

        if (speechRecognizer != null) {
            speechRecognizer.destroy();
        }
    }

    /**
     * Version 1.6.0: Add supported voice recognize command
     */
    private void checkAudioPermission() {
        try {
            if (jext_parm.getInt("voice_command") != 1) return;

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {  // M = 23
                if (ContextCompat.checkSelfPermission(this, "android.permission.RECORD_AUDIO") != PackageManager.PERMISSION_GRANTED) {
                    Intent intent = new Intent(android.provider.Settings.ACTION_APPLICATION_DETAILS_SETTINGS,
                            Uri.parse("package:com.programmingtech.offlinespeechtotext"));
                    startActivity(intent);
                    Toast.makeText(this, "Allow Microphone Permission", Toast.LENGTH_SHORT).show();
                }
            }
        } catch (Exception e) {
            Log.e(getString(R.string.tag), e.getMessage());
        }
    }
//    private void startSpeechToText() {
//        try {
//            if (jext_parm.getInt("voice_command") != 1) return;
//
//            if (speechRecognizer == null) {
//                speechRecognizer = SpeechRecognizer.createSpeechRecognizer(this);
//                speechRecognizerIntent = new Intent(RecognizerIntent.ACTION_RECOGNIZE_SPEECH);
//                speechRecognizerIntent.putExtra(
//                        RecognizerIntent.EXTRA_LANGUAGE_MODEL,
//                        RecognizerIntent.LANGUAGE_MODEL_FREE_FORM
//                );
//                speechRecognizerIntent.putExtra(RecognizerIntent.EXTRA_LANGUAGE, Locale.getDefault());
//
//                speechRecognizer.setRecognitionListener(new RecognitionListener() {
//                    public void onReadyForSpeech(Bundle bundle) {}
//
//                    @Override
//                    public void onBeginningOfSpeech() {
//
//                    }
//
//                    @Override
//                    public void onRmsChanged(float v) {
//
//                    }
//
//                    @Override
//                    public void onBufferReceived(byte[] bytes) {
//
//                    }
//
//                    @Override
//                    public void onEndOfSpeech() {
//
//                    }
//
//                    @Override
//                    public void onError(int error) {
//                        if ((error == SpeechRecognizer.ERROR_NO_MATCH)
//                                || (error == SpeechRecognizer.ERROR_SPEECH_TIMEOUT)){
//
//                        }
//                        else if(error == SpeechRecognizer.ERROR_RECOGNIZER_BUSY){
//
//                        }
//
////                        startSpeechToText();
//                    }
//
//                    @Override
//                    public void onResults(Bundle bundle) {
//                        ArrayList<String> matches = bundle.getStringArrayList(SpeechRecognizer.RESULTS_RECOGNITION);
//                        String tmp = matches.stream().map(Object::toString)
//                                .collect(Collectors.joining(", "));
//                        Log.d(getString(R.string.tag), tmp);
//                        Log.d(getString(R.string.tag), SmartwatchClient.getInstance().status.toString());
//
//                        switch (SmartwatchClient.getInstance().status) {
//                            case ACCEPTED:
////                                layout_bg.setBackgroundResource(R.color.black);
////                                txt_count_time.setTextColor(Color.RED);
////                                ;
//                                if (tmp.contains("start")) {
//                                    btn_start.performClick();
//                                } else { // no matched
//                                    startSpeechToText();
//                                }
//                                break;
//                            case WORKING:
//                                if (btn_finish.getVisibility() == View.VISIBLE) {
//                                    if (tmp.contains("fin") || tmp.contains("end")) {
//                                        btn_finish.performClick();
//                                    } else { // no matched
//                                        startSpeechToText();
//                                    }
//                                } else {
//                                    if (tmp.contains("yes") || tmp.contains("yeah")) {
//                                        btn_finish_yes.performClick();
//                                    } else if (tmp.contains("no")) {
//                                        btn_finish_no.performClick();
//                                    } else { // no matched
//                                        startSpeechToText();
//                                    }
//                                }
//                                break;
//                        }
//
//                        speechRecognizer.cancel();
//                    }
//
//                    @Override
//                    public void onPartialResults(Bundle bundle) {
//
//                    }
//
//                    @Override
//                    public void onEvent(int i, Bundle bundle) {
//
//                    }
//                });
//
//            }
//
//            // starts listening ...
//            speechRecognizer.startListening(speechRecognizerIntent);
//        } catch (Exception e) {
//            Log.e(getString(R.string.tag), e.getMessage());
//        }
//    }

    @Override
    public void onMessage(WebSocket webSocket, String text) {
        Log.d(getString(R.string.tag), String.format("%s : received -> \"%s\"", this.getLocalClassName(),
                text));

        runOnUiThread(new Runnable() {

            @Override
            public void run() {

                try {
                    JSONObject jsonObject = new JSONObject(text);

                    switch (SmartwatchProtocol.COMMAND.valueOf(jsonObject.getString("cmd"))) {
                        case HELLO:
                            SmartwatchClient.getInstance().status = IDLE;

                            SmartwatchClient.getInstance().setOnMessageListener(MainActivity.instance);
                            running = false;
                            finish();
                            break;
                        case ACCEPT_REQUEST:
                        case JOIN_REQUEST:
                        case ACCEPT_ACK:
                            sendTransactionCommand(START_REQUEST);

                            break;
                        case ST_OVER_ACK:
                            break;

                        case START_ACK:
                            layout_bg.setBackgroundResource(R.color.black);
                            txt_count_time.setTextColor(Color.RED);
                            //reset bg color
                            btn_yes.setBackgroundResource(R.color.green);
                            btn_yes.setTextColor(Color.WHITE);
                            btn_no.setBackgroundResource(R.color.red);
                            btn_no.setTextColor(Color.WHITE);

                            SmartwatchClient.getInstance().status = SmartwatchClient.STATUS.WORKING;

                            // Set behavior text and button
                            txt_main_title.setText("Working");
//                            btn_start.setVisibility(View.GONE);
                            layout_accept_job.setVisibility(View.GONE);
                            btn_finish.setVisibility(View.VISIBLE);

                            wait_time = seconds; //get count wait_time;
                            Log.d(getString(R.string.tag), "wait_time = "+wait_time);

                            // start that stop watch timer
                            seconds = 0;
                            running = true;
                            break;

                        case FINISH_ACK:
                            running = false;
                            SmartwatchClient.getInstance().status = IDLE;

                            SmartwatchClient.getInstance().setOnMessageListener(MainActivity.instance);
                            running = false;
                            finish();

                            break;

                        case RESET_REQUEST:
                            SmartwatchClient.getInstance().status = IDLE;

                            sendTransactionCommand(RESET_ACK);

                            SmartwatchClient.getInstance().setOnMessageListener(MainActivity.instance);
                            running = false;
                            finish();
                            break;

                        case PING:
                            SmartwatchClient.getInstance().sendMessage(
                                    SmartwatchProtocol.encapsulation(
                                            PONG.toString(),
                                            null
                                    )
                            );
                            break;

                        case TERM_REQUEST:
                            sendTransactionCommand(TERM_ACK);
                            SmartwatchClient.getInstance().status = IDLE;
                            Utils.vibrate(AcceptRequestActivity.this, Utils.VIBRATE_PATTERN2 );
                            vibrator.vibrate(3000);

                            Toast.makeText(AcceptRequestActivity.this, "Job has been terminated!", Toast.LENGTH_LONG).show();
                            SmartwatchClient.getInstance().setOnMessageListener(MainActivity.instance);
                            running = false;
                            finish();

                            break;
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        });
    }

    @Override
    public void onSensorChanged(SensorEvent event) {

        if (
            SmartwatchClient.getInstance().status != SmartwatchClient.STATUS.ACCEPTED
            && SmartwatchClient.getInstance().status != SmartwatchClient.STATUS.WORKING
        )
            return;

        String msg;
        switch (event.sensor.getType()) {
            case Sensor.TYPE_HEART_RATE:
                msg = "Heart Rate : " + (int)event.values[0];
                Log.d(getString(R.string.tag), msg);
                sendTransactionCommand(SmartwatchProtocol.COMMAND.HEART_RATE_TRACKING_REQUEST, new HashMap<String, String>(){{
                    put("value", String.valueOf(event.values[0]));
                    put("status", SmartwatchClient.getInstance().status.toString());
                }});
                break;

            case Sensor.TYPE_STEP_COUNTER:
                msg = "Step Count : " + (int)event.values[0];
                Log.d(getString(R.string.tag), msg);
                sendTransactionCommand(SmartwatchProtocol.COMMAND.STEP_COUNT_TRACKING_REQUEST, new HashMap<String, String>(){{
                    put("value", String.valueOf(event.values[0]));
                    put("status", SmartwatchClient.getInstance().status.toString());
                }});
                break;

            default:
                Log.d(getString(R.string.tag), "Unsupported sensor type");

        }
    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int i) {

    }


    // Save the state of the stopwatch
    // if it's about to be destroyed.
    @Override
    public void onSaveInstanceState(
            Bundle savedInstanceState)
    {
        savedInstanceState
                .putInt("seconds", seconds);
        savedInstanceState
                .putBoolean("running", running);
        savedInstanceState
                .putBoolean("wasRunning", wasRunning);
    }

    // If the activity is paused,
    // stop the stopwatch.
    @Override
    protected void onPause()
    {
        super.onPause();
        wasRunning = running;
//        running = false;
    }

    // If the activity is resumed,
    // start the stopwatch
    // again if it was running previously.
    @Override
    protected void onResume()
    {
        super.onResume();
        if (wasRunning) {
            running = true;
//            Run_Timer();
        }
    }

    public void Run_Timer(){
        Timer timers = new Timer();
        TimerTask time_task = new TimerTask() {
            @Override
            public void run() {//   run จับเวลา
                if (!running){
                    timers.cancel();
                }
                seconds++;
                Date d = new Date(seconds * 1000L);
                SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss"); // HH for 0-23
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                run_timer = df.format(d);
                txt_count_time.setText(String.valueOf(run_timer));

                if(seconds == waiting_time){
                    if ( SmartwatchClient.getInstance().status == ACCEPT_ACK){
                        Utils.playMedia(getApplicationContext(), R.raw.ship_siren);
                        Vibrator_Effect();
                        Log.d(getString(R.string.tag), "Over waiting_time");
                        layout_bg.setBackgroundResource(R.color.red);
                        txt_count_time.setTextColor(Color.YELLOW);
//                        btn_start.setBackgroundResource(R.color.yellow);
//                        btn_start.setTextColor(Color.BLACK);
                        btn_yes.setBackgroundResource(R.color.yellow);
                        btn_yes.setTextColor(Color.BLACK);
                        btn_no.setBackgroundResource(R.color.yellow);
                        btn_no.setTextColor(Color.BLACK);

                        sendTransactionCommand(ST_OVER_REQUEST);
                    }
                }

                Log.d(getString(R.string.tag), "sec_count: " + String.valueOf(run_timer));

            }
        };
        timers.scheduleAtFixedRate(time_task,1000,1000);

    }


    // Sets the NUmber of seconds on the timer.
    // The runTimer() method uses a Handler
    // to increment the seconds and
    // update the text view.
//    private void runTimer() {
//
//        // Get the text view.
//        final TextView timeView
//                = (TextView)findViewById(
////                R.id.txt_description);
//                R.id.txt_count_time);
//
//        // Creates a new Handler
//        final Handler handler
//                = new Handler();
//
//        // Call the post() method,
//        // passing in a new Runnable.
//        // The post() method processes
//        // code without a delay,
//        // so the code in the Runnable
//        // will run almost immediately.
//        handler.post(new Runnable() {
//            @Override
//
//            public void run()
//            {
//                // If running is true, increment the
//                // seconds variable.
//                if (running) {
//                    seconds++;
//
//                }
//                if(seconds == waiting_time){
//                    if ( SmartwatchClient.getInstance().status == ACCEPT_ACK){
//                        Utils.playMedia(getApplicationContext(), R.raw.ship_siren);
//                        Log.d(getString(R.string.tag), "Over waiting_time");
//                        layout_bg.setBackgroundResource(R.color.red);
//                        txt_count_time.setTextColor(Color.YELLOW);
//                        btn_start.setBackgroundResource(R.color.yellow);
//                        btn_start.setTextColor(Color.BLACK);
//
//                        sendTransactionCommand(ST_OVER_REQUEST);
//                    }
//                }
//
//                Log.d(getString(R.string.tag), "seconds = "+seconds);
//                int hours = seconds / 3600;
//                int minutes = (seconds % 3600) / 60;
//                int secs = seconds % 60;
//
//                // Format the seconds into hours, minutes,
//                // and seconds.
//                String time
//                        = String
//                        .format(Locale.getDefault(),
//                                "%d:%02d:%02d", hours,
//                                minutes, secs);
//
//                timeView.setText(time);
//                Log.d(getString(R.string.tag), "time = "+time);
//
//                // Post the code again
//                // with a delay of 1 second.
//                handler.postDelayed(this, 1000);
//            }
//        });
//    }
}