﻿using System;
using System.IO;
using System.Reflection;

namespace lib
{
    public class LogWriter
    {
        private string m_logDir = string.Empty;
        private string m_logFile = string.Empty;
        private bool m_appendDate = false;
        private static LogWriter logWriter = null;

        public static bool Disable = false;

        public enum LogLevel { INFO, DEBUG, WARN, ERROR }

        public static LogWriter getInstance()
        {
            if (logWriter == null)
                logWriter = new LogWriter();

            return logWriter;
        }

        private LogWriter()
        {
            m_logDir = Path.GetDirectoryName(this.GetType().Assembly.GetModules()[0].FullyQualifiedName);
            m_logFile = m_logDir + "\\" + "log.txt";
        }

        public void setLogDir(String dir)
        {
            m_logDir = dir;
        }

        public void setAppendDate(bool appendDate)
        {
            m_appendDate= appendDate;
        }

        public void Log(string logMessage, LogLevel logLevel = LogLevel.INFO)
        {

            // This project write log => logging_yyyymmdd.log
            if (m_appendDate)
                m_logFile = string.Format("{0}\\logging_{1}.log", m_logDir, DateTime.Now.ToString("yyyyMMdd"));

            try
            {
                using (StreamWriter w = File.AppendText(m_logFile))
                {
                    Log(logMessage, w, logLevel);
                }
            }
            catch (Exception ex)
            {
            }
        }

        public void Info(string logMessage)
        {
            Log(logMessage, LogLevel.INFO);
        }

        public void Warn(string logMessage)
        {
            Log(logMessage, LogLevel.WARN);
        }

        public void Debug(string logMessage)
        {
            Log(logMessage, LogLevel.DEBUG);
        }

        public void Error(string logMessage)
        {
            Log(logMessage, LogLevel.ERROR);
        }

        public void Log(string[] arry, LogLevel logLevel = LogLevel.INFO)
        {
            // This project write log => logging_yyyymmdd.log
            if (m_appendDate)
                m_logFile = string.Format("{0}\\logging_{1}.log", m_logDir, DateTime.Now.ToString("yyyyMMdd"));

            try
            {
                using (StreamWriter w = File.AppendText(m_logFile))
                {
                    string tmp = "[";
                    bool first = true;
                    foreach (var str in arry)
                    {
                        tmp += String.Format("{0}\"{1}\"\n", first ? "" : ",", str);
                        first = false;
                    }
                    tmp += "]";
                    Log(tmp, w, logLevel);
                }
            }
            catch (Exception ex)
            {
            }
        }

        private void Log(string logMessage, TextWriter txtWriter, LogLevel logLevel)
        {
            if (Disable) return;

            try
            {
                txtWriter.WriteLine("{0}|{1}|{2}", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"), logLevel, logMessage);
            }
            catch (Exception ex)
            {
            }
        }
    }

    
}
