﻿using lib;
using lib.datasource;
using lib.model;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.DirectoryServices.ActiveDirectory;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Transactions;
using System.Windows.Forms;
using static System.Windows.Forms.VisualStyles.VisualStyleElement;
using static System.Windows.Forms.VisualStyles.VisualStyleElement.TrackBar;

namespace MAST_Linkage_data
{
    public partial class Linkage_data : Form
    {
        protected LogWriter logger = LogWriter.getInstance();
        const string INI = "Linkage_data.ini";
        private List<List<string>> Import = new List<List<string>>();
        IniFile ini;
        String log_dir = "";
        String strDateTimeFCT80T = DateTime.Now.ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT80T0 = DateTime.Now.ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT80T1 = DateTime.Now.AddMinutes(-1).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT80T2 = DateTime.Now.AddMinutes(-2).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT80T3 = DateTime.Now.AddMinutes(-3).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT80T4 = DateTime.Now.AddMinutes(-4).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT80T5 = DateTime.Now.AddMinutes(-5).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT80T6 = DateTime.Now.AddMinutes(-6).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT80T7 = DateTime.Now.AddMinutes(-7).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT80T8 = DateTime.Now.AddMinutes(-8).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT80T9 = DateTime.Now.AddMinutes(-9).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT80T10 = DateTime.Now.AddMinutes(-10).ToString("yyyyMMddHHmmss");

        String strDateTimeFCT81T = DateTime.Now.ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT81T0 = DateTime.Now.ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT81T1 = DateTime.Now.AddMinutes(-1).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT81T2 = DateTime.Now.AddMinutes(-2).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT81T3 = DateTime.Now.AddMinutes(-3).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT81T4 = DateTime.Now.AddMinutes(-4).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT81T5 = DateTime.Now.AddMinutes(-5).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT81T6 = DateTime.Now.AddMinutes(-6).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT81T7 = DateTime.Now.AddMinutes(-7).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT81T8 = DateTime.Now.AddMinutes(-8).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT81T9 = DateTime.Now.AddMinutes(-9).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT81T10 = DateTime.Now.AddMinutes(-10).ToString("yyyyMMddHHmmss");

        String strDateTimeFCT82T = DateTime.Now.ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT82T0 = DateTime.Now.ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT82T1 = DateTime.Now.AddMinutes(-1).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT82T2 = DateTime.Now.AddMinutes(-2).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT82T3 = DateTime.Now.AddMinutes(-3).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT82T4 = DateTime.Now.AddMinutes(-4).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT82T5 = DateTime.Now.AddMinutes(-5).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT82T6 = DateTime.Now.AddMinutes(-6).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT82T7 = DateTime.Now.AddMinutes(-7).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT82T8 = DateTime.Now.AddMinutes(-8).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT82T9 = DateTime.Now.AddMinutes(-9).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT82T10 = DateTime.Now.AddMinutes(-10).ToString("yyyyMMddHHmmss");

        String strDateTimeFCT83T = DateTime.Now.ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT83T0 = DateTime.Now.ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT83T1 = DateTime.Now.AddMinutes(-1).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT83T2 = DateTime.Now.AddMinutes(-2).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT83T3 = DateTime.Now.AddMinutes(-3).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT83T4 = DateTime.Now.AddMinutes(-4).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT83T5 = DateTime.Now.AddMinutes(-5).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT83T6 = DateTime.Now.AddMinutes(-6).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT83T7 = DateTime.Now.AddMinutes(-7).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT83T8 = DateTime.Now.AddMinutes(-8).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT83T9 = DateTime.Now.AddMinutes(-9).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT83T10 = DateTime.Now.AddMinutes(-10).ToString("yyyyMMddHHmmss");

        String strDateTimeFCT84T = DateTime.Now.ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT84T0 = DateTime.Now.ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT84T1 = DateTime.Now.AddMinutes(-1).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT84T2 = DateTime.Now.AddMinutes(-2).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT84T3 = DateTime.Now.AddMinutes(-3).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT84T4 = DateTime.Now.AddMinutes(-4).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT84T5 = DateTime.Now.AddMinutes(-5).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT84T6 = DateTime.Now.AddMinutes(-6).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT84T7 = DateTime.Now.AddMinutes(-7).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT84T8 = DateTime.Now.AddMinutes(-8).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT84T9 = DateTime.Now.AddMinutes(-9).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT84T10 = DateTime.Now.AddMinutes(-10).ToString("yyyyMMddHHmmss");

        String strDateTimeFCT85T = DateTime.Now.ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT85T0 = DateTime.Now.ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT85T1 = DateTime.Now.AddMinutes(-1).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT85T2 = DateTime.Now.AddMinutes(-2).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT85T3 = DateTime.Now.AddMinutes(-3).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT85T4 = DateTime.Now.AddMinutes(-4).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT85T5 = DateTime.Now.AddMinutes(-5).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT85T6 = DateTime.Now.AddMinutes(-6).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT85T7 = DateTime.Now.AddMinutes(-7).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT85T8 = DateTime.Now.AddMinutes(-8).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT85T9 = DateTime.Now.AddMinutes(-9).ToString("yyyyMMddHHmmss");
        String strDateTimeBeforeFCT85T10 = DateTime.Now.AddMinutes(-10).ToString("yyyyMMddHHmmss");

        private Int32 intTime;
        private Int32 intTimeExport;
        private bool IsProcess1;
        private bool IsProcess2;
        private bool IsProcess3;
        private bool IsProcess4;
        private bool IsProcess5;
        private bool IsProcess6;

        string isProcess = string.Empty;

        private string PartFile_isProcess = System.IO.Directory.GetCurrentDirectory() + "\\isProcessExportInventory.ini";

        Task[] tasks = new Task[9];

  
        public Linkage_data()
        {
            InitializeComponent();
        }

        private void Linkage_data_Load(object sender, EventArgs e)
        {
            Version version = Assembly.GetEntryAssembly().GetName().Version;
            this.Text = "Linkage data V." + version;
            ini = new IniFile(INI);
            string strTime = ini.Read("IntervalImport", "Timer");
            string strTimeExport = ini.Read("IntervalExport", "Timer");
            intTime = Convert.ToInt32(strTime);
            intTimeExport = Convert.ToInt32(strTimeExport);

            timerImport.Interval = intTime;
            timerExport.Interval = intTimeExport;

            if (!File.Exists(PartFile_isProcess))
            {
                using (StreamWriter sw = File.CreateText(PartFile_isProcess))
                {
                    sw.Write("true");
                }
            }

            isProcess = File.ReadAllText(PartFile_isProcess);

            ExecuteMultithreading();

            IsProcess1 = true;
            IsProcess2 = false;
            IsProcess5 = false;
            IsProcess6 = false;
            IsProcess4 = false;
            IsProcess3 = false;

            ExecuteMultithreadingImport();

            timerImport.Enabled = true;
            timerExport.Enabled = true;


        }

        public static bool FileLocked80T(string FileName)
        {
            FileStream fs = null;

            try
            {
                // NOTE: This doesn't handle situations where file is opened for writing by another process but put into write shared mode, it will not throw an exception and won't show it as write locked
                fs = File.Open(FileName, FileMode.Open, FileAccess.ReadWrite, FileShare.None); // If we can't open file for reading and writing then it's locked by another process for writing
            }
            catch (UnauthorizedAccessException) // https://msdn.microsoft.com/en-us/library/y973b725(v=vs.110).aspx
            {
                // This is because the file is Read-Only and we tried to open in ReadWrite mode, now try to open in Read only mode
                try
                {
                    fs = File.Open(FileName, FileMode.Open, FileAccess.Read, FileShare.None);
                }
                catch (Exception)
                {
                    return true; // This file has been locked, we can't even open it to read
                }
            }
            catch (Exception)
            {
                return true; // This file has been locked
            }
            finally
            {
                if (fs != null)
                    fs.Close();
            }
            return false;
        }

        private void Process_Import_FCT80T()
        {


            try
            {
                List<string> tmp = null;
                //Import = new List<List<string>>();
                tmp = null;
                int i = 1;
                string strHeaderRow = ini.Read("FCT80T", "Header");
                int j = Convert.ToInt32(strHeaderRow);
                string strPathName = ini.Read("FCT80T", "Folder");
                string strPathBackup = ini.Read("FCT80T", "FolderBackup");
                string strFileName = "FCT80T_" + strDateTimeFCT80T + ".csv";
                for (int s = 0; s < 60; s++)
                {
                    string strS = s.ToString();
                    if (strS.Length == 1)
                    {
                        strS = "0" + strS;
                    }
                    strFileName = strFileName.Substring(0, 19) + strS + ".csv";

                    if (File.Exists(strPathName + strFileName))
                    {
                        break;
                    }
                }

                if (!File.Exists(strPathName + strFileName))
                {

                    return;
                }

                //var fs = new FileStream(strPathName + strFileName, FileMode.Open);

                //using (var fs = new FileStream(strPathName + strFileName, FileMode.Open))
                //{
                //    var canRead = fs.CanRead;
                //    var canWrite = fs.CanWrite;
                //    if (canWrite == false)
                //    {
                //        return;
                //    }
                //}

                if (FileLocked80T(strPathName + strFileName) == true)
                {
                    return;
                }

                using (var csv = new CsvReader(strPathName + strFileName))
                {                    
                    while ((tmp = csv.ReadRow()) != null)
                    {
                        //Import.Add(tmp);


                        if (i <= j)
                        {
                            i = i + 1;
                            continue;
                        }

                        if (tmp.LongCount() != 16)
                        {
                            continue;
                        }

                        if (Convert.ToDateTime(tmp[14].Substring(0, 4) + "-" + tmp[14].Substring(4, 2)
                            + "-" + tmp[14].Substring(6, 2)).Date
                            <= Convert.ToDateTime(ini.Read("FCT80T", "LastUpdate")).Date)
                        {
                            continue;
                        }

                        // Insert into ImportMRPfactory
                        ImportMRPfactory ImportMRPfactory = new ImportMRPfactory();
                        Dictionary<string, object> cols = new Dictionary<string, object>();
                        //cols["factory_code"] = tmp[1];
                        //cols["factory_name"] = tmp[2];
                        //cols["factory_abbreviation_name"] = tmp[3];
                        //cols["factory_division"] = tmp[4];
                        //cols["customer_code"] = tmp[5];
                        //cols["factory_classification"] = tmp[6];
                        //cols["product_label_factory_sign"] = tmp[7];
                        //cols["last_update_day"] = tmp[8];
                        //cols["last_update_time"] = tmp[9];
                        //cols["last_renewer_id"] = tmp[10];
                        //cols["maker_date"] = tmp[11];
                        //cols["creation_time"] = tmp[12];
                        //cols["maker_id"] = tmp[13];
                        //cols["last_transfer_date"] = tmp[14];
                        //cols["last_transfer_time"] = tmp[15];
                        //cols["filename"] = strFileName;
                        //cols["create_dt"] = DateTime.Now;
                        //cols["create_user_id"] = "";
                        //cols["update_dt"] = DateTime.Now;
                        //cols["update_user_id"] = "";
                        cols[ini.Read("Col1", "ColFCT80T")] = tmp[0];
                        cols[ini.Read("Col2", "ColFCT80T")] = tmp[1];
                        cols[ini.Read("Col3", "ColFCT80T")] = tmp[2];
                        cols[ini.Read("Col4", "ColFCT80T")] = tmp[3];
                        cols[ini.Read("Col5", "ColFCT80T")] = tmp[4];
                        cols[ini.Read("Col6", "ColFCT80T")] = tmp[5];
                        cols[ini.Read("Col7", "ColFCT80T")] = tmp[6];
                        cols[ini.Read("Col8", "ColFCT80T")] = tmp[7];
                        cols[ini.Read("Col9", "ColFCT80T")] = tmp[8];
                        cols[ini.Read("Col10", "ColFCT80T")] = tmp[9];
                        cols[ini.Read("Col11", "ColFCT80T")] = tmp[10];
                        cols[ini.Read("Col12", "ColFCT80T")] = tmp[11];
                        cols[ini.Read("Col13", "ColFCT80T")] = tmp[12];
                        cols[ini.Read("Col14", "ColFCT80T")] = tmp[13];
                        cols[ini.Read("Col15", "ColFCT80T")] = tmp[14];
                        cols[ini.Read("Col16", "ColFCT80T")] = tmp[15];
                        cols[ini.Read("Col17", "ColFCT80T")] = strFileName;
                        cols[ini.Read("Col18", "ColFCT80T")] = DateTime.Now;
                        cols[ini.Read("Col19", "ColFCT80T")] = "Test";
                        cols[ini.Read("Col20", "ColFCT80T")] = DateTime.Now;
                        cols[ini.Read("Col21", "ColFCT80T")] = "Test";
                        int ret = ImportMRPfactory.add(cols);
                        if (ret > 0)
                        {
                            showLog(String.Format("Data inserted => {0}.", ""));
                            AppendTextBox1(String.Format("Data inserted => {0}.", ""));
                        }
                        else
                        {
                            // It may can't be inserted into ImportMRPfactory coz duplicated error then try update
                            // Unique key factory_code
                            // try to update with new Read_Time

                            ret = ImportMRPfactory.set(cols, string.
                            //Format("Reader_No={0} AND Serial_No='{1}'", lblReaderNo.Text.ToString(), txtSerialNo.Text.ToString()));
                            //Format("factory_code='{0}'", ""));
                            Format(ini.Read("Col1", "ColFCT80T") + "='{0}'", tmp[0]));
                            if (ret > 0)
                            {
                                showLog(String.Format("Data updated => {0}.", ""));
                                AppendTextBox1(String.Format("Data updated => {0}.", ""));

                            }
                            else
                            {
                                showLog(String.Format("Data updated failed => {0}.", ""));
                                AppendTextBox1(String.Format("Data updated failed => {0}.", ""));

                            }
                        }
                        i = i + 1;


                    }

                }//using end

                ini.Write("FCT80T", DateTime.Now.ToString("yyyy-MM-dd"), "LastUpdate");

                File.Move(strPathName + strFileName, strPathBackup + strFileName);



            }
            catch (Exception ex) { logger.Error(ex.Message + ex.StackTrace); }
        }

        public void AppendTextBox1(string value)
        {
            if (InvokeRequired)
            {
                this.Invoke(new Action<string>(AppendTextBox1), new object[] { value });
                return;
            }
            txtDisplayImport1.Text += value + Environment.NewLine;
            txtDisplayImport1.SelectionStart = txtDisplayImport1.TextLength;
            txtDisplayImport1.ScrollToCaret();
        }

        public void AppendTextBox2(string value)
        {
            if (InvokeRequired)
            {
                this.Invoke(new Action<string>(AppendTextBox2), new object[] { value });
                return;
            }
            txtDisplayImport2.Text += value + Environment.NewLine;
            txtDisplayImport2.SelectionStart = txtDisplayImport2.TextLength;
            txtDisplayImport2.ScrollToCaret();
        }

        public void AppendTextBox3(string value)
        {
            if (InvokeRequired)
            {
                this.Invoke(new Action<string>(AppendTextBox3), new object[] { value });
                return;
            }
            txtDisplayImport3.Text += value + Environment.NewLine;
            txtDisplayImport3.SelectionStart = txtDisplayImport3.TextLength;
            txtDisplayImport3.ScrollToCaret();
        }

        public void AppendTextBox4(string value)
        {
            if (InvokeRequired)
            {
                this.Invoke(new Action<string>(AppendTextBox4), new object[] { value });
                return;
            }
            txtDisplayImport4.Text += value + Environment.NewLine;
            txtDisplayImport4.SelectionStart = txtDisplayImport4.TextLength;
            txtDisplayImport4.ScrollToCaret();
        }

        public void AppendTextBox5(string value)
        {
            if (InvokeRequired)
            {
                this.Invoke(new Action<string>(AppendTextBox5), new object[] { value });
                return;
            }
            txtDisplayImport5.Text += value + Environment.NewLine;
            txtDisplayImport5.SelectionStart = txtDisplayImport5.TextLength;
            txtDisplayImport5.ScrollToCaret();
        }

        public void AppendTextBox6(string value)
        {
            if (InvokeRequired)
            {
                this.Invoke(new Action<string>(AppendTextBox6), new object[] { value });
                return;
            }
            txtDisplayImport6.Text += value + Environment.NewLine;
            txtDisplayImport6.SelectionStart = txtDisplayImport6.TextLength;
            txtDisplayImport6.ScrollToCaret();
        }

        public void AppendTextBoxExport1(string value)
        {
            if (InvokeRequired)
            {
                this.Invoke(new Action<string>(AppendTextBoxExport1), new object[] { value });
                return;
            }
            txtDisplayExport1.Text += value + Environment.NewLine;
            txtDisplayExport1.SelectionStart = txtDisplayExport1.TextLength;
            txtDisplayExport1.ScrollToCaret();
        }

        public void AppendTextBoxExport2(string value)
        {
            if (InvokeRequired)
            {
                this.Invoke(new Action<string>(AppendTextBoxExport2), new object[] { value });
                return;
            }
            txtDisplayExport2.Text += value + Environment.NewLine;
            txtDisplayExport2.SelectionStart = txtDisplayExport2.TextLength;
            txtDisplayExport2.ScrollToCaret();
        }

        public void AppendTextBoxExport3(string value)
        {
            if (InvokeRequired)
            {
                this.Invoke(new Action<string>(AppendTextBoxExport3), new object[] { value });
                return;
            }
            txtDisplayExport3.Text += value + Environment.NewLine;
            txtDisplayExport3.SelectionStart = txtDisplayExport3.TextLength;
            txtDisplayExport3.ScrollToCaret();
        }

        public static bool FileLocked81T(string FileName)
        {
            FileStream fs = null;

            try
            {
                // NOTE: This doesn't handle situations where file is opened for writing by another process but put into write shared mode, it will not throw an exception and won't show it as write locked
                fs = File.Open(FileName, FileMode.Open, FileAccess.ReadWrite, FileShare.None); // If we can't open file for reading and writing then it's locked by another process for writing
            }
            catch (UnauthorizedAccessException) // https://msdn.microsoft.com/en-us/library/y973b725(v=vs.110).aspx
            {
                // This is because the file is Read-Only and we tried to open in ReadWrite mode, now try to open in Read only mode
                try
                {
                    fs = File.Open(FileName, FileMode.Open, FileAccess.Read, FileShare.None);
                }
                catch (Exception)
                {
                    return true; // This file has been locked, we can't even open it to read
                }
            }
            catch (Exception)
            {
                return true; // This file has been locked
            }
            finally
            {
                if (fs != null)
                    fs.Close();
            }
            return false;
        }
        private void Process_Import_FCT81T()
        {


            try
            {
                List<string> tmp = null;
                tmp = null;
                int i = 1;
                string strHeaderRow = ini.Read("FCT81T", "Header");
                int j = Convert.ToInt32(strHeaderRow);
                string strPathName = ini.Read("FCT81T", "Folder");
                string strPathBackup = ini.Read("FCT81T", "FolderBackup");
                string strFileName = "FCT81T_" + strDateTimeFCT81T + ".csv";
                for (int s = 0; s < 60; s++)
                {
                    string strS = s.ToString();
                    if (strS.Length == 1)
                    {
                        strS = "0" + strS;
                    }
                    strFileName = strFileName.Substring(0, 19) + strS + ".csv";

                    if (File.Exists(strPathName + strFileName))
                    {
                        break;
                    }
                }
                if (!File.Exists(strPathName + strFileName))
                {

                    return;
                }

                if (FileLocked81T(strPathName + strFileName) == true)
                {
                    return;
                }

                using (var csv = new CsvReader(strPathName + strFileName))
                {
                    while ((tmp = csv.ReadRow()) != null)
                    {
                        if (i <= j)
                        {
                            i = i + 1;

                            continue;
                        }

                        if (tmp.LongCount() != 17)
                        {
                            continue;
                        }

                        if (Convert.ToDateTime(tmp[15].Substring(0, 4) + "-" + tmp[15].Substring(4, 2)
                            + "-" + tmp[15].Substring(6, 2)).Date
                            <= Convert.ToDateTime(ini.Read("FCT81T", "LastUpdate")).Date)
                        {
                            continue;
                        }

                        // Insert into ImportSupplier
                        ImportSupplier ImportSupplier = new ImportSupplier();
                        Dictionary<string, object> cols = new Dictionary<string, object>();
                        cols[ini.Read("Col1", "ColFCT81T")] = tmp[0];
                        cols[ini.Read("Col2", "ColFCT81T")] = tmp[1];
                        cols[ini.Read("Col3", "ColFCT81T")] = tmp[2];
                        cols[ini.Read("Col4", "ColFCT81T")] = tmp[3];
                        cols[ini.Read("Col5", "ColFCT81T")] = tmp[4];
                        cols[ini.Read("Col6", "ColFCT81T")] = tmp[5];
                        cols[ini.Read("Col7", "ColFCT81T")] = tmp[6];
                        cols[ini.Read("Col8", "ColFCT81T")] = tmp[7];
                        cols[ini.Read("Col9", "ColFCT81T")] = tmp[8];
                        cols[ini.Read("Col10", "ColFCT81T")] = tmp[9];
                        cols[ini.Read("Col11", "ColFCT81T")] = tmp[10];
                        cols[ini.Read("Col12", "ColFCT81T")] = tmp[11];
                        cols[ini.Read("Col13", "ColFCT81T")] = tmp[12];
                        cols[ini.Read("Col14", "ColFCT81T")] = tmp[13];
                        cols[ini.Read("Col15", "ColFCT81T")] = tmp[14];
                        cols[ini.Read("Col16", "ColFCT81T")] = tmp[15];
                        cols[ini.Read("Col17", "ColFCT81T")] = tmp[16];
                        cols[ini.Read("Col18", "ColFCT81T")] = strFileName;
                        cols[ini.Read("Col19", "ColFCT81T")] = DateTime.Now;
                        cols[ini.Read("Col20", "ColFCT81T")] = "Test";
                        cols[ini.Read("Col21", "ColFCT81T")] = DateTime.Now;
                        cols[ini.Read("Col22", "ColFCT81T")] = "Test";
                        int ret = ImportSupplier.add(cols);
                        if (ret > 0)
                        {
                            showLog(String.Format("Data inserted => {0}.", ""));
                            AppendTextBox2(String.Format("Data inserted => {0}.", ""));
                        }
                        else
                        {
                            // It may can't be inserted into ImportSupplier coz duplicated error then try update
                            // Unique key supplyer_code
                            // try to update with new Read_Time

                            ret = ImportSupplier.set(cols, string.
                            //Format("Reader_No={0} AND Serial_No='{1}'", lblReaderNo.Text.ToString(), txtSerialNo.Text.ToString()));
                            //Format("supplyer_code='{0}'", ""));
                            Format(ini.Read("Col7", "ColFCT81T") + "='{0}'", tmp[6]));
                            if (ret > 0)
                            {
                                showLog(String.Format("Data updated => {0}.", ""));
                                AppendTextBox2(String.Format("Data updated => {0}.", ""));
                            }
                            else
                            {
                                showLog(String.Format("Data updated failed => {0}.", ""));
                                AppendTextBox2(String.Format("Data updated failed => {0}.", ""));
                            }
                        }
                        i = i + 1;
                    }

                }//using end

                ini.Write("FCT81T", DateTime.Now.ToString("yyyy-MM-dd"), "LastUpdate");

                File.Move(strPathName + strFileName, strPathBackup + strFileName);


            }
            catch (Exception ex) { logger.Error(ex.Message + ex.StackTrace); }
        }

        public static bool FileLocked82T(string FileName)
        {
            FileStream fs = null;

            try
            {
                // NOTE: This doesn't handle situations where file is opened for writing by another process but put into write shared mode, it will not throw an exception and won't show it as write locked
                fs = File.Open(FileName, FileMode.Open, FileAccess.ReadWrite, FileShare.None); // If we can't open file for reading and writing then it's locked by another process for writing
            }
            catch (UnauthorizedAccessException) // https://msdn.microsoft.com/en-us/library/y973b725(v=vs.110).aspx
            {
                // This is because the file is Read-Only and we tried to open in ReadWrite mode, now try to open in Read only mode
                try
                {
                    fs = File.Open(FileName, FileMode.Open, FileAccess.Read, FileShare.None);
                }
                catch (Exception)
                {
                    return true; // This file has been locked, we can't even open it to read
                }
            }
            catch (Exception)
            {
                return true; // This file has been locked
            }
            finally
            {
                if (fs != null)
                    fs.Close();
            }
            return false;
        }
        private void Process_Import_FCT82T()
        {
            try
            {
                List<string> tmp = null;
                tmp = null;
                int i = 1;
                string strHeaderRow = ini.Read("FCT82T", "Header");
                int j = Convert.ToInt32(strHeaderRow);
                string strPathName = ini.Read("FCT82T", "Folder");
                string strPathBackup = ini.Read("FCT82T", "FolderBackup");
                string strFileName = "FCT82T_" + strDateTimeFCT82T + ".csv";
                for (int s = 0; s < 60; s++)
                {
                    string strS = s.ToString();
                    if (strS.Length == 1)
                    {
                        strS = "0" + strS;
                    }
                    strFileName = strFileName.Substring(0, 19) + strS + ".csv";

                    if (File.Exists(strPathName + strFileName))
                    {
                        break;
                    }
                }
                if (!File.Exists(strPathName + strFileName))
                {
                    return;
                }

                if (FileLocked82T(strPathName + strFileName) == true)
                {
                    return;
                }

                using (var csv = new CsvReader(strPathName + strFileName))
                {
                    while ((tmp = csv.ReadRow()) != null)
                    {
                        if (i <= j)
                        {
                            i = i + 1;

                            continue;
                        }

                        if (tmp.LongCount() != 66)
                        {
                            continue;
                        }

                        if (Convert.ToDateTime(tmp[64].Substring(0, 4) + "-" + tmp[64].Substring(4, 2)
                            + "-" + tmp[64].Substring(6, 2)).Date
                            <= Convert.ToDateTime(ini.Read("FCT82T", "LastUpdate")).Date)
                        {
                            continue;
                        }

                        // Insert into ImportItem
                        ImportItem ImportItem = new ImportItem();
                        Dictionary<string, object> cols = new Dictionary<string, object>();
                        cols[ini.Read("Col1", "ColFCT82T")] = tmp[0];
                        cols[ini.Read("Col2", "ColFCT82T")] = tmp[1];
                        cols[ini.Read("Col3", "ColFCT82T")] = tmp[2];
                        cols[ini.Read("Col4", "ColFCT82T")] = tmp[3];
                        cols[ini.Read("Col5", "ColFCT82T")] = tmp[4];
                        cols[ini.Read("Col6", "ColFCT82T")] = tmp[5];
                        cols[ini.Read("Col7", "ColFCT82T")] = tmp[6];
                        cols[ini.Read("Col8", "ColFCT82T")] = tmp[7];
                        cols[ini.Read("Col9", "ColFCT82T")] = tmp[8];
                        cols[ini.Read("Col10", "ColFCT82T")] = tmp[9];
                        cols[ini.Read("Col11", "ColFCT82T")] = tmp[10];
                        cols[ini.Read("Col12", "ColFCT82T")] = tmp[11];
                        cols[ini.Read("Col13", "ColFCT82T")] = tmp[12];
                        cols[ini.Read("Col14", "ColFCT82T")] = tmp[13];
                        cols[ini.Read("Col15", "ColFCT82T")] = tmp[14];
                        cols[ini.Read("Col16", "ColFCT82T")] = tmp[15];
                        cols[ini.Read("Col17", "ColFCT82T")] = tmp[16];
                        cols[ini.Read("Col18", "ColFCT82T")] = tmp[17];
                        cols[ini.Read("Col19", "ColFCT82T")] = tmp[18];
                        cols[ini.Read("Col20", "ColFCT82T")] = tmp[19];
                        cols[ini.Read("Col21", "ColFCT82T")] = tmp[20];
                        cols[ini.Read("Col22", "ColFCT82T")] = tmp[21];
                        cols[ini.Read("Col23", "ColFCT82T")] = tmp[22];
                        cols[ini.Read("Col24", "ColFCT82T")] = tmp[23];
                        cols[ini.Read("Col25", "ColFCT82T")] = tmp[24];
                        cols[ini.Read("Col26", "ColFCT82T")] = tmp[25];
                        cols[ini.Read("Col27", "ColFCT82T")] = tmp[26];
                        cols[ini.Read("Col28", "ColFCT82T")] = tmp[27];
                        cols[ini.Read("Col29", "ColFCT82T")] = tmp[28];
                        cols[ini.Read("Col30", "ColFCT82T")] = tmp[29];
                        cols[ini.Read("Col31", "ColFCT82T")] = tmp[30];
                        cols[ini.Read("Col32", "ColFCT82T")] = tmp[31];
                        cols[ini.Read("Col33", "ColFCT82T")] = tmp[32];
                        cols[ini.Read("Col34", "ColFCT82T")] = tmp[33];
                        cols[ini.Read("Col35", "ColFCT82T")] = tmp[34];
                        cols[ini.Read("Col36", "ColFCT82T")] = tmp[35];
                        cols[ini.Read("Col37", "ColFCT82T")] = tmp[36];
                        cols[ini.Read("Col38", "ColFCT82T")] = tmp[37];
                        cols[ini.Read("Col39", "ColFCT82T")] = tmp[38];
                        cols[ini.Read("Col40", "ColFCT82T")] = tmp[39];
                        cols[ini.Read("Col41", "ColFCT82T")] = tmp[40];
                        cols[ini.Read("Col42", "ColFCT82T")] = tmp[41];
                        cols[ini.Read("Col43", "ColFCT82T")] = tmp[42];
                        cols[ini.Read("Col44", "ColFCT82T")] = tmp[43];
                        cols[ini.Read("Col45", "ColFCT82T")] = tmp[44];
                        cols[ini.Read("Col46", "ColFCT82T")] = tmp[45];
                        cols[ini.Read("Col47", "ColFCT82T")] = tmp[46];
                        cols[ini.Read("Col48", "ColFCT82T")] = tmp[47];
                        cols[ini.Read("Col49", "ColFCT82T")] = tmp[48];
                        cols[ini.Read("Col50", "ColFCT82T")] = tmp[49];
                        cols[ini.Read("Col51", "ColFCT82T")] = tmp[50];
                        cols[ini.Read("Col52", "ColFCT82T")] = tmp[51];
                        cols[ini.Read("Col53", "ColFCT82T")] = tmp[52];
                        cols[ini.Read("Col54", "ColFCT82T")] = tmp[53];
                        cols[ini.Read("Col55", "ColFCT82T")] = tmp[54];
                        cols[ini.Read("Col56", "ColFCT82T")] = tmp[55];
                        cols[ini.Read("Col57", "ColFCT82T")] = tmp[56];
                        cols[ini.Read("Col58", "ColFCT82T")] = tmp[57];
                        cols[ini.Read("Col59", "ColFCT82T")] = tmp[58];
                        cols[ini.Read("Col60", "ColFCT82T")] = tmp[59];
                        cols[ini.Read("Col61", "ColFCT82T")] = tmp[60];
                        cols[ini.Read("Col62", "ColFCT82T")] = tmp[61];
                        cols[ini.Read("Col63", "ColFCT82T")] = tmp[62];
                        cols[ini.Read("Col64", "ColFCT82T")] = tmp[63];
                        cols[ini.Read("Col65", "ColFCT82T")] = tmp[64];
                        cols[ini.Read("Col66", "ColFCT82T")] = tmp[65];
                        cols[ini.Read("Col67", "ColFCT82T")] = strFileName;
                        cols[ini.Read("Col68", "ColFCT82T")] = DateTime.Now;
                        cols[ini.Read("Col69", "ColFCT82T")] = "Test";
                        cols[ini.Read("Col70", "ColFCT82T")] = DateTime.Now;
                        cols[ini.Read("Col71", "ColFCT82T")] = "Test";
                        int ret = ImportItem.add(cols);
                        if (ret > 0)
                        {
                            showLog(String.Format("Data inserted => {0}.", ""));
                            AppendTextBox3(String.Format("Data inserted => {0}.", ""));
                        }
                        else
                        {
                            // It may can't be inserted into ImportSupplier coz duplicated error then try update
                            // Unique key part_no0, part_no1, part_no2
                            // try to update with new Read_Time

                            ret = ImportItem.set(cols, string.
                            //Format("Reader_No={0} AND Serial_No='{1}'", lblReaderNo.Text.ToString(), txtSerialNo.Text.ToString()));
                            //Format("part_no0='{0}'", ""));
                            Format(ini.Read("Col1", "ColFCT82T") + "='{0}' AND " + ini.Read("Col2", "ColFCT82T") + "='{1}' AND "
                            + ini.Read("Col3", "ColFCT82T") + "='{2}'", tmp[0], tmp[1], tmp[2]));
                            if (ret > 0)
                            {
                                showLog(String.Format("Data updated => {0}.", ""));
                                AppendTextBox3(String.Format("Data updated => {0}.", ""));
                            }
                            else
                            {
                                showLog(String.Format("Data updated failed => {0}.", ""));
                                AppendTextBox3(String.Format("Data updated failed => {0}.", ""));
                            }
                        }
                        i = i + 1;
                    }

                }//using end

                ini.Write("FCT82T", DateTime.Now.ToString("yyyy-MM-dd"), "LastUpdate");

                File.Move(strPathName + strFileName, strPathBackup + strFileName);

            }
            catch (Exception ex) { logger.Error(ex.Message + ex.StackTrace); }
        }

        public static bool FileLocked83T(string FileName)
        {
            FileStream fs = null;

            try
            {
                // NOTE: This doesn't handle situations where file is opened for writing by another process but put into write shared mode, it will not throw an exception and won't show it as write locked
                fs = File.Open(FileName, FileMode.Open, FileAccess.ReadWrite, FileShare.None); // If we can't open file for reading and writing then it's locked by another process for writing
            }
            catch (UnauthorizedAccessException) // https://msdn.microsoft.com/en-us/library/y973b725(v=vs.110).aspx
            {
                // This is because the file is Read-Only and we tried to open in ReadWrite mode, now try to open in Read only mode
                try
                {
                    fs = File.Open(FileName, FileMode.Open, FileAccess.Read, FileShare.None);
                }
                catch (Exception)
                {
                    return true; // This file has been locked, we can't even open it to read
                }
            }
            catch (Exception)
            {
                return true; // This file has been locked
            }
            finally
            {
                if (fs != null)
                    fs.Close();
            }
            return false;
        }
        private void Process_Import_FCT83T()
        {
            try
            {
                List<string> tmp = null;
                //Import = new List<List<string>>();
                tmp = null;
                int i = 1;
                string strHeaderRow = ini.Read("FCT83T", "Header");
                int j = Convert.ToInt32(strHeaderRow);
                string strPathName = ini.Read("FCT83T", "Folder");
                string strPathBackup = ini.Read("FCT83T", "FolderBackup");
                string strFileName = "FCT83T_" + strDateTimeFCT83T + ".csv";
                for (int s = 0; s < 60; s++)
                {
                    string strS = s.ToString();
                    if (strS.Length == 1)
                    {
                        strS = "0" + strS;
                    }
                    strFileName = strFileName.Substring(0, 19) + strS + ".csv";

                    if (File.Exists(strPathName + strFileName))
                    {
                        break;
                    }
                }

                if (!File.Exists(strPathName + strFileName))
                {
                    return;
                }

                if (FileLocked83T(strPathName + strFileName) == true)
                {
                    return;
                }

                using (var csv = new CsvReader(strPathName + strFileName))
                {
                    while ((tmp = csv.ReadRow()) != null)
                    {
                        //Import.Add(tmp);

                        if (i <= j)
                        {
                            i = i + 1;
                            continue;
                        }

                        if (tmp.LongCount() != 13)
                        {
                            continue;
                        }

                        if (Convert.ToDateTime(tmp[11].Substring(0, 4) + "-" + tmp[11].Substring(4, 2)
                            + "-" + tmp[11].Substring(6, 2)).Date
                            <= Convert.ToDateTime(ini.Read("FCT83T", "LastUpdate")).Date)
                        {
                            continue;
                        }

                        // Insert into ImportBucketQuantity
                        ImportBucketQuantity ImportBucketQuantity = new ImportBucketQuantity();
                        Dictionary<string, object> cols = new Dictionary<string, object>();
                        cols[ini.Read("Col1", "ColFCT83T")] = tmp[0];
                        cols[ini.Read("Col2", "ColFCT83T")] = tmp[1];
                        cols[ini.Read("Col3", "ColFCT83T")] = tmp[2];
                        cols[ini.Read("Col4", "ColFCT83T")] = tmp[3];
                        cols[ini.Read("Col5", "ColFCT83T")] = tmp[4];
                        cols[ini.Read("Col6", "ColFCT83T")] = tmp[5];
                        cols[ini.Read("Col7", "ColFCT83T")] = tmp[6];
                        cols[ini.Read("Col8", "ColFCT83T")] = tmp[7];
                        cols[ini.Read("Col9", "ColFCT83T")] = tmp[8];
                        cols[ini.Read("Col10", "ColFCT83T")] = tmp[9];
                        cols[ini.Read("Col11", "ColFCT83T")] = tmp[10];
                        cols[ini.Read("Col12", "ColFCT83T")] = tmp[11];
                        cols[ini.Read("Col13", "ColFCT83T")] = tmp[12];
                        cols[ini.Read("Col14", "ColFCT83T")] = strFileName;
                        cols[ini.Read("Col15", "ColFCT83T")] = DateTime.Now;
                        cols[ini.Read("Col16", "ColFCT83T")] = "Test";
                        cols[ini.Read("Col17", "ColFCT83T")] = DateTime.Now;
                        cols[ini.Read("Col18", "ColFCT83T")] = "Test";
                        int ret = ImportBucketQuantity.add(cols);
                        if (ret > 0)
                        {
                            showLog(String.Format("Data inserted => {0}.", ""));
                            AppendTextBox4(String.Format("Data inserted => {0}.", ""));
                        }
                        else
                        {
                            // It may can't be inserted into ImportMRPfactory coz duplicated error then try update
                            // Unique key part_no0, part_no1, part_no2
                            // try to update with new Read_Time

                            ret = ImportBucketQuantity.set(cols, string.
                            //Format("Reader_No={0} AND Serial_No='{1}'", lblReaderNo.Text.ToString(), txtSerialNo.Text.ToString()));
                            //Format("part_no0='{0}'", ""));
                            //Format(ini.Read("Col1", "ColFCT83T") + "='{0}' AND " + ini.Read("Col2", "ColFCT83T") + "='{1}'", tmp[0], tmp[1]));
                            Format(ini.Read("Col1", "ColFCT83T") + "='{0}' AND " + ini.Read("Col2", "ColFCT83T") + "='{1}' AND "
                            + ini.Read("Col3", "ColFCT83T") + "='{2}'", tmp[0], tmp[1], tmp[2]));
                            if (ret > 0)
                            {
                                showLog(String.Format("Data updated => {0}.", ""));
                                AppendTextBox4(String.Format("Data updated => {0}.", ""));
                            }
                            else
                            {
                                showLog(String.Format("Data updated failed => {0}.", ""));
                                AppendTextBox4(String.Format("Data updated failed => {0}.", ""));
                            }
                        }
                        i = i + 1;
                    }

                }//using end

                ini.Write("FCT83T", DateTime.Now.ToString("yyyy-MM-dd"), "LastUpdate");

                File.Move(strPathName + strFileName, strPathBackup + strFileName);

            }
            catch (Exception ex) { logger.Error(ex.Message + ex.StackTrace); }
        }

        public static bool FileLocked84T(string FileName)
        {
            FileStream fs = null;

            try
            {
                // NOTE: This doesn't handle situations where file is opened for writing by another process but put into write shared mode, it will not throw an exception and won't show it as write locked
                fs = File.Open(FileName, FileMode.Open, FileAccess.ReadWrite, FileShare.None); // If we can't open file for reading and writing then it's locked by another process for writing
            }
            catch (UnauthorizedAccessException) // https://msdn.microsoft.com/en-us/library/y973b725(v=vs.110).aspx
            {
                // This is because the file is Read-Only and we tried to open in ReadWrite mode, now try to open in Read only mode
                try
                {
                    fs = File.Open(FileName, FileMode.Open, FileAccess.Read, FileShare.None);
                }
                catch (Exception)
                {
                    return true; // This file has been locked, we can't even open it to read
                }
            }
            catch (Exception)
            {
                return true; // This file has been locked
            }
            finally
            {
                if (fs != null)
                    fs.Close();
            }
            return false;
        }
        private void Process_Import_FCT84T()
        {


            try
            {
                List<string> tmp = null;
                tmp = null;
                int i = 1;
                string strHeaderRow = ini.Read("FCT84T", "Header");
                int j = Convert.ToInt32(strHeaderRow);
                string strPathName = ini.Read("FCT84T", "Folder");
                string strPathBackup = ini.Read("FCT84T", "FolderBackup");
                string strFileName = "FCT84T_" + strDateTimeFCT84T + ".csv";
                for (int s = 0; s < 60; s++)
                {
                    string strS = s.ToString();
                    if (strS.Length == 1)
                    {
                        strS = "0" + strS;
                    }
                    strFileName = strFileName.Substring(0, 19) + strS + ".csv";

                    if (File.Exists(strPathName + strFileName))
                    {
                        break;
                    }
                }
                if (!File.Exists(strPathName + strFileName))
                {

                    return;
                }

                if (FileLocked84T(strPathName + strFileName) == true)
                {
                    return;
                }

                using (var csv = new CsvReader(strPathName + strFileName))
                {
                    while ((tmp = csv.ReadRow()) != null)
                    {
                        if (i <= j)
                        {
                            i = i + 1;

                            continue;
                        }

                        if (tmp.LongCount() != 43)
                        {
                            continue;
                        }

                        if (Convert.ToDateTime(tmp[39].Substring(0, 4) + "-" + tmp[39].Substring(4, 2)
                            + "-" + tmp[39].Substring(6, 2)).Date
                            <= Convert.ToDateTime(ini.Read("FCT84T", "LastUpdate")).Date)
                        {
                            continue;
                        }

                        // Insert into ImportPurchaseOrder
                        ImportPurchaseOrder ImportPurchaseOrder = new ImportPurchaseOrder();
                        Dictionary<string, object> cols = new Dictionary<string, object>();
                        cols[ini.Read("Col1", "ColFCT84T")] = tmp[0];
                        cols[ini.Read("Col2", "ColFCT84T")] = tmp[1];
                        cols[ini.Read("Col3", "ColFCT84T")] = tmp[2];
                        cols[ini.Read("Col4", "ColFCT84T")] = tmp[3];
                        cols[ini.Read("Col5", "ColFCT84T")] = tmp[4];
                        cols[ini.Read("Col6", "ColFCT84T")] = tmp[5];
                        cols[ini.Read("Col7", "ColFCT84T")] = tmp[6];
                        cols[ini.Read("Col8", "ColFCT84T")] = tmp[7];
                        cols[ini.Read("Col9", "ColFCT84T")] = tmp[8];
                        cols[ini.Read("Col10", "ColFCT84T")] = tmp[9];
                        cols[ini.Read("Col11", "ColFCT84T")] = tmp[10];
                        cols[ini.Read("Col12", "ColFCT84T")] = tmp[11];
                        cols[ini.Read("Col13", "ColFCT84T")] = tmp[12];
                        cols[ini.Read("Col14", "ColFCT84T")] = tmp[13];
                        cols[ini.Read("Col15", "ColFCT84T")] = tmp[14];
                        cols[ini.Read("Col16", "ColFCT84T")] = tmp[15];
                        cols[ini.Read("Col17", "ColFCT84T")] = tmp[16];
                        cols[ini.Read("Col18", "ColFCT84T")] = tmp[17];
                        cols[ini.Read("Col19", "ColFCT84T")] = tmp[18];
                        cols[ini.Read("Col20", "ColFCT84T")] = tmp[19];
                        cols[ini.Read("Col21", "ColFCT84T")] = tmp[20];
                        cols[ini.Read("Col22", "ColFCT84T")] = tmp[21];
                        cols[ini.Read("Col23", "ColFCT84T")] = tmp[22];
                        cols[ini.Read("Col24", "ColFCT84T")] = tmp[23];
                        cols[ini.Read("Col25", "ColFCT84T")] = tmp[24];
                        cols[ini.Read("Col26", "ColFCT84T")] = tmp[25];
                        cols[ini.Read("Col27", "ColFCT84T")] = tmp[26];
                        cols[ini.Read("Col28", "ColFCT84T")] = tmp[27];
                        cols[ini.Read("Col29", "ColFCT84T")] = tmp[28];
                        cols[ini.Read("Col30", "ColFCT84T")] = tmp[29];
                        cols[ini.Read("Col31", "ColFCT84T")] = tmp[30];
                        cols[ini.Read("Col32", "ColFCT84T")] = tmp[31];
                        cols[ini.Read("Col33", "ColFCT84T")] = tmp[32];
                        cols[ini.Read("Col34", "ColFCT84T")] = tmp[33];
                        cols[ini.Read("Col35", "ColFCT84T")] = tmp[34];
                        cols[ini.Read("Col36", "ColFCT84T")] = tmp[35];
                        cols[ini.Read("Col37", "ColFCT84T")] = tmp[36];
                        cols[ini.Read("Col38", "ColFCT84T")] = tmp[37];
                        cols[ini.Read("Col39", "ColFCT84T")] = tmp[38];
                        cols[ini.Read("Col40", "ColFCT84T")] = tmp[39];
                        cols[ini.Read("Col41", "ColFCT84T")] = tmp[40];
                        cols[ini.Read("Col42", "ColFCT84T")] = tmp[41];
                        cols[ini.Read("Col43", "ColFCT84T")] = tmp[42];
                        cols[ini.Read("Col44", "ColFCT84T")] = strFileName;
                        cols[ini.Read("Col45", "ColFCT84T")] = DateTime.Now;
                        cols[ini.Read("Col46", "ColFCT84T")] = "Test";
                        cols[ini.Read("Col47", "ColFCT84T")] = DateTime.Now;
                        cols[ini.Read("Col48", "ColFCT84T")] = "Test";
                        int ret = ImportPurchaseOrder.add(cols);
                        if (ret > 0)
                        {
                            showLog(String.Format("Data inserted => {0}.", ""));
                            AppendTextBox5(String.Format("Data inserted => {0}.", ""));
                        }
                        else
                        {
                            // It may can't be inserted into ImportSupplier coz duplicated error then try update
                            // Unique key order_no
                            // try to update with new Read_Time

                            ret = ImportPurchaseOrder.set(cols, string.
                            //Format("Reader_No={0} AND Serial_No='{1}'", lblReaderNo.Text.ToString(), txtSerialNo.Text.ToString()));
                            //Format("order_no='{0}'", ""));
                            Format(ini.Read("Col1", "ColFCT84T") + "='{0}'", tmp[0]));
                            if (ret > 0)
                            {
                                showLog(String.Format("Data updated => {0}.", ""));
                                AppendTextBox5(String.Format("Data updated => {0}.", ""));
                            }
                            else
                            {
                                showLog(String.Format("Data updated failed => {0}.", ""));
                                AppendTextBox5(String.Format("Data updated failed => {0}.", ""));
                            }
                        }
                        i = i + 1;
                    }

                }//using end

                ini.Write("FCT84T", DateTime.Now.ToString("yyyy-MM-dd"), "LastUpdate");

                File.Move(strPathName + strFileName, strPathBackup + strFileName);



            }
            catch (Exception ex) { logger.Error(ex.Message + ex.StackTrace); }
        }

        public static bool FileLocked85T(string FileName)
        {
            FileStream fs = null;

            try
            {
                // NOTE: This doesn't handle situations where file is opened for writing by another process but put into write shared mode, it will not throw an exception and won't show it as write locked
                fs = File.Open(FileName, FileMode.Open, FileAccess.ReadWrite, FileShare.None); // If we can't open file for reading and writing then it's locked by another process for writing
            }
            catch (UnauthorizedAccessException) // https://msdn.microsoft.com/en-us/library/y973b725(v=vs.110).aspx
            {
                // This is because the file is Read-Only and we tried to open in ReadWrite mode, now try to open in Read only mode
                try
                {
                    fs = File.Open(FileName, FileMode.Open, FileAccess.Read, FileShare.None);
                }
                catch (Exception)
                {
                    return true; // This file has been locked, we can't even open it to read
                }
            }
            catch (Exception)
            {
                return true; // This file has been locked
            }
            finally
            {
                if (fs != null)
                    fs.Close();
            }
            return false;
        }
        private void Process_Import_FCT85T()
        {
            try
            {
                List<string> tmp = null;
                tmp = null;
                int i = 1;
                string strHeaderRow = ini.Read("FCT85T", "Header");
                int j = Convert.ToInt32(strHeaderRow);
                string strPathName = ini.Read("FCT85T", "Folder");
                string strPathBackup = ini.Read("FCT85T", "FolderBackup");
                string strFileName = "FCT85T_" + strDateTimeFCT85T + ".csv";
                for (int s = 0; s < 60; s++)
                {
                    string strS = s.ToString();
                    if (strS.Length == 1)
                    {
                        strS = "0" + strS;
                    }
                    strFileName = strFileName.Substring(0, 19) + strS + ".csv";

                    if (File.Exists(strPathName + strFileName))
                    {
                        break;
                    }
                }
                if (!File.Exists(strPathName + strFileName))
                {
                    return;
                }

                if (FileLocked85T(strPathName + strFileName) == true)
                {
                    return;
                }

                using (var csv = new CsvReader(strPathName + strFileName))
                {
                    while ((tmp = csv.ReadRow()) != null)
                    {
                        if (i <= j)
                        {
                            i = i + 1;

                            continue;
                        }

                        if (tmp.LongCount() != 52)
                        {
                            continue;
                        }

                        if (Convert.ToDateTime(tmp[48].Substring(0, 4) + "-" + tmp[48].Substring(4, 2)
                            + "-" + tmp[48].Substring(6, 2)).Date
                            <= Convert.ToDateTime(ini.Read("FCT85T", "LastUpdate")).Date)
                        {
                            continue;
                        }

                        // Insert into ImportDeliveryInstruction
                        ImportDeliveryInstruction ImportDeliveryInstruction = new ImportDeliveryInstruction();
                        Dictionary<string, object> cols = new Dictionary<string, object>();
                        cols[ini.Read("Col1", "ColFCT85T")] = tmp[0];
                        cols[ini.Read("Col2", "ColFCT85T")] = tmp[1];
                        cols[ini.Read("Col3", "ColFCT85T")] = tmp[2];
                        cols[ini.Read("Col4", "ColFCT85T")] = tmp[3];
                        cols[ini.Read("Col5", "ColFCT85T")] = tmp[4];
                        cols[ini.Read("Col6", "ColFCT85T")] = tmp[5];
                        cols[ini.Read("Col7", "ColFCT85T")] = tmp[6];
                        cols[ini.Read("Col8", "ColFCT85T")] = tmp[7];
                        cols[ini.Read("Col9", "ColFCT85T")] = tmp[8];
                        cols[ini.Read("Col10", "ColFCT85T")] = tmp[9];
                        cols[ini.Read("Col11", "ColFCT85T")] = tmp[10];
                        cols[ini.Read("Col12", "ColFCT85T")] = tmp[11];
                        cols[ini.Read("Col13", "ColFCT85T")] = tmp[12];
                        cols[ini.Read("Col14", "ColFCT85T")] = tmp[13];
                        cols[ini.Read("Col15", "ColFCT85T")] = tmp[14];
                        cols[ini.Read("Col16", "ColFCT85T")] = tmp[15];
                        cols[ini.Read("Col17", "ColFCT85T")] = tmp[16];
                        cols[ini.Read("Col18", "ColFCT85T")] = tmp[17];
                        cols[ini.Read("Col19", "ColFCT85T")] = tmp[18];
                        cols[ini.Read("Col20", "ColFCT85T")] = tmp[19];
                        cols[ini.Read("Col21", "ColFCT85T")] = tmp[20];
                        cols[ini.Read("Col22", "ColFCT85T")] = tmp[21];
                        cols[ini.Read("Col23", "ColFCT85T")] = tmp[22];
                        cols[ini.Read("Col24", "ColFCT85T")] = tmp[23];
                        cols[ini.Read("Col25", "ColFCT85T")] = tmp[24];
                        cols[ini.Read("Col26", "ColFCT85T")] = tmp[25];
                        cols[ini.Read("Col27", "ColFCT85T")] = tmp[26];
                        cols[ini.Read("Col28", "ColFCT85T")] = tmp[27];
                        cols[ini.Read("Col29", "ColFCT85T")] = tmp[28];
                        cols[ini.Read("Col30", "ColFCT85T")] = tmp[29];
                        cols[ini.Read("Col31", "ColFCT85T")] = tmp[30];
                        cols[ini.Read("Col32", "ColFCT85T")] = tmp[31];
                        cols[ini.Read("Col33", "ColFCT85T")] = tmp[32];
                        cols[ini.Read("Col34", "ColFCT85T")] = tmp[33];
                        cols[ini.Read("Col35", "ColFCT85T")] = tmp[34];
                        cols[ini.Read("Col36", "ColFCT85T")] = tmp[35];
                        cols[ini.Read("Col37", "ColFCT85T")] = tmp[36];
                        cols[ini.Read("Col38", "ColFCT85T")] = tmp[37];
                        cols[ini.Read("Col39", "ColFCT85T")] = tmp[38];
                        cols[ini.Read("Col40", "ColFCT85T")] = tmp[39];
                        cols[ini.Read("Col41", "ColFCT85T")] = tmp[40];
                        cols[ini.Read("Col42", "ColFCT85T")] = tmp[41];
                        cols[ini.Read("Col43", "ColFCT85T")] = tmp[42];
                        cols[ini.Read("Col44", "ColFCT85T")] = tmp[43];
                        cols[ini.Read("Col45", "ColFCT85T")] = tmp[44];
                        cols[ini.Read("Col46", "ColFCT85T")] = tmp[45];
                        cols[ini.Read("Col47", "ColFCT85T")] = tmp[46];
                        cols[ini.Read("Col48", "ColFCT85T")] = tmp[47];
                        cols[ini.Read("Col49", "ColFCT85T")] = tmp[48];
                        cols[ini.Read("Col50", "ColFCT85T")] = tmp[49];
                        cols[ini.Read("Col51", "ColFCT85T")] = tmp[50];
                        cols[ini.Read("Col52", "ColFCT85T")] = tmp[51];
                        cols[ini.Read("Col53", "ColFCT85T")] = strFileName;
                        cols[ini.Read("Col54", "ColFCT85T")] = DateTime.Now;
                        cols[ini.Read("Col55", "ColFCT85T")] = "Test";
                        cols[ini.Read("Col56", "ColFCT85T")] = DateTime.Now;
                        cols[ini.Read("Col57", "ColFCT85T")] = "Test";
                        int ret = ImportDeliveryInstruction.add(cols);
                        if (ret > 0)
                        {
                            showLog(String.Format("Data inserted => {0}.", ""));
                            AppendTextBox6(String.Format("Data inserted => {0}.", ""));
                        }
                        else
                        {
                            // It may can't be inserted into ImportSupplier coz duplicated error then try update
                            // Unique key order_no
                            // try to update with new Read_Time

                            ret = ImportDeliveryInstruction.set(cols, string.
                            //Format("Reader_No={0} AND Serial_No='{1}'", lblReaderNo.Text.ToString(), txtSerialNo.Text.ToString()));
                            //Format("order_no='{0}'", ""));
                            Format(ini.Read("Col1", "ColFCT85T") + "='{0}'", tmp[0]));
                            if (ret > 0)
                            {
                                showLog(String.Format("Data updated => {0}.", ""));
                                AppendTextBox6(String.Format("Data updated => {0}.", ""));
                            }
                            else
                            {
                                showLog(String.Format("Data updated failed => {0}.", ""));
                                AppendTextBox6(String.Format("Data updated failed => {0}.", ""));
                            }
                        }
                        i = i + 1;
                    }

                }//using end

                ini.Write("FCT85T", DateTime.Now.ToString("yyyy-MM-dd"), "LastUpdate");

                File.Move(strPathName + strFileName, strPathBackup + strFileName);

            }
            catch (Exception ex) { logger.Error(ex.Message + ex.StackTrace); }
        }

        private void Process_Export_FCT90()
        {
            string business_partner_no = string.Empty;
            string product_no0 = string.Empty;
            string product_no1 = string.Empty;
            string product_no2 = string.Empty;
            string actual_quantity_received = string.Empty;
            string stock_receipt_date = string.Empty;
            string invoice_no = string.Empty;
            string seq_no = string.Empty;
            string order_no = string.Empty;
            string id = string.Empty;
            string strPathExportInbound = string.Empty;
            string strPathName = ini.Read("FCT90", "Folder");
            String strDateTimeFCT90 = DateTime.Now.ToString("yyyyMMddHHmm");
            string strFileName = "FCT90" + strDateTimeFCT90 + ".csv";

            try
            {
                List<object[]> rows = ExportInbound.GetExportInboundDataSelect(0);

                if (rows.Count > 0)
                {
                    strPathExportInbound = strPathName + strFileName;
                    if (!File.Exists(strPathExportInbound))
                    {

                        using (StreamWriter sw = File.CreateText(strPathExportInbound))
                        {
                            //sw.WriteLine("business_partner_no" + "," + "product_no0" + "," + "product_no1" + "," +
                            //        "product_no2" + "," + "actual_quantity_received" + "," + "stock_receipt_date" +
                            //        "," + "invoice_no" + "," + "seq_no" + "," + "order_no");

                            sw.WriteLine(ini.Read("Col2", "ColFCT90") + "," + ini.Read("Col3", "ColFCT90") + "," + ini.Read("Col4", "ColFCT90") + "," +
                                    ini.Read("Col5", "ColFCT90") + "," + ini.Read("Col6", "ColFCT90") + "," + ini.Read("Col7", "ColFCT90") +
                                    "," + ini.Read("Col8", "ColFCT90") + "," + ini.Read("Col9", "ColFCT90") + "," + ini.Read("Col10", "ColFCT90"));

                            for (int i = 0; i < rows.Count; i++)
                            {
                                business_partner_no = rows[i][0].ToString();
                                product_no0 = rows[i][1].ToString();
                                product_no1 = rows[i][2].ToString();
                                product_no2 = rows[i][3].ToString();
                                actual_quantity_received = rows[i][4].ToString();
                                stock_receipt_date = rows[i][5].ToString();
                                invoice_no = rows[i][6].ToString();
                                seq_no = rows[i][7].ToString();
                                order_no = rows[i][8].ToString();
                                id = rows[i][9].ToString();

                                sw.WriteLine(business_partner_no + "," + product_no0 + "," + product_no1 + "," +
                                    product_no2 + "," + actual_quantity_received + "," + stock_receipt_date +
                                    "," + invoice_no + "," + seq_no + "," + order_no);

                                ExportInboundM ExportInboundM = new ExportInboundM();
                                Dictionary<string, object> cols = new Dictionary<string, object>();
                                cols[ini.Read("Col11", "ColFCT90")] = 1;
                                int ret = ExportInboundM.set(cols, string.
                                    Format(ini.Read("Col1", "ColFCT90") + "={0}", Convert.ToInt16(id)));
                                if (ret > 0)
                                {
                                    showLog(String.Format("Data updated => {0}.", ""));
                                    AppendTextBoxExport1(String.Format("Data updated => {0}.", ""));
                                }
                                else
                                {
                                    showLog(String.Format("Data updated failed => {0}.", ""));
                                    AppendTextBoxExport1(String.Format("Data updated failed => {0}.", ""));
                                }
                            }

                        }
                    }
                }

            }
            catch (Exception)
            {

                throw;
            }


        }

        private void Process_Export_FCT91()
        {
            string order_no = string.Empty;
            string routing_no = string.Empty;
            string product_no0 = string.Empty;
            string product_no1 = string.Empty;
            string product_no2 = string.Empty;
            string qty_actual_goods_issued = string.Empty;
            string output_date = string.Empty;
            string production_date = string.Empty;
            string work_instructions_no = string.Empty;
            string seq_no = string.Empty;
            string id = string.Empty;
            string strPathExportExbound = string.Empty;
            string strPathName = ini.Read("FCT91", "Folder");
            String strDateTimeFCT91 = DateTime.Now.ToString("yyyyMMddHHmm");
            string strFileName = "FCT91" + strDateTimeFCT91 + ".csv";

            try
            {
                List<object[]> rows = ExportOutbound.GetExportOutboundDataSelect(0);

                if (rows.Count > 0)
                {
                    strPathExportExbound = strPathName + strFileName;
                    if (!File.Exists(strPathExportExbound))
                    {

                        using (StreamWriter sw = File.CreateText(strPathExportExbound))
                        {
                            //sw.WriteLine("order_no" + "," + "routing_no" + "," + "product_no0" + "," + "product_no1" + "," +
                            //        "product_no2" + "," + "qty_actual_goods_issued" + "," + "output_date" +
                            //        "," + "production_date" + "," + "work_instructions_no" + "," + "seq_no");

                            sw.WriteLine(ini.Read("Col2", "ColFCT91") + "," + ini.Read("Col3", "ColFCT91") + "," + ini.Read("Col4", "ColFCT91") + "," +
                                    ini.Read("Col5", "ColFCT91") + "," + ini.Read("Col6", "ColFCT91") + "," + ini.Read("Col7", "ColFCT91") +
                                    "," + ini.Read("Col8", "ColFCT91") + "," + ini.Read("Col9", "ColFCT91") + ","
                                    + ini.Read("Col10", "ColFCT91") + "," + ini.Read("Col11", "ColFCT91"));

                            for (int i = 0; i < rows.Count; i++)
                            {
                                order_no = rows[i][0].ToString();
                                routing_no = rows[i][1].ToString();
                                product_no0 = rows[i][2].ToString();
                                product_no1 = rows[i][3].ToString();
                                product_no2 = rows[i][4].ToString();
                                qty_actual_goods_issued = rows[i][5].ToString();
                                output_date = rows[i][6].ToString();
                                production_date = rows[i][7].ToString();
                                work_instructions_no = rows[i][8].ToString();
                                seq_no = rows[i][9].ToString();
                                id = rows[i][10].ToString();

                                sw.WriteLine(order_no + "," + routing_no + "," + product_no0 + "," + product_no1 + "," +
                                    product_no2 + "," + qty_actual_goods_issued + "," + output_date +
                                    "," + production_date + "," + work_instructions_no + "," + seq_no);

                                ExportOutboundM ExportOutboundM = new ExportOutboundM();
                                Dictionary<string, object> cols = new Dictionary<string, object>();
                                cols[ini.Read("Col12", "ColFCT91")] = 1;
                                int ret = ExportOutboundM.set(cols, string.
                                    Format(ini.Read("Col1", "ColFCT91") + "={0}", Convert.ToInt16(id)));
                                if (ret > 0)
                                {
                                    showLog(String.Format("Data updated => {0}.", ""));
                                    AppendTextBoxExport2(String.Format("Data updated => {0}.", ""));
                                }
                                else
                                {
                                    showLog(String.Format("Data updated failed => {0}.", ""));
                                    AppendTextBoxExport2(String.Format("Data updated failed => {0}.", ""));
                                }
                            }

                        }
                    }
                }

            }
            catch (Exception)
            {

                throw;
            }


        }


        private void Process_Export_FCT92()
        {
            string warehouse_code1 = string.Empty;
            string warehouse_code2 = string.Empty;
            string warehouse_code3 = string.Empty;
            string product_no0 = string.Empty;
            string product_no1 = string.Empty;
            string product_no2 = string.Empty;
            string production_date = string.Empty;
            string qty_in_stock = string.Empty;
            string stock_measurement_date = string.Empty;
            string shelf_bin = string.Empty;
            string stock_unit = string.Empty;
            string id = string.Empty;
            string strPathExportExbound = string.Empty;
            string strPathName = ini.Read("FCT92", "Folder");
            String strDateTimeFCT92 = DateTime.Now.ToString("yyyyMMddHHmm");
            string strFileName = "FCT92" + strDateTimeFCT92 + ".csv";

            try
            {
                List<object[]> rows = ExportInventory.GetExportInventoryDataSelect(0);

                if (rows.Count > 0)
                {
                    strPathExportExbound = strPathName + strFileName;
                    if (!File.Exists(strPathExportExbound))
                    {

                        using (StreamWriter sw = File.CreateText(strPathExportExbound))
                        {
                            //sw.WriteLine("warehouse_code1" + "," + "warehouse_code2" + "," + "warehouse_code3" + "," + "product_no0" + "," +
                            //        "product_no1" + "," + "product_no2" + "," + "production_date" +
                            //        "," + "qty_in_stock" + "," + "stock_measurement_date" + "," + "shelf_bin" + "," + "stock_unit");

                            sw.WriteLine(ini.Read("Col2", "ColFCT92") + "," + ini.Read("Col3", "ColFCT92") + "," + ini.Read("Col4", "ColFCT92") + "," +
                                    ini.Read("Col5", "ColFCT92") + "," + ini.Read("Col6", "ColFCT92") + "," + ini.Read("Col7", "ColFCT92") +
                                    "," + ini.Read("Col8", "ColFCT92") + "," + ini.Read("Col9", "ColFCT92") + ","
                                    + ini.Read("Col10", "ColFCT92") + "," + ini.Read("Col11", "ColFCT92") + "," + ini.Read("Col12", "ColFCT92"));

                            for (int i = 0; i < rows.Count; i++)
                            {
                                warehouse_code1 = rows[i][0].ToString();
                                warehouse_code2 = rows[i][1].ToString();
                                warehouse_code3 = rows[i][2].ToString();
                                product_no0 = rows[i][3].ToString();
                                product_no1 = rows[i][4].ToString();
                                product_no2 = rows[i][5].ToString();
                                production_date = rows[i][6].ToString();
                                qty_in_stock = rows[i][7].ToString();
                                stock_measurement_date = rows[i][8].ToString();
                                shelf_bin = rows[i][9].ToString();
                                stock_unit = rows[i][10].ToString();
                                id = rows[i][11].ToString();

                                sw.WriteLine(warehouse_code1 + "," + warehouse_code2 + "," + warehouse_code3 + "," +
                                    product_no0 + "," + product_no1 + "," +
                                    product_no2 + "," + production_date + "," + qty_in_stock +
                                    "," + stock_measurement_date + "," + shelf_bin + "," + stock_unit);

                                ExportInventoryM ExportInventoryM = new ExportInventoryM();
                                Dictionary<string, object> cols = new Dictionary<string, object>();
                                cols[ini.Read("Col13", "ColFCT92")] = 1;
                                int ret = ExportInventoryM.set(cols, string.
                                    Format(ini.Read("Col1", "ColFCT92") + "={0}", Convert.ToInt16(id)));
                                if (ret > 0)
                                {
                                    showLog(String.Format("Data updated => {0}.", ""));
                                    AppendTextBoxExport3(String.Format("Data updated => {0}.", ""));
                                }
                                else
                                {
                                    showLog(String.Format("Data updated failed => {0}.", ""));
                                    AppendTextBoxExport3(String.Format("Data updated failed => {0}.", ""));
                                }
                            }

                        }
                    }
                }

            }
            catch (Exception)
            {

                throw;
            }


        }

        private void showLog(string msg)
        {
            String tmp = String.Format("[{0}] {1}", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"), msg);
            //txtStatus.Text = tmp;
            logger.Info(msg);
        }

        public void ExecuteMultithreading()
        {

            tasks[1] = Task.Run(() => Method7());

            tasks[2] = Task.Run(() => Method8());

            tasks[3] = Task.Run(() => Method9());


        }

        public void ExecuteMultithreadingImport()
        {

            tasks[0] = Task.Run(() => Method1());

            tasks[4] = Task.Run(() => Method3());

            tasks[5] = Task.Run(() => Method4());

            tasks[6] = Task.Run(() => Method6());

            tasks[7] = Task.Run(() => Method5());

            tasks[8] = Task.Run(() => Method2());
        }


        private void Method1()
        {

            if (backgroundWorker1.IsBusy == false)
            {
                backgroundWorker1.RunWorkerAsync();
            }


        }

        private void Method2()
        {


            if (backgroundWorker2.IsBusy == false)
            {
                backgroundWorker2.RunWorkerAsync();
            }


        }

        private void Method3()
        {


            if (backgroundWorker3.IsBusy == false)
            {
                backgroundWorker3.RunWorkerAsync();
            }



        }

        private void Method4()
        {


            if (backgroundWorker4.IsBusy == false)
            {
                backgroundWorker4.RunWorkerAsync();
            }


        }

        private void Method5()
        {
            if (backgroundWorker5.IsBusy == false)
            {
                backgroundWorker5.RunWorkerAsync();
            }


        }

        private void Method6()
        {
            if (backgroundWorker6.IsBusy == false)
            {
                backgroundWorker6.RunWorkerAsync();
            }


        }

        private void Method7()
        {
            if (backgroundWorker7.IsBusy == false)
            {
                backgroundWorker7.RunWorkerAsync();
            }


        }

        private void Method8()
        {
            if (backgroundWorker8.IsBusy == false)
            {
                backgroundWorker8.RunWorkerAsync();
            }


        }

        private void Method9()
        {
            if (backgroundWorker9.IsBusy == false)
            {
                backgroundWorker9.RunWorkerAsync();
            }


        }

        private void timer1_Tick(object sender, EventArgs e)
        {


        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            strDateTimeFCT80T = DateTime.Now.ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT80T0 = DateTime.Now.ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT80T1 = DateTime.Now.AddMinutes(-1).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT80T2 = DateTime.Now.AddMinutes(-2).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT80T3 = DateTime.Now.AddMinutes(-3).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT80T4 = DateTime.Now.AddMinutes(-4).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT80T5 = DateTime.Now.AddMinutes(-5).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT80T6 = DateTime.Now.AddMinutes(-6).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT80T7 = DateTime.Now.AddMinutes(-7).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT80T8 = DateTime.Now.AddMinutes(-8).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT80T9 = DateTime.Now.AddMinutes(-9).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT80T10 = DateTime.Now.AddMinutes(-10).ToString("yyyyMMddHHmmss");
            string strStartDate = ini.Read("StartDate", "RunTimeImport");
            string strEndDate = ini.Read("EndDate", "RunTimeImport");
            string strStartTime = ini.Read("StartTime", "RunTimeImport");
            string strEndTime = ini.Read("EndTime", "RunTimeImport");
            DayOfWeek dayOfWeekStart = DayOfWeek.Monday;
            DayOfWeek dayOfWeekEnd = DayOfWeek.Saturday;
            string[] arrStartTime = strStartTime.Split(":");
            Int32 intStartHour = Convert.ToInt32(arrStartTime[0]);
            Int32 intStartMinute = 0;
            if (arrStartTime.Length == 2)
            {
                intStartMinute = Convert.ToInt32(arrStartTime[1]);
            }
            string[] arrEndTime = strEndTime.Split(":");
            Int32 intEndHour = Convert.ToInt32(arrEndTime[0]);
            Int32 intEndMinute = 0;
            if (arrEndTime.Length == 2)
            {
                intEndMinute = Convert.ToInt32(arrEndTime[1]);
            }

            switch (strStartDate)
            {
                case "Sunday":
                    dayOfWeekStart = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekStart = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekStart = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekStart = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekStart = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekStart = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
            }

            switch (strEndDate)
            {
                case "Sunday":
                    dayOfWeekEnd = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekEnd = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekEnd = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekEnd = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekEnd = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekEnd = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
            }

            for (int i = 0; i < 11; i++)
            {

                switch (i)
                {
                    case 0:
                        strDateTimeFCT80T = strDateTimeBeforeFCT80T10;
                        break;
                    case 1:
                        strDateTimeFCT80T = strDateTimeBeforeFCT80T9;
                        break;
                    case 2:
                        strDateTimeFCT80T = strDateTimeBeforeFCT80T8;
                        break;
                    case 3:
                        strDateTimeFCT80T = strDateTimeBeforeFCT80T7;
                        break;
                    case 4:
                        strDateTimeFCT80T = strDateTimeBeforeFCT80T6;
                        break;
                    case 5:
                        strDateTimeFCT80T = strDateTimeBeforeFCT80T5;
                        break;
                    case 6:
                        strDateTimeFCT80T = strDateTimeBeforeFCT80T4;
                        break;
                    case 7:
                        strDateTimeFCT80T = strDateTimeBeforeFCT80T3;
                        break;
                    case 8:
                        strDateTimeFCT80T = strDateTimeBeforeFCT80T2;
                        break;
                    case 9:
                        strDateTimeFCT80T = strDateTimeBeforeFCT80T1;
                        break;
                    case 10:
                        strDateTimeFCT80T = strDateTimeBeforeFCT80T0;
                        break;
                    default:
                        break;
                }

                if (DateTime.Now.DayOfWeek >= dayOfWeekStart && DateTime.Now.DayOfWeek <= dayOfWeekEnd)
                {
                    if ((DateTime.Now.Hour >= intStartHour) && (DateTime.Now.Hour <= intEndHour))
                    {
                        if (DateTime.Now.Hour == intStartHour && DateTime.Now.Minute >= intStartMinute)
                        {
                            //if (IsProcess1 == true)
                            //{
                                Process_Import_FCT80T();
                            //}


                            //else if (IsProcess2 == true)
                            //{
                            //    Process_Import_FCT81T();
                            //}

                            //else if (IsProcess5 == true)
                            //{
                            //    Process_Import_FCT84T();
                            //}

                            //else if (IsProcess6 == true)
                            //{
                            //    Process_Import_FCT85T();
                            //}

                            //else if (IsProcess4 == true)
                            //{
                            //    Process_Import_FCT83T();
                            //}

                            //else if (IsProcess3 == true)
                            //{
                            //    Process_Import_FCT82T();
                            //}



                        }
                        else if (DateTime.Now.Hour > intStartHour &&
                                DateTime.Now.Hour == intEndHour && DateTime.Now.Minute <= intEndMinute)
                        {
                            //if (IsProcess1 == true)
                            //{
                                Process_Import_FCT80T();
                            //}


                            //else if (IsProcess2 == true)
                            //{
                            //    Process_Import_FCT81T();
                            //}

                            //else if (IsProcess5 == true)
                            //{
                            //    Process_Import_FCT84T();
                            //}

                            //else if (IsProcess6 == true)
                            //{
                            //    Process_Import_FCT85T();
                            //}

                            //else if (IsProcess4 == true)
                            //{
                            //    Process_Import_FCT83T();
                            //}

                            //else if (IsProcess3 == true)
                            //{
                            //    Process_Import_FCT82T();
                            //}

                        }
                        else if (DateTime.Now.Hour > intStartHour &&
                                DateTime.Now.Hour < intEndHour)
                        {
                            //if (IsProcess1 == true)
                            //{
                                Process_Import_FCT80T();
                            //}


                            //else if (IsProcess2 == true)
                            //{
                            //    Process_Import_FCT81T();
                            //}

                            //else if (IsProcess5 == true)
                            //{
                            //    Process_Import_FCT84T();
                            //}

                            //else if (IsProcess6 == true)
                            //{
                            //    Process_Import_FCT85T();
                            //}

                            //else if (IsProcess4 == true)
                            //{
                            //    Process_Import_FCT83T();
                            //}

                            //else if (IsProcess3 == true)
                            //{
                            //    Process_Import_FCT82T();
                            //}
                        }
                    }

                }

            }

            //if (IsProcess1 == true)
            //{
            //    IsProcess1 = false;
            //    IsProcess2 = true;
            //    IsProcess5 = false;
            //    IsProcess6 = false;
            //    IsProcess4 = false;
            //    IsProcess3 = false;
            //}
            //else if (IsProcess2 == true)
            //{
            //    IsProcess1 = true;
            //    IsProcess2 = false;
            //    //IsProcess5 = true;
            //    //IsProcess6 = false;
            //    //IsProcess4 = false;
            //    //IsProcess3 = false;
            //}
            //else if (IsProcess5 == true)
            //{
            //    IsProcess1 = true;
            //    IsProcess2 = false;
            //    IsProcess5 = false;
            //    //IsProcess6 = true;
            //    //IsProcess4 = false;
            //    //IsProcess3 = false;
            //}
            //else if (IsProcess6 == true)
            //{
            //    IsProcess1 = true;
            //    IsProcess2 = false;
            //    IsProcess5 = false;
            //    IsProcess6 = false;
            //    //IsProcess4 = true;
            //    //IsProcess3 = false;
            //}
            //else if (IsProcess4 == true)
            //{
            //    IsProcess1 = true;
            //    IsProcess2 = false;
            //    IsProcess5 = false;
            //    IsProcess6 = false;
            //    IsProcess4 = false;
            //    //IsProcess3 = true;
            //}
            //else if (IsProcess3 == true)
            //{
            //    IsProcess1 = true;
            //    IsProcess2 = false;
            //    IsProcess5 = false;
            //    IsProcess6 = false;
            //    IsProcess4 = false;
            //    IsProcess3 = false;
            //}

        }

        private void backgroundWorker2_DoWork(object sender, DoWorkEventArgs e)
        {
            strDateTimeFCT81T = DateTime.Now.ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT81T0 = DateTime.Now.ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT81T1 = DateTime.Now.AddMinutes(-1).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT81T2 = DateTime.Now.AddMinutes(-2).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT81T3 = DateTime.Now.AddMinutes(-3).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT81T4 = DateTime.Now.AddMinutes(-4).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT81T5 = DateTime.Now.AddMinutes(-5).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT81T6 = DateTime.Now.AddMinutes(-6).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT81T7 = DateTime.Now.AddMinutes(-7).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT81T8 = DateTime.Now.AddMinutes(-8).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT81T9 = DateTime.Now.AddMinutes(-9).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT81T10 = DateTime.Now.AddMinutes(-10).ToString("yyyyMMddHHmmss");
            string strStartDate = ini.Read("StartDate", "RunTimeImport");
            string strEndDate = ini.Read("EndDate", "RunTimeImport");
            string strStartTime = ini.Read("StartTime", "RunTimeImport");
            string strEndTime = ini.Read("EndTime", "RunTimeImport");
            DayOfWeek dayOfWeekStart = DayOfWeek.Monday;
            DayOfWeek dayOfWeekEnd = DayOfWeek.Saturday;
            string[] arrStartTime = strStartTime.Split(":");
            Int32 intStartHour = Convert.ToInt32(arrStartTime[0]);
            Int32 intStartMinute = 0;
            if (arrStartTime.Length == 2)
            {
                intStartMinute = Convert.ToInt32(arrStartTime[1]);
            }
            string[] arrEndTime = strEndTime.Split(":");
            Int32 intEndHour = Convert.ToInt32(arrEndTime[0]);
            Int32 intEndMinute = 0;
            if (arrEndTime.Length == 2)
            {
                intEndMinute = Convert.ToInt32(arrEndTime[1]);
            }

            switch (strStartDate)
            {
                case "Sunday":
                    dayOfWeekStart = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekStart = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekStart = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekStart = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekStart = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekStart = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
            }

            switch (strEndDate)
            {
                case "Sunday":
                    dayOfWeekEnd = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekEnd = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekEnd = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekEnd = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekEnd = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekEnd = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
            }

            for (int i = 0; i < 11; i++)
            {

                switch (i)
                {
                    case 0:
                        strDateTimeFCT81T = strDateTimeBeforeFCT81T10;
                        break;
                    case 1:
                        strDateTimeFCT81T = strDateTimeBeforeFCT81T9;
                        break;
                    case 2:
                        strDateTimeFCT81T = strDateTimeBeforeFCT81T8;
                        break;
                    case 3:
                        strDateTimeFCT81T = strDateTimeBeforeFCT81T7;
                        break;
                    case 4:
                        strDateTimeFCT81T = strDateTimeBeforeFCT81T6;
                        break;
                    case 5:
                        strDateTimeFCT81T = strDateTimeBeforeFCT81T5;
                        break;
                    case 6:
                        strDateTimeFCT81T = strDateTimeBeforeFCT81T4;
                        break;
                    case 7:
                        strDateTimeFCT81T = strDateTimeBeforeFCT81T3;
                        break;
                    case 8:
                        strDateTimeFCT81T = strDateTimeBeforeFCT81T2;
                        break;
                    case 9:
                        strDateTimeFCT81T = strDateTimeBeforeFCT81T1;
                        break;
                    case 10:
                        strDateTimeFCT81T = strDateTimeBeforeFCT81T0;
                        break;
                    default:
                        break;
                }

                if (DateTime.Now.DayOfWeek >= dayOfWeekStart && DateTime.Now.DayOfWeek <= dayOfWeekEnd)
                {
                    if ((DateTime.Now.Hour >= intStartHour) && (DateTime.Now.Hour <= intEndHour))
                    {
                        if (DateTime.Now.Hour == intStartHour && DateTime.Now.Minute >= intStartMinute)
                        {
                            //Process_Import_FCT80T();

                            Process_Import_FCT81T();

                            //Process_Import_FCT82T();

                            //Process_Import_FCT84T();

                            //Process_Import_FCT85T();

                            //Process_Import_FCT83T();
                        }
                        else if (DateTime.Now.Hour > intStartHour &&
                                DateTime.Now.Hour == intEndHour && DateTime.Now.Minute <= intEndMinute)
                        {
                            //Process_Import_FCT80T();

                            Process_Import_FCT81T();

                            //Process_Import_FCT82T();                          

                            //Process_Import_FCT84T();

                            //Process_Import_FCT85T();

                            //Process_Import_FCT83T();
                        }
                        else if (DateTime.Now.Hour > intStartHour &&
                                DateTime.Now.Hour < intEndHour)
                        {
                            //Process_Import_FCT80T();

                            Process_Import_FCT81T();

                            //Process_Import_FCT82T();

                            //Process_Import_FCT84T();

                            //Process_Import_FCT85T();

                            //Process_Import_FCT83T();
                        }
                    }

                }

            }

            IsProcess2 = false;

        }

        private void backgroundWorker3_DoWork(object sender, DoWorkEventArgs e)
        {
            strDateTimeFCT82T = DateTime.Now.ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT82T0 = DateTime.Now.ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT82T1 = DateTime.Now.AddMinutes(-1).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT82T2 = DateTime.Now.AddMinutes(-2).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT82T3 = DateTime.Now.AddMinutes(-3).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT82T4 = DateTime.Now.AddMinutes(-4).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT82T5 = DateTime.Now.AddMinutes(-5).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT82T6 = DateTime.Now.AddMinutes(-6).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT82T7 = DateTime.Now.AddMinutes(-7).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT82T8 = DateTime.Now.AddMinutes(-8).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT82T9 = DateTime.Now.AddMinutes(-9).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT82T10 = DateTime.Now.AddMinutes(-10).ToString("yyyyMMddHHmmss");
            string strStartDate = ini.Read("StartDate", "RunTimeImport");
            string strEndDate = ini.Read("EndDate", "RunTimeImport");
            string strStartTime = ini.Read("StartTime", "RunTimeImport");
            string strEndTime = ini.Read("EndTime", "RunTimeImport");
            DayOfWeek dayOfWeekStart = DayOfWeek.Monday;
            DayOfWeek dayOfWeekEnd = DayOfWeek.Saturday;
            string[] arrStartTime = strStartTime.Split(":");
            Int32 intStartHour = Convert.ToInt32(arrStartTime[0]);
            Int32 intStartMinute = 0;
            if (arrStartTime.Length == 2)
            {
                intStartMinute = Convert.ToInt32(arrStartTime[1]);
            }
            string[] arrEndTime = strEndTime.Split(":");
            Int32 intEndHour = Convert.ToInt32(arrEndTime[0]);
            Int32 intEndMinute = 0;
            if (arrEndTime.Length == 2)
            {
                intEndMinute = Convert.ToInt32(arrEndTime[1]);
            }

            switch (strStartDate)
            {
                case "Sunday":
                    dayOfWeekStart = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekStart = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekStart = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekStart = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekStart = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekStart = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
            }

            switch (strEndDate)
            {
                case "Sunday":
                    dayOfWeekEnd = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekEnd = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekEnd = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekEnd = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekEnd = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekEnd = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
            }

            for (int i = 0; i < 11; i++)
            {

                switch (i)
                {
                    case 0:
                        strDateTimeFCT82T = strDateTimeBeforeFCT82T10;
                        break;
                    case 1:
                        strDateTimeFCT82T = strDateTimeBeforeFCT82T9;
                        break;
                    case 2:
                        strDateTimeFCT82T = strDateTimeBeforeFCT82T8;
                        break;
                    case 3:
                        strDateTimeFCT82T = strDateTimeBeforeFCT82T7;
                        break;
                    case 4:
                        strDateTimeFCT82T = strDateTimeBeforeFCT82T6;
                        break;
                    case 5:
                        strDateTimeFCT82T = strDateTimeBeforeFCT82T5;
                        break;
                    case 6:
                        strDateTimeFCT82T = strDateTimeBeforeFCT82T4;
                        break;
                    case 7:
                        strDateTimeFCT82T = strDateTimeBeforeFCT82T3;
                        break;
                    case 8:
                        strDateTimeFCT82T = strDateTimeBeforeFCT82T2;
                        break;
                    case 9:
                        strDateTimeFCT82T = strDateTimeBeforeFCT82T1;
                        break;
                    case 10:
                        strDateTimeFCT82T = strDateTimeBeforeFCT82T0;
                        break;
                    default:
                        break;
                }

                if (DateTime.Now.DayOfWeek >= dayOfWeekStart && DateTime.Now.DayOfWeek <= dayOfWeekEnd)
                {
                    if ((DateTime.Now.Hour >= intStartHour) && (DateTime.Now.Hour <= intEndHour))
                    {
                        if (DateTime.Now.Hour == intStartHour && DateTime.Now.Minute >= intStartMinute)
                        {
                            //Process_Import_FCT80T();

                            //Process_Import_FCT81T();

                            Process_Import_FCT82T();

                            //Process_Import_FCT83T();

                            //Process_Import_FCT84T();

                            //Process_Import_FCT85T();
                        }
                        else if (DateTime.Now.Hour > intStartHour &&
                                DateTime.Now.Hour == intEndHour && DateTime.Now.Minute <= intEndMinute)
                        {
                            //Process_Import_FCT80T();

                            //Process_Import_FCT81T();

                            Process_Import_FCT82T();

                            //Process_Import_FCT83T();

                            //Process_Import_FCT84T();

                            //Process_Import_FCT85T();
                        }
                        else if (DateTime.Now.Hour > intStartHour &&
                                DateTime.Now.Hour < intEndHour)
                        {
                            //Process_Import_FCT80T();

                            //Process_Import_FCT81T();

                            Process_Import_FCT82T();

                            //Process_Import_FCT83T();

                            //Process_Import_FCT84T();

                            //Process_Import_FCT85T();
                        }
                    }

                }

            }

            IsProcess3 = false;
        }

        private void backgroundWorker4_DoWork(object sender, DoWorkEventArgs e)
        {
            strDateTimeFCT83T = DateTime.Now.ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT83T0 = DateTime.Now.ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT83T1 = DateTime.Now.AddMinutes(-1).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT83T2 = DateTime.Now.AddMinutes(-2).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT83T3 = DateTime.Now.AddMinutes(-3).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT83T4 = DateTime.Now.AddMinutes(-4).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT83T5 = DateTime.Now.AddMinutes(-5).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT83T6 = DateTime.Now.AddMinutes(-6).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT83T7 = DateTime.Now.AddMinutes(-7).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT83T8 = DateTime.Now.AddMinutes(-8).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT83T9 = DateTime.Now.AddMinutes(-9).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT83T10 = DateTime.Now.AddMinutes(-10).ToString("yyyyMMddHHmmss");
            string strStartDate = ini.Read("StartDate", "RunTimeImport");
            string strEndDate = ini.Read("EndDate", "RunTimeImport");
            string strStartTime = ini.Read("StartTime", "RunTimeImport");
            string strEndTime = ini.Read("EndTime", "RunTimeImport");
            DayOfWeek dayOfWeekStart = DayOfWeek.Monday;
            DayOfWeek dayOfWeekEnd = DayOfWeek.Saturday;
            string[] arrStartTime = strStartTime.Split(":");
            Int32 intStartHour = Convert.ToInt32(arrStartTime[0]);
            Int32 intStartMinute = 0;
            if (arrStartTime.Length == 2)
            {
                intStartMinute = Convert.ToInt32(arrStartTime[1]);
            }
            string[] arrEndTime = strEndTime.Split(":");
            Int32 intEndHour = Convert.ToInt32(arrEndTime[0]);
            Int32 intEndMinute = 0;
            if (arrEndTime.Length == 2)
            {
                intEndMinute = Convert.ToInt32(arrEndTime[1]);
            }

            switch (strStartDate)
            {
                case "Sunday":
                    dayOfWeekStart = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekStart = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekStart = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekStart = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekStart = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekStart = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
            }

            switch (strEndDate)
            {
                case "Sunday":
                    dayOfWeekEnd = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekEnd = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekEnd = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekEnd = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekEnd = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekEnd = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
            }

            for (int i = 0; i < 11; i++)
            {

                switch (i)
                {
                    case 0:
                        strDateTimeFCT83T = strDateTimeBeforeFCT83T10;
                        break;
                    case 1:
                        strDateTimeFCT83T = strDateTimeBeforeFCT83T9;
                        break;
                    case 2:
                        strDateTimeFCT83T = strDateTimeBeforeFCT83T8;
                        break;
                    case 3:
                        strDateTimeFCT83T = strDateTimeBeforeFCT83T7;
                        break;
                    case 4:
                        strDateTimeFCT83T = strDateTimeBeforeFCT83T6;
                        break;
                    case 5:
                        strDateTimeFCT83T = strDateTimeBeforeFCT83T5;
                        break;
                    case 6:
                        strDateTimeFCT83T = strDateTimeBeforeFCT83T4;
                        break;
                    case 7:
                        strDateTimeFCT83T = strDateTimeBeforeFCT83T3;
                        break;
                    case 8:
                        strDateTimeFCT83T = strDateTimeBeforeFCT83T2;
                        break;
                    case 9:
                        strDateTimeFCT83T = strDateTimeBeforeFCT83T1;
                        break;
                    case 10:
                        strDateTimeFCT83T = strDateTimeBeforeFCT83T0;
                        break;
                    default:
                        break;
                }

                if (DateTime.Now.DayOfWeek >= dayOfWeekStart && DateTime.Now.DayOfWeek <= dayOfWeekEnd)
                {
                    if ((DateTime.Now.Hour >= intStartHour) && (DateTime.Now.Hour <= intEndHour))
                    {
                        if (DateTime.Now.Hour == intStartHour && DateTime.Now.Minute >= intStartMinute)
                        {
                            //Process_Import_FCT80T();

                            //Process_Import_FCT81T();

                            //Process_Import_FCT82T();

                            Process_Import_FCT83T();

                            //Process_Import_FCT84T();

                            //Process_Import_FCT85T();
                        }
                        else if (DateTime.Now.Hour > intStartHour &&
                                DateTime.Now.Hour == intEndHour && DateTime.Now.Minute <= intEndMinute)
                        {
                            //Process_Import_FCT80T();

                            //Process_Import_FCT81T();

                            //Process_Import_FCT82T();

                            Process_Import_FCT83T();

                            //Process_Import_FCT84T();

                            //Process_Import_FCT85T();
                        }
                        else if (DateTime.Now.Hour > intStartHour &&
                                DateTime.Now.Hour < intEndHour)
                        {
                            //Process_Import_FCT80T();

                            //Process_Import_FCT81T();

                            //Process_Import_FCT82T();

                            Process_Import_FCT83T();

                            //Process_Import_FCT84T();

                            //Process_Import_FCT85T();
                        }
                    }

                }

            }

            IsProcess4 = false;

        }

        private void backgroundWorker5_DoWork(object sender, DoWorkEventArgs e)
        {
            strDateTimeFCT84T = DateTime.Now.ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT84T0 = DateTime.Now.ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT84T1 = DateTime.Now.AddMinutes(-1).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT84T2 = DateTime.Now.AddMinutes(-2).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT84T3 = DateTime.Now.AddMinutes(-3).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT84T4 = DateTime.Now.AddMinutes(-4).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT84T5 = DateTime.Now.AddMinutes(-5).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT84T6 = DateTime.Now.AddMinutes(-6).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT84T7 = DateTime.Now.AddMinutes(-7).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT84T8 = DateTime.Now.AddMinutes(-8).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT84T9 = DateTime.Now.AddMinutes(-9).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT84T10 = DateTime.Now.AddMinutes(-10).ToString("yyyyMMddHHmmss");
            string strStartDate = ini.Read("StartDate", "RunTimeImport");
            string strEndDate = ini.Read("EndDate", "RunTimeImport");
            string strStartTime = ini.Read("StartTime", "RunTimeImport");
            string strEndTime = ini.Read("EndTime", "RunTimeImport");
            DayOfWeek dayOfWeekStart = DayOfWeek.Monday;
            DayOfWeek dayOfWeekEnd = DayOfWeek.Saturday;
            string[] arrStartTime = strStartTime.Split(":");
            Int32 intStartHour = Convert.ToInt32(arrStartTime[0]);
            Int32 intStartMinute = 0;
            if (arrStartTime.Length == 2)
            {
                intStartMinute = Convert.ToInt32(arrStartTime[1]);
            }
            string[] arrEndTime = strEndTime.Split(":");
            Int32 intEndHour = Convert.ToInt32(arrEndTime[0]);
            Int32 intEndMinute = 0;
            if (arrEndTime.Length == 2)
            {
                intEndMinute = Convert.ToInt32(arrEndTime[1]);
            }

            switch (strStartDate)
            {
                case "Sunday":
                    dayOfWeekStart = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekStart = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekStart = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekStart = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekStart = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekStart = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
            }

            switch (strEndDate)
            {
                case "Sunday":
                    dayOfWeekEnd = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekEnd = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekEnd = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekEnd = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekEnd = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekEnd = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
            }

            for (int i = 0; i < 11; i++)
            {

                switch (i)
                {
                    case 0:
                        strDateTimeFCT84T = strDateTimeBeforeFCT84T10;
                        break;
                    case 1:
                        strDateTimeFCT84T = strDateTimeBeforeFCT84T9;
                        break;
                    case 2:
                        strDateTimeFCT84T = strDateTimeBeforeFCT84T8;
                        break;
                    case 3:
                        strDateTimeFCT84T = strDateTimeBeforeFCT84T7;
                        break;
                    case 4:
                        strDateTimeFCT84T = strDateTimeBeforeFCT84T6;
                        break;
                    case 5:
                        strDateTimeFCT84T = strDateTimeBeforeFCT84T5;
                        break;
                    case 6:
                        strDateTimeFCT84T = strDateTimeBeforeFCT84T4;
                        break;
                    case 7:
                        strDateTimeFCT84T = strDateTimeBeforeFCT84T3;
                        break;
                    case 8:
                        strDateTimeFCT84T = strDateTimeBeforeFCT84T2;
                        break;
                    case 9:
                        strDateTimeFCT84T = strDateTimeBeforeFCT84T1;
                        break;
                    case 10:
                        strDateTimeFCT84T = strDateTimeBeforeFCT84T0;
                        break;
                    default:
                        break;
                }

                if (DateTime.Now.DayOfWeek >= dayOfWeekStart && DateTime.Now.DayOfWeek <= dayOfWeekEnd)
                {
                    if ((DateTime.Now.Hour >= intStartHour) && (DateTime.Now.Hour <= intEndHour))
                    {
                        if (DateTime.Now.Hour == intStartHour && DateTime.Now.Minute >= intStartMinute)
                        {
                            //Process_Import_FCT80T();

                            //Process_Import_FCT81T();

                            //Process_Import_FCT82T();

                            //Process_Import_FCT83T();

                            Process_Import_FCT84T();

                            //Process_Import_FCT85T();
                        }
                        else if (DateTime.Now.Hour > intStartHour &&
                                DateTime.Now.Hour == intEndHour && DateTime.Now.Minute <= intEndMinute)
                        {
                            //Process_Import_FCT80T();

                            //Process_Import_FCT81T();

                            //Process_Import_FCT82T();

                            //Process_Import_FCT83T();

                            Process_Import_FCT84T();

                            //Process_Import_FCT85T();
                        }
                        else if (DateTime.Now.Hour > intStartHour &&
                                DateTime.Now.Hour < intEndHour)
                        {
                            //Process_Import_FCT80T();

                            //Process_Import_FCT81T();

                            //Process_Import_FCT82T();

                            //Process_Import_FCT83T();

                            Process_Import_FCT84T();

                            //Process_Import_FCT85T();
                        }
                    }

                }

            }

            IsProcess5 = false;
        }

        private void backgroundWorker6_DoWork(object sender, DoWorkEventArgs e)
        {
            strDateTimeFCT85T = DateTime.Now.ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT85T0 = DateTime.Now.ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT85T1 = DateTime.Now.AddMinutes(-1).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT85T2 = DateTime.Now.AddMinutes(-2).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT85T3 = DateTime.Now.AddMinutes(-3).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT85T4 = DateTime.Now.AddMinutes(-4).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT85T5 = DateTime.Now.AddMinutes(-5).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT85T6 = DateTime.Now.AddMinutes(-6).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT85T7 = DateTime.Now.AddMinutes(-7).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT85T8 = DateTime.Now.AddMinutes(-8).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT85T9 = DateTime.Now.AddMinutes(-9).ToString("yyyyMMddHHmmss");
            strDateTimeBeforeFCT85T10 = DateTime.Now.AddMinutes(-10).ToString("yyyyMMddHHmmss");
            string strStartDate = ini.Read("StartDate", "RunTimeImport");
            string strEndDate = ini.Read("EndDate", "RunTimeImport");
            string strStartTime = ini.Read("StartTime", "RunTimeImport");
            string strEndTime = ini.Read("EndTime", "RunTimeImport");
            DayOfWeek dayOfWeekStart = DayOfWeek.Monday;
            DayOfWeek dayOfWeekEnd = DayOfWeek.Saturday;
            string[] arrStartTime = strStartTime.Split(":");
            Int32 intStartHour = Convert.ToInt32(arrStartTime[0]);
            Int32 intStartMinute = 0;
            if (arrStartTime.Length == 2)
            {
                intStartMinute = Convert.ToInt32(arrStartTime[1]);
            }
            string[] arrEndTime = strEndTime.Split(":");
            Int32 intEndHour = Convert.ToInt32(arrEndTime[0]);
            Int32 intEndMinute = 0;
            if (arrEndTime.Length == 2)
            {
                intEndMinute = Convert.ToInt32(arrEndTime[1]);
            }

            switch (strStartDate)
            {
                case "Sunday":
                    dayOfWeekStart = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekStart = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekStart = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekStart = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekStart = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekStart = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
            }

            switch (strEndDate)
            {
                case "Sunday":
                    dayOfWeekEnd = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekEnd = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekEnd = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekEnd = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekEnd = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekEnd = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
            }

            for (int i = 0; i < 11; i++)
            {

                switch (i)
                {
                    case 0:
                        strDateTimeFCT85T = strDateTimeBeforeFCT85T10;
                        break;
                    case 1:
                        strDateTimeFCT85T = strDateTimeBeforeFCT85T9;
                        break;
                    case 2:
                        strDateTimeFCT85T = strDateTimeBeforeFCT85T8;
                        break;
                    case 3:
                        strDateTimeFCT85T = strDateTimeBeforeFCT85T7;
                        break;
                    case 4:
                        strDateTimeFCT85T = strDateTimeBeforeFCT85T6;
                        break;
                    case 5:
                        strDateTimeFCT85T = strDateTimeBeforeFCT85T5;
                        break;
                    case 6:
                        strDateTimeFCT85T = strDateTimeBeforeFCT85T4;
                        break;
                    case 7:
                        strDateTimeFCT85T = strDateTimeBeforeFCT85T3;
                        break;
                    case 8:
                        strDateTimeFCT85T = strDateTimeBeforeFCT85T2;
                        break;
                    case 9:
                        strDateTimeFCT85T = strDateTimeBeforeFCT85T1;
                        break;
                    case 10:
                        strDateTimeFCT85T = strDateTimeBeforeFCT85T0;
                        break;
                    default:
                        break;
                }

                if (DateTime.Now.DayOfWeek >= dayOfWeekStart && DateTime.Now.DayOfWeek <= dayOfWeekEnd)
                {
                    if ((DateTime.Now.Hour >= intStartHour) && (DateTime.Now.Hour <= intEndHour))
                    {
                        if (DateTime.Now.Hour == intStartHour && DateTime.Now.Minute >= intStartMinute)
                        {
                            //Process_Import_FCT80T();

                            //Process_Import_FCT81T();

                            //Process_Import_FCT82T();

                            //Process_Import_FCT83T();

                            //Process_Import_FCT84T();

                            Process_Import_FCT85T();
                        }
                        else if (DateTime.Now.Hour > intStartHour &&
                                DateTime.Now.Hour == intEndHour && DateTime.Now.Minute <= intEndMinute)
                        {
                            //Process_Import_FCT80T();

                            //Process_Import_FCT81T();

                            //Process_Import_FCT82T();

                            //Process_Import_FCT83T();

                            //Process_Import_FCT84T();

                            Process_Import_FCT85T();
                        }
                        else if (DateTime.Now.Hour > intStartHour &&
                                DateTime.Now.Hour < intEndHour)
                        {
                            //Process_Import_FCT80T();

                            //Process_Import_FCT81T();

                            //Process_Import_FCT82T();

                            //Process_Import_FCT83T();

                            //Process_Import_FCT84T();

                            Process_Import_FCT85T();
                        }
                    }

                }

            }

            IsProcess6 = false;
        }

        private void backgroundWorker7_DoWork(object sender, DoWorkEventArgs e)
        {
            string strStartDate = ini.Read("StartDate", "RunTimeExport");
            string strEndDate = ini.Read("EndDate", "RunTimeExport");
            string strStartTime = ini.Read("StartTime", "RunTimeExport");
            string strEndTime = ini.Read("EndTime", "RunTimeExport");
            DayOfWeek dayOfWeekStart = DayOfWeek.Monday;
            DayOfWeek dayOfWeekEnd = DayOfWeek.Saturday;
            string[] arrStartTime = strStartTime.Split(":");
            Int32 intStartHour = Convert.ToInt32(arrStartTime[0]);
            Int32 intStartMinute = 0;
            if (arrStartTime.Length == 2)
            {
                intStartMinute = Convert.ToInt32(arrStartTime[1]);
            }
            string[] arrEndTime = strEndTime.Split(":");
            Int32 intEndHour = Convert.ToInt32(arrEndTime[0]);
            Int32 intEndMinute = 0;
            if (arrEndTime.Length == 2)
            {
                intEndMinute = Convert.ToInt32(arrEndTime[1]);
            }

            switch (strStartDate)
            {
                case "Sunday":
                    dayOfWeekStart = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekStart = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekStart = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekStart = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekStart = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekStart = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
            }

            switch (strEndDate)
            {
                case "Sunday":
                    dayOfWeekEnd = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekEnd = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekEnd = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekEnd = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekEnd = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekEnd = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
            }

            if (DateTime.Now.DayOfWeek >= dayOfWeekStart && DateTime.Now.DayOfWeek <= dayOfWeekEnd)
            {
                if ((DateTime.Now.Hour >= intStartHour) && (DateTime.Now.Hour <= intEndHour))
                {
                    if (DateTime.Now.Hour == intStartHour && DateTime.Now.Minute >= intStartMinute)
                    {
                        Process_Export_FCT90();


                    }
                    else if (DateTime.Now.Hour > intStartHour &&
                            DateTime.Now.Hour == intEndHour && DateTime.Now.Minute <= intEndMinute)
                    {
                        Process_Export_FCT90();


                    }
                    else if (DateTime.Now.Hour > intStartHour &&
                            DateTime.Now.Hour < intEndHour)
                    {
                        Process_Export_FCT90();


                    }
                }

            }

        }

        private void backgroundWorker8_DoWork(object sender, DoWorkEventArgs e)
        {
            string strStartDate = ini.Read("StartDate", "RunTimeExport");
            string strEndDate = ini.Read("EndDate", "RunTimeExport");
            string strStartTime = ini.Read("StartTime", "RunTimeExport");
            string strEndTime = ini.Read("EndTime", "RunTimeExport");
            DayOfWeek dayOfWeekStart = DayOfWeek.Monday;
            DayOfWeek dayOfWeekEnd = DayOfWeek.Saturday;
            string[] arrStartTime = strStartTime.Split(":");
            Int32 intStartHour = Convert.ToInt32(arrStartTime[0]);
            Int32 intStartMinute = 0;
            if (arrStartTime.Length == 2)
            {
                intStartMinute = Convert.ToInt32(arrStartTime[1]);
            }
            string[] arrEndTime = strEndTime.Split(":");
            Int32 intEndHour = Convert.ToInt32(arrEndTime[0]);
            Int32 intEndMinute = 0;
            if (arrEndTime.Length == 2)
            {
                intEndMinute = Convert.ToInt32(arrEndTime[1]);
            }

            switch (strStartDate)
            {
                case "Sunday":
                    dayOfWeekStart = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekStart = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekStart = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekStart = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekStart = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekStart = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
            }

            switch (strEndDate)
            {
                case "Sunday":
                    dayOfWeekEnd = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekEnd = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekEnd = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekEnd = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekEnd = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekEnd = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
            }

            if (DateTime.Now.DayOfWeek >= dayOfWeekStart && DateTime.Now.DayOfWeek <= dayOfWeekEnd)
            {
                if ((DateTime.Now.Hour >= intStartHour) && (DateTime.Now.Hour <= intEndHour))
                {
                    if (DateTime.Now.Hour == intStartHour && DateTime.Now.Minute >= intStartMinute)
                    {
                        Process_Export_FCT91();


                    }
                    else if (DateTime.Now.Hour > intStartHour &&
                            DateTime.Now.Hour == intEndHour && DateTime.Now.Minute <= intEndMinute)
                    {
                        Process_Export_FCT91();


                    }
                    else if (DateTime.Now.Hour > intStartHour &&
                            DateTime.Now.Hour < intEndHour)
                    {
                        Process_Export_FCT91();


                    }
                }

            }
        }

        private void backgroundWorker9_DoWork(object sender, DoWorkEventArgs e)
        {
            string strStartDate = ini.Read("StartDate", "RunTimeExportInventory");
            string strEndDate = ini.Read("EndDate", "RunTimeExportInventory");
            string strStartTime = ini.Read("StartTime", "RunTimeExportInventory");
            string strEndTime = ini.Read("EndTime", "RunTimeExportInventory");
            DayOfWeek dayOfWeekStart = DayOfWeek.Monday;
            DayOfWeek dayOfWeekEnd = DayOfWeek.Saturday;
            string[] arrStartTime = strStartTime.Split(":");
            Int32 intStartHour = Convert.ToInt32(arrStartTime[0]);
            Int32 intStartMinute = 0;
            if (arrStartTime.Length == 2)
            {
                intStartMinute = Convert.ToInt32(arrStartTime[1]);
            }
            string[] arrEndTime = strEndTime.Split(":");
            Int32 intEndHour = Convert.ToInt32(arrEndTime[0]);
            Int32 intEndMinute = 0;
            if (arrEndTime.Length == 2)
            {
                intEndMinute = Convert.ToInt32(arrEndTime[1]);
            }

            switch (strStartDate)
            {
                case "Sunday":
                    dayOfWeekStart = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekStart = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekStart = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekStart = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekStart = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekStart = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekStart = DayOfWeek.Monday;
                    break;
            }

            switch (strEndDate)
            {
                case "Sunday":
                    dayOfWeekEnd = DayOfWeek.Sunday;
                    break;
                case "Monday":
                    dayOfWeekEnd = DayOfWeek.Monday;
                    break;
                case "Tuesday":
                    dayOfWeekEnd = DayOfWeek.Tuesday;
                    break;
                case "Wednesday":
                    dayOfWeekEnd = DayOfWeek.Wednesday;
                    break;
                case "Thursday":
                    dayOfWeekEnd = DayOfWeek.Thursday;
                    break;
                case "Friday":
                    dayOfWeekEnd = DayOfWeek.Friday;
                    break;
                case "Saturday":
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
                default:
                    dayOfWeekEnd = DayOfWeek.Saturday;
                    break;
            }

            if (DateTime.Now.Hour < intStartHour)
            {

                if (DateTime.Now.Hour == intStartHour && DateTime.Now.Minute >= intStartMinute)
                {

                }
                else
                {
                    File.WriteAllText(PartFile_isProcess, "true");
                    isProcess = "true";
                }
            }

            if (DateTime.Now.DayOfWeek >= dayOfWeekStart && DateTime.Now.DayOfWeek <= dayOfWeekEnd)
            {
                if ((DateTime.Now.Hour >= intStartHour) && (DateTime.Now.Hour <= intEndHour))
                {
                    if (DateTime.Now.Hour == intStartHour && DateTime.Now.Minute >= intStartMinute && isProcess == "true")
                    {
                        Process_Export_FCT92();
                        File.WriteAllText(PartFile_isProcess, "false");
                        isProcess = "false";

                    }
                    else if (DateTime.Now.Hour > intStartHour &&
                            DateTime.Now.Hour == intEndHour && DateTime.Now.Minute <= intEndMinute && isProcess == "true")
                    {
                        Process_Export_FCT92();
                        File.WriteAllText(PartFile_isProcess, "false");
                        isProcess = "false";

                    }
                    else if (DateTime.Now.Hour > intStartHour &&
                            DateTime.Now.Hour < intEndHour && isProcess == "true")
                    {
                        Process_Export_FCT92();
                        File.WriteAllText(PartFile_isProcess, "false");
                        isProcess = "false";

                    }
                }

            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            txtDisplayImport1.Clear();
            txtDisplayImport2.Clear();
            txtDisplayImport3.Clear();
            txtDisplayImport4.Clear();
            txtDisplayImport5.Clear();
            txtDisplayImport6.Clear();
            txtDisplayExport1.Clear();
            txtDisplayExport2.Clear();
            txtDisplayExport3.Clear();
        }

        private void timer2_Tick(object sender, EventArgs e)
        {

        }

        private void timer3_Tick(object sender, EventArgs e)
        {





        }

        private void timer4_Tick(object sender, EventArgs e)
        {

            //ExecuteMultithreading();

            ExecuteMultithreadingImport();

        }

        private void timer5_Tick(object sender, EventArgs e)
        {



        }

        private void timerExport_Tick(object sender, EventArgs e)
        {
            ExecuteMultithreading();
        }
    }
}
